<?php $__env->startPush('title', get_phrase('Purchase History')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <section class="wishlist-content">
        <div class="profile-banner-area"></div>
        <div class="container profile-banner-area-container">
            <div class="row">
                <?php echo $__env->make('frontend.default.student.left_sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                <div class="col-lg-9">
                    <h4 class="g-title mb-5"><?php echo e(get_phrase('Payment History')); ?></h4>
                    <div class="my-panel purchase-history-panel">


                        <?php if($payments->count() > 0): ?>
                            <div class="table-responsive">
                                <table class="table eTable">
                                    <thead>
                                        <tr>
                                            <th><?php echo e(get_phrase('Course Name')); ?></th>
                                            <th><?php echo e(get_phrase('Date')); ?></th>
                                            <th><?php echo e(get_phrase('Payment Method')); ?></th>
                                            <th><?php echo e(get_phrase('Price')); ?></th>
                                            <th><?php echo e(get_phrase('Invoice')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($payment->course_title); ?></td>
                                                <td><?php echo e(date('Y-m-d', strtotime($payment->created_at))); ?></td>
                                                <td><?php echo e(ucfirst($payment->payment_type)); ?></td>
                                                <td><?php echo e(currency($payment->amount)); ?></td>
                                                <td>
                                                    <a href="<?php echo e(route('invoice', $payment->id)); ?>"
                                                        class="d-flex align-items-center justify-content-center btn btn-primary text-18 text-white py-3" data-bs-toggle="tooltip" data-bs-title="<?php echo e(get_phrase('Print Invoice')); ?>">
                                                        <i class="fi fi-rr-print d-inline-flex"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="row bg-white radius-10 mx-2">
                                <div class="com-md-12">
                                    <?php echo $__env->make('frontend.default.empty', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Pagination -->
            <?php if(count($payments) > 0): ?>
                <div class="entry-pagination">
                    <nav aria-label="Page navigation example">
                        <?php echo e($payments->links()); ?>

                    </nav>
                </div>
            <?php endif; ?>
            <!-- Pagination -->
        </div>
    </section>
    <!------------ purchase history area End  ------------>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?><?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.default', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/frontend/default/student/purchase_history/index.blade.php ENDPATH**/ ?>