<?php $__env->startPush('title', get_phrase('Instructor payout')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-4 px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('Instructor Payout')); ?>

                </h4>
            </div>
        </div>
    </div>

    <div class="ol-card p-4">
        <div class="ol-card-body">

            <div class="row mt-4">
                <div class="col-md-12">
                    <ul class="nav nav-tabs eNav-Tabs-custom eTab" id="myTab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php if(!isset($_GET['eDateRange'])): ?> active <?php endif; ?>" id="cHome-tab" data-bs-toggle="tab" data-bs-target="#cHome" type="button" role="tab" aria-controls="cHome"
                                aria-selected="true">
                                <?php echo e(get_phrase('Pending payouts')); ?>

                                <span></span>
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link <?php if(isset($_GET['eDateRange'])): ?> show active <?php endif; ?>" id="cProfile-tab" data-bs-toggle="tab" data-bs-target="#cProfile" type="button" role="tab" aria-controls="cProfile"
                                aria-selected="false">
                                <?php echo e(get_phrase('Completed payouts')); ?>

                                <span></span>
                            </button>
                        </li>
                    </ul>
                    <div class="tab-content eNav-Tabs-content" id="myTabContent">
                        <div class="tab-pane fade <?php if(!isset($_GET['eDateRange'])): ?> show active <?php endif; ?>" id="cHome" role="tabpanel" aria-labelledby="cHome-tab">
                            <div class="row print-d-none mt-4 row-gap-3">
                                <div class="col-md-6 pt-2 pt-md-0">
                                    <?php if(count($instructor_payout_incomplete) > 0): ?>
                                        <div class="custom-dropdown">
                                            <button class="dropdown-header btn ol-btn-light">
                                                <?php echo e(get_phrase('Export')); ?>

                                                <i class="fi-rr-file-export ms-2"></i>
                                            </button>
                                            <ul class="dropdown-list">
                                                <li>
                                                    <a class="dropdown-item" href="#" onclick="downloadPDF('.print-table', 'payout-request')"><i class="fi-rr-file-pdf"></i> <?php echo e(get_phrase('PDF')); ?></a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="#" onclick="window.print();"><i class="fi-rr-print"></i> <?php echo e(get_phrase('Print')); ?></a>
                                                </li>
                                            </ul>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="col-md-6">
                                    <form class="form-inline" action="<?php echo e(route('admin.instructor.payout.filter')); ?>" method="get">
                                        <div class="row mb-4">
                                            <div class="col-md-9">
                                                <div class="mb-3 position-relative position-relative">
                                                    <input type="text" class="form-control ol-form-control daterangepicker w-100"
                                                        name="eDateRange"value="<?php echo e(date('m/d/Y', $start_date) . ' - ' . date('m/d/Y', $end_date)); ?>" />
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <button type="submit" class="btn ol-btn-primary w-100" id="submit-button" onclick="update_date_range();"> <?php echo e(get_phrase('Filter')); ?></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <?php if(count($instructor_payout_incomplete) > 0): ?>
                                <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                                    <p class="admin-tInfo">
                                        <?php echo e(get_phrase('Showing') . ' ' . count($instructor_payout_incomplete) . ' ' . get_phrase('of') . ' ' . $instructor_payout_incomplete->total() . ' ' . get_phrase('data')); ?>

                                    </p>
                                </div>
                                <div class="table-responsive purchase_list mt-4" id="purchase_list">
                                    <table class="table eTable eTable-2 print-table">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col"><?php echo e(get_phrase('Name')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('Payout amount')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('	Payout date')); ?></th>
                                                <th scope="col" class="print-d-none"><?php echo e(get_phrase('Option')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $instructor_payout_incomplete; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $instructor_payout_incompleted): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <th scope="row">
                                                        <p class="row-number"><?php echo e(++$key); ?></p>
                                                    </th>
                                                    <td>
                                                        <div class="dAdmin_profile d-flex align-items-center min-w-200px">
                                                            <div class="dAdmin_profile_img">
                                                                <img class="img-fluid rounded-circle image-45" width="45" height="45" src="<?php echo e(get_image_by_id($instructor_payout_incompleted->user_id)); ?>" />
                                                            </div>
                                                            <div class="ms-1">
                                                                <h4 class="title fs-14px"><?php echo e(get_user_info($instructor_payout_incompleted->user_id)->name); ?></h4>
                                                                <p class="sub-title2 text-12px"><?php echo e(get_user_info($instructor_payout_incompleted->user_id)->email); ?></p>
                                                            </div>
                                                        </div>
                                                    </td>

                                                    <td>
                                                        <div class="dAdmin_info_name min-w-250px mr-50">
                                                            <p><?php echo e(currency($instructor_payout_incompleted->amount)); ?>

                                                            </p>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="dAdmin_info_name min-w-250px">
                                                            <p><?php echo e(date('D, d M Y', strtotime($instructor_payout_incompleted->created_at))); ?>

                                                            </p>
                                                        </div>
                                                    </td>

                                                    <td class="print-d-none">
                                                        <form action="<?php echo e(route('admin.instructor.payment')); ?>" method="post">
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="user_id" value="<?php echo e($instructor_payout_incompleted->user_id); ?>">
                                                            <input type="hidden" name="amount" value="<?php echo e($instructor_payout_incompleted->amount); ?>">
                                                            <input type="hidden" name="payout_id" value="<?php echo e($instructor_payout_incompleted->id); ?>">
                                                            <button type="submit" class="btn ol-btn-outline-secondary">
                                                                <i class="fi-rr-credit-card"></i>
                                                                <?php echo e(get_phrase('Pay')); ?></button>
                                                        </form>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <tr>

                                                <th></th>
                                                <th></th>
                                                <th><?php echo e(get_phrase('Total')); ?> :
                                                    <?php echo e(currency(App\Models\Payout::where('status', 0)->sum('amount'))); ?>

                                                </th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <?php echo $__env->make('admin.no_data', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php endif; ?>
                            <!-- Data info and Pagination -->
                            <?php if(count($instructor_payout_incomplete) > 0): ?>
                                <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                                    <p class="admin-tInfo">
                                        <?php echo e(get_phrase('Showing') . ' ' . count($instructor_payout_incomplete) . ' ' . get_phrase('of') . ' ' . $instructor_payout_incomplete->total() . ' ' . get_phrase('data')); ?>

                                    </p>
                                    <?php echo e($instructor_payout_incomplete->links()); ?>

                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="tab-pane fade <?php if(isset($_GET['eDateRange'])): ?> show active <?php endif; ?>" id="cProfile" role="tabpanel" aria-labelledby="cProfile-tab">

                            <div class="row print-d-none mt-4 row-gap-3">
                                <div class="col-md-6 pt-2 pt-md-0">
                                    <?php if(count($instructor_payout_complete) > 0): ?>
                                        <div class="custom-dropdown">
                                            <button class="dropdown-header btn ol-btn-light">
                                                <?php echo e(get_phrase('Export')); ?>

                                                <i class="fi-rr-file-export ms-2"></i>
                                            </button>
                                            <ul class="dropdown-list">
                                                <li>
                                                    <a class="dropdown-item" href="#" onclick="downloadPDF('.print-table', 'accepted-payout')"><i class="fi-rr-file-pdf"></i> <?php echo e(get_phrase('PDF')); ?></a>
                                                </li>
                                                <li>
                                                    <a class="dropdown-item" href="#" onclick="window.print();"><i class="fi-rr-print"></i> <?php echo e(get_phrase('Print')); ?></a>
                                                </li>
                                            </ul>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="col-md-6">
                                    <form class="form-inline" action="<?php echo e(route('admin.instructor.payout.filter')); ?>" method="get">
                                        <div class="row mb-4">
                                            <div class="col-md-9">
                                                <div class="mb-3 position-relative position-relative">
                                                    <input type="text" class="form-control ol-form-control daterangepicker w-100"
                                                        name="eDateRange"value="<?php echo e(date('m/d/Y', $start_date) . ' - ' . date('m/d/Y', $end_date)); ?>" />
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <button type="submit" class="btn ol-btn-primary w-100" id="submit-button" onclick="update_date_range();"> <?php echo e(get_phrase('Filter')); ?></button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <?php if(count($instructor_payout_complete) > 0): ?>
                                <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                                    <p class="admin-tInfo">
                                        <?php echo e(get_phrase('Showing') . ' ' . count($instructor_payout_complete) . ' ' . get_phrase('of') . ' ' . $instructor_payout_complete->total() . ' ' . get_phrase('data')); ?>

                                    </p>
                                </div>
                                <div class="table-responsive purchase_list" id="purchase_list">
                                    <table class="table eTable eTable-2 print-table">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col"><?php echo e(get_phrase('Name')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('Payout amount')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('Payment type')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('	Payout date')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $instructor_payout_complete; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $instructor_payouts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <th scope="row">
                                                        <p class="row-number"><?php echo e(++$key); ?></p>
                                                    </th>
                                                    <td>
                                                        <div class="dAdmin_profile d-flex align-items-center min-w-200px">
                                                            <div class="dAdmin_profile_img">
                                                                <img class="img-fluid rounded-circle image-45" width="45" height="45" src="<?php echo e(get_image_by_id($instructor_payouts->user_id)); ?>" />
                                                            </div>
                                                            <div class="ms-1">
                                                                <h4 class="title fs-14px"><?php echo e(get_user_info($instructor_payouts->user_id)->name); ?></h4>
                                                                <p class="sub-title2 text-12px"><?php echo e(get_user_info($instructor_payouts->user_id)->email); ?></p>
                                                            </div>
                                                        </div>
                                                    </td>

                                                    <td>
                                                        <div class="dAdmin_info_name min-w-250px">
                                                            <p><?php echo e(currency($instructor_payouts->amount)); ?></p>

                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="dAdmin_info_name min-w-250px">
                                                            <?php if($instructor_payouts->status != 0): ?>
                                                                <p> <?php echo e(get_phrase('Paid')); ?> </p>
                                                            <?php else: ?>
                                                                <p> <?php echo e(get_phrase('Pending')); ?> </p>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="dAdmin_info_name min-w-250px">
                                                            <p><?php echo e(date('D, d M Y', strtotime($instructor_payouts->updated_at))); ?>

                                                            </p>

                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <tr>

                                                <th></th>
                                                <th></th>
                                                <th><?php echo e(get_phrase('Total')); ?> :
                                                    <?php echo e(currency(App\Models\Payout::where('status', 1)->sum('amount'))); ?>

                                                </th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <?php echo $__env->make('admin.no_data', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php endif; ?>
                            <!-- Data info and Pagination -->
                            <?php if(count($instructor_payout_complete) > 0): ?>
                                <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                                    <p class="admin-tInfo">
                                        <?php echo e(get_phrase('Showing') . ' ' . count($instructor_payout_complete) . ' ' . get_phrase('of') . ' ' . $instructor_payout_complete->total() . ' ' . get_phrase('data')); ?>

                                    </p>
                                    <?php echo e($instructor_payout_complete->links()); ?>

                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script type="text/javascript">
        "use strict";

        function update_date_range() {
            var x = $("#selectedValue").html();
            $("#date_range").val(x);
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/instructor/payout.blade.php ENDPATH**/ ?>