<?php $__env->startPush('title', get_phrase('Purchase History')); ?>

<?php $__env->startSection('content'); ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-4 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('Purchase History')); ?>

                </h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="ol-card">
                <div class="ol-card-body p-3">
                    <div class="row print-d-none mb-3 mt-3">
                        <div class="col-md-6 pt-2 pt-md-0">
                            <div class="custom-dropdown">
                                <button class="dropdown-header btn ol-btn-light">
                                    <?php echo e(get_phrase('Export')); ?>

                                    <i class="fi-rr-file-export ms-2"></i>
                                </button>
                                <ul class="dropdown-list">
                                    <li>
                                        <a class="dropdown-item" href="#"
                                            onclick="downloadPDF('.print-table', 'bootcamp-payment-history')"><i
                                                class="fi-rr-file-pdf"></i> <?php echo e(get_phrase('PDF')); ?></a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#" onclick="window.print();"><i
                                                class="fi-rr-print"></i> <?php echo e(get_phrase('Print')); ?></a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Table -->
                    <?php if(count($purchases) > 0): ?>
                        <div
                            class="admin-tInfo-pagi d-flex justify-content-md-between justify-content-center align-items-center flex-wrap gr-15">
                            <p class="admin-tInfo">
                                <?php echo e(get_phrase('Showing') . ' ' . count($purchases) . ' ' . get_phrase('of') . ' ' . $purchases->total() . ' ' . get_phrase('data')); ?>

                            </p>
                        </div>
                        <div class="table-responsive course_list" id="course_list">
                            <table class="table eTable eTable-2 print-table">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col"><?php echo e(get_phrase('User')); ?></th>
                                        <th scope="col"><?php echo e(get_phrase('Bootcamp')); ?></th>
                                        <th scope="col"><?php echo e(get_phrase('Price')); ?></th>
                                        <th scope="col"><?php echo e(get_phrase('Issue date')); ?></th>
                                        <th scope="col"><?php echo e(get_phrase('Payment method')); ?></th>
                                        <th scope="col" class="print-d-none"><?php echo e(get_phrase('Options')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row">
                                                <p class="row-number"><?php echo e($key + 1); ?></p>
                                            </th>

                                            <td>
                                                <div class="dAdmin_profile d-flex align-items-center min-w-200px">
                                                    <div class="dAdmin_profile_img">
                                                        <img class="img-fluid rounded-circle image-45" width="40" height="40" src="<?php echo e(get_image(get_user_info($report->user_id)->photo)); ?>">
                                                    </div>
                                                    <div class="ms-1 mt-1">
                                                        <h4 class="title fs-14px"><?php echo e(get_user_info($report->user_id)->name); ?></h4>
                                                        <p class="sub-title2 text-12px"><?php echo e(get_user_info($report->user_id)->email); ?></p>
                                                    </div>
                                                </div>
                                            </td>

                                            <td>
                                                <div class="sub-title2 text-12px min-w-150px">
                                                    <a
                                                        href="<?php echo e(route('bootcamp.details', $report->slug)); ?>"><?php echo e($report->title); ?></a>
                                                </div>
                                            </td>

                                            <td>
                                                <div class="sub-title2 text-12px min-w-150px">
                                                    <p><?php echo e(currency(number_format($report->price, 2))); ?></p>
                                                    <p><span><?php echo e(get_phrase('Admin :')); ?> </span><?php echo e(currency(number_format($report->admin_revenue, 2))); ?></p>
                                                    <p><span><?php echo e(get_phrase('Author :')); ?> </span><?php echo e(currency(number_format($report->instructor_revenue, 2))); ?></p>
                                                </div>
                                            </td>

                                            <td>
                                                <div class="sub-title2 text-12px">
                                                    <p><?php echo e(date('d-M-y', strtotime($report->purchase_date))); ?></p>
                                                </div>
                                            </td>

                                            <td>
                                                <div class="sub-title2 text-12px text-capitalize">
                                                    <p><?php echo e($report->payment_method); ?></p>
                                                </div>
                                            </td>

                                            <td class="print-d-none">
                                                <div class="sub-title2 text-12px text-capitalize">
                                                    <a href="<?php echo e(route('admin.bootcamp.purchase.invoice', $report->id)); ?>"
                                                        class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px">
                                                        <span><?php echo e(get_phrase('Invoice')); ?></span>
                                                    </a>
                                                </div>
                                            </td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('admin.no_data', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?>
                    <!-- Data info and Pagination -->
                    <?php if(count($purchases) > 0): ?>
                        <div
                            class="admin-tInfo-pagi d-flex justify-content-md-between justify-content-center align-items-center flex-wrap gr-15">
                            <p class="admin-tInfo">
                                <?php echo e(get_phrase('Showing') . ' ' . count($purchases) . ' ' . get_phrase('of') . ' ' . $purchases->total() . ' ' . get_phrase('data')); ?>

                            </p>
                            <?php echo e($purchases->links()); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/bootcamp/purchase_history.blade.php ENDPATH**/ ?>