<?php $__env->startPush('title', get_phrase('Bootcamp Category')); ?>


<?php $__env->startSection('content'); ?>
<div class="ol-card radius-8px">
    <div class="ol-card-body my-3 py-12px px-20px">
        <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
            <h4 class="title fs-16px">
                <i class="fi-rr-settings-sliders me-2"></i>
                <?php echo e(get_phrase('Bootcamp Category')); ?> <span class="text-muted"></span>
            </h4>

            <a onclick="ajaxModal('<?php echo e(route('modal', ['admin.bootcamp_category.create'])); ?>', '<?php echo e(get_phrase('Add new category')); ?>')" href="#"
                class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px">
                <span class="fi-rr-plus"></span>
                <span><?php echo e(get_phrase('Add new category')); ?></span>
            </a>
        </div>
    </div>
</div>

<?php if($categories->count() > 0): ?>
    <div class="row g-2 g-sm-3 mb-3 row-cols-1 row-colssm-2 row-cols-md-3 row-cols-lg-4">
        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col">
                <div class="ol-card card-hover">
                    <div class="ol-card-body px-20px py-3 d-flex justify-content-between">
                        <div>
                            <p class="title card-title-hover"><?php echo e($category->title); ?></p>
                            <p class="sub-title text-12px mt-2"><?php echo e(get_phrase('Total bootcamps')); ?> <?php echo e(count_bootcamps_by_category($category->id)); ?></p>
                        </div>

                        <div class="dropdown ol-icon-dropdown">
                            <button class="btn ol-btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <span class="fi-rr-menu-dots-vertical"></span>
                            </button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="javascript:void(0);" onclick="ajaxModal('<?php echo e(route('modal', ['admin.bootcamp_category.edit', 'id' => $category->id])); ?>', '<?php echo e(get_phrase('Edit category')); ?>')"><?php echo e(get_phrase('Edit')); ?></a></li>
                                <li><a class="dropdown-item" href="javascript:void(0);" onclick="confirmModal('<?php echo e(route('admin.bootcamp.category.delete', $category->id)); ?>')"><?php echo e(get_phrase('Delete')); ?></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <div class="admin-tInfo-pagi d-flex justify-content-md-between justify-content-center align-items-center flex-wrap gr-15 mb-5">
        <p class="admin-tInfo">
            <?php echo e(get_phrase('Showing') . ' ' . count($categories) . ' ' . get_phrase('of') . ' ' . $categories->total() . ' ' . get_phrase('data')); ?>

        </p>
        <?php echo e($categories->links()); ?>

    </div>
<?php else: ?>
    <div class="ol-card">
        <div class="ol-card-body">
            <?php echo $__env->make('admin.no_data', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/bootcamp_category/index.blade.php ENDPATH**/ ?>