
<?php $__env->startPush('title', get_phrase('Resume Manager')); ?>
<?php $__env->startSection('content'); ?>

    <?php
        $auth = auth()->user();
        $educations = json_decode($auth->educations, true);
    ?>

    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('Manage resume')); ?>

                </h4>

                <a href="#" onclick="ajaxModal('<?php echo e(route('modal', ['instructor.resume.add_education'])); ?>', '<?php echo e(get_phrase('Add New Education')); ?>')" class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px">
                    <span class="fi-rr-plus"></span>
                    <span><?php echo e(get_phrase('Add New Education')); ?></span>
                </a>
            </div>
        </div>
    </div>


    <!-- Start Admin area -->
    <div class="row">
        <div class="col-12">
            <div class="ol-card">
                <div class="ol-card-body p-3 mb-5">
                    

                    <div class="row">
                        <div class="col-md-12">
                            <?php if(isset($educations) && count($educations) > 0): ?>
                                <div
                                    class="admin-tInfo-pagi d-flex justify-content-md-between justify-content-center align-items-center flex-wrap gr-15">
                                    <p class="admin-tInfo">
                                        <?php echo e(get_phrase('Showing') . ' ' . count($educations) . ' ' . get_phrase('data')); ?>

                                    </p>
                                </div>
                                <div class="table-responsive overflow-auto course_list overflow-auto" id="course_list">
                                    <table class="table eTable eTable-2 print-table">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col"><?php echo e(get_phrase('Title')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('City & Country')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('Start Date')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('End Date')); ?></th>
                                                <th scope="col" class="print-d-none"><?php echo e(get_phrase('Status')); ?></th>
                                                <th scope="col" class="print-d-none"><?php echo e(get_phrase('Options')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $educations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $education): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php $index = $key ?>
                                                <tr>
                                                    <th scope="row">
                                                        <p class="row-number"><?php echo e(++$key); ?></p>
                                                    </th>
                                                    <td>
                                                        <div class="dAdmin_profile d-flex align-items-center min-w-200px">
                                                            <div class="dAdmin_profile_name">
                                                                <h4 class="title fs-14px">
                                                                    <?php echo e(ucfirst($education['title'])); ?>

                                                                </h4>

                                                                <p class="sub-title2 text-12px">
                                                                    <?php echo e(get_phrase('Institute')); ?>:
                                                                    <?php echo e(get_phrase($education['institute'])); ?></p>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="sub-title2 text-12px">
                                                            <p><?php echo e($education['city']. ', ' .$education['country']); ?></p>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="sub-title2 text-12px">
                                                            <p><?php echo e($education['start_date']); ?></p>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="sub-title2 text-12px">
                                                            <p><?php echo e($education['end_date'] ?? 'N/A'); ?></p>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="dAdmin_info_name min-w-150px">
                                                            <?php if($education['status'] == 'completed'): ?>
                                                                <p class="eBadge ebg-soft-success">
                                                                    <?php echo e(get_phrase('Completed')); ?>

                                                                </p>
                                                            <?php else: ?>
                                                                <p class="eBadge ebg-soft-danger">
                                                                    <?php echo e(get_phrase('Ongoing')); ?>

                                                                </p>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                    <td class="print-d-none">

                                                        <div
                                                            class="dropdown ol-icon-dropdown ol-icon-dropdown-transparent">
                                                            <button class="btn ol-btn-secondary dropdown-toggle"
                                                                type="button" data-bs-toggle="dropdown"
                                                                aria-expanded="false">
                                                                <span class="fi-rr-menu-dots-vertical"></span>
                                                            </button>

                                                            <ul class="dropdown-menu">
                                                                <li>
                                                                    <a class="dropdown-item"
                                                                        href="#" onclick="ajaxModal('<?php echo e(route('modal', ['instructor.resume.edit_education', 'index' => $index])); ?>', '<?php echo e(get_phrase('Update Education')); ?>')"><?php echo e(get_phrase('Edit')); ?></a>
                                                                </li>
                                                                <li>
                                                                    <a class="dropdown-item"
                                                                        onclick="confirmModal('<?php echo e(route('instructor.manage.education.remove', $index)); ?>')"
                                                                        href="javascript:void(0)"><?php echo e(get_phrase('Delete')); ?></a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php else: ?>
                                <?php echo $__env->make('instructor.no_data', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Admin area -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.instructor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/instructor/resume/index.blade.php ENDPATH**/ ?>