<?php $__env->startPush('title', get_phrase('Course Manager')); ?>
<?php $__env->startSection('content'); ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('Manage Courses')); ?>

                </h4>

                <a href="<?php echo e(route('admin.course.create')); ?>"class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px">
                    <span class="fi-rr-plus"></span>
                    <span><?php echo e(get_phrase('Add New Course')); ?></span>
                </a>
            </div>
        </div>
    </div>

    <div class="row g-2 g-sm-3 mb-3 row-cols-1 row-cols-sm-2 row-cols-md-4 row-cols-lg-4 row-cols-xl-5">
        <div class="col">
            <a href="<?php echo e(route('admin.courses', ['status' => 'active'])); ?>" class="d-block">
                <div class="ol-card card-hover h-100">
                    <div class="ol-card-body px-3 py-12px">
                        <div class="d-flex align-items-center cg-12px">
                            <div>
                                <p class="sub-title fs-14px fw-semibold mb-2"><?php echo e($active_courses); ?></p>
                                <h6 class="title fs-14px mb-1"><?php echo e(get_phrase('Active courses')); ?></h6>
                            </div>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="col">
            <a href="<?php echo e(route('admin.courses', ['status' => 'pending'])); ?>" class="d-block">
                <div class="ol-card card-hover h-100">
                    <div class="ol-card-body px-3 py-12px">
                        <div class="d-flex align-items-center cg-12px">
                            <div>
                                <p class="sub-title fs-14px fw-semibold mb-2"><?php echo e($pending_courses); ?></p>
                                <h6 class="title fs-14px mb-1"><?php echo e(get_phrase('Pending courses')); ?></h6>
                            </div>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="col">
            <a href="<?php echo e(route('admin.courses', ['status' => 'upcoming'])); ?>" class="d-block">
                <div class="ol-card card-hover h-100">
                    <div class="ol-card-body px-3 py-12px">
                        <div class="d-flex align-items-center cg-12px">
                            <div>
                                <p class="sub-title fs-14px fw-semibold mb-2"><?php echo e($upcoming_courses); ?></p>
                                <h6 class="title fs-14px mb-1"><?php echo e(get_phrase('Upcoming courses')); ?></h6>
                            </div>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="col">
            <a href="<?php echo e(route('admin.courses', ['price' => 'free'])); ?>" class="d-block">
                <div class="ol-card card-hover h-100">
                    <div class="ol-card-body px-3 py-12px">
                        <div class="d-flex align-items-center cg-12px">
                            <div>
                                <p class="sub-title fs-14px fw-semibold mb-2"><?php echo e($free_courses); ?></p>
                                <h6 class="title fs-14px mb-1"><?php echo e(get_phrase('Free courses')); ?></h6>
                            </div>
                        </div>
                    </div>
                </div>
            </a>
        </div>
        <div class="col">
            <a href="<?php echo e(route('admin.courses', ['price' => 'paid'])); ?>" class="d-block">
                <div class="ol-card card-hover h-100">
                    <div class="ol-card-body px-3 py-12px">
                        <div class="d-flex align-items-center cg-12px">
                            <div>
                                <p class="sub-title fs-14px fw-semibold mb-2"><?php echo e($paid_courses); ?></p>
                                <h6 class="title fs-14px mb-1"><?php echo e(get_phrase('Paid courses')); ?></h6>
                            </div>
                        </div>
                    </div>
                </div>
            </a>
        </div>
    </div>

    <!-- Start Admin area -->
    <div class="row">
        <div class="col-12">
            <div class="ol-card">
                <div class="ol-card-body p-3 mb-5">
                    <div class="row mt-3 mb-4">
                        <div class="col-md-6 d-flex align-items-center gap-3">
                            <div class="custom-dropdown ms-2">
                                <button class="dropdown-header btn ol-btn-light">
                                    <?php echo e(get_phrase('Export')); ?>

                                    <i class="fi-rr-file-export ms-2"></i>
                                </button>
                                <ul class="dropdown-list">
                                    <li>
                                        <a class="dropdown-item export-btn" href="#" onclick="downloadPDF('.print-table', 'course-list')"><i class="fi-rr-file-pdf"></i> <?php echo e(get_phrase('PDF')); ?></a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item export-btn" href="#" onclick="window.print();"><i class="fi-rr-print"></i> <?php echo e(get_phrase('Print')); ?></a>
                                    </li>
                                </ul>
                            </div>

                            <div class="custom-dropdown dropdown-filter <?php if(!isset($_GET) || (isset($_GET) && count($_GET) == 0)): ?>  <?php endif; ?>">
                                <button class="dropdown-header btn ol-btn-light">
                                    <i class="fi-rr-filter me-2"></i>
                                    <?php echo e(get_phrase('Filter')); ?>


                                    <?php if(isset($_GET) && count($_GET)): ?>
                                        <span class="text-12px">
                                            (<?php echo e(count($_GET)); ?>)
                                        </span>
                                    <?php endif; ?>
                                </button>
                                <ul class="dropdown-list w-250px">
                                    <li>
                                        <form id="filter-dropdown" action="<?php echo e(route('admin.courses')); ?>" method="get">
                                            <div class="filter-option d-flex flex-column gap-3">
                                                <div>
                                                    <label for="eDataList" class="form-label ol-form-label"><?php echo e(get_phrase('Category')); ?></label>
                                                    <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="category" data-placeholder="Type to search...">
                                                        <option value="all"><?php echo e(get_phrase('All')); ?></option>

                                                        <?php $__currentLoopData = App\Models\Category::where('parent_id', 0)->orderBy('title', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($category->slug); ?>"<?php if(isset($parent_cat) && $parent_cat == $category->slug): ?> selected <?php endif; ?>>
                                                                <?php echo e($category->title); ?></option>

                                                            <?php $__currentLoopData = $category->childs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($sub_category->slug); ?>"<?php if(isset($child_cat) && $child_cat == $sub_category->slug): ?> selected <?php endif; ?>>
                                                                    --<?php echo e($sub_category->title); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div>
                                                    <label for="eDataList" class="form-label ol-form-label"><?php echo e(get_phrase('Status')); ?></label>
                                                    <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="status" class="ol-select-2" data-placeholder="Type to search...">
                                                        <option value="all"><?php echo e(get_phrase('All')); ?>

                                                        </option>

                                                        <option value="active"<?php if(isset($status) && $status == 'active'): ?> selected <?php endif; ?>><?php echo e(get_phrase('Active')); ?> </option>
                                                        <option value="inactive"<?php if(isset($status) && $status == 'inactive'): ?> selected <?php endif; ?>><?php echo e(get_phrase('Inactive')); ?> </option>
                                                        <option value="pending"<?php if(isset($status) && $status == 'pending'): ?> selected <?php endif; ?>><?php echo e(get_phrase('Pending')); ?> </option>
                                                        <option value="upcoming"<?php if(isset($status) && $status == 'upcoming'): ?> selected <?php endif; ?>><?php echo e(get_phrase('Upcoming')); ?> </option>
                                                        <option value="private"<?php if(isset($status) && $status == 'private'): ?> selected <?php endif; ?>><?php echo e(get_phrase('Private')); ?> </option>
                                                        <option value="draft"<?php if(isset($status) && $status == 'draft'): ?> selected <?php endif; ?>><?php echo e(get_phrase('Draft')); ?> </option>
                                                    </select>
                                                </div>

                                                <div>
                                                    <label for="eDataList" class="form-label ol-form-label"><?php echo e(get_phrase('Instructor')); ?></label>
                                                    <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="instructor" class="ol-select-2" data-placeholder="Type to search...">
                                                        <option value="all"><?php echo e(get_phrase('All')); ?>

                                                        </option>
                                                        <?php $__currentLoopData = App\Models\Course::select('user_id')->distinct()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($course->user_id); ?>"<?php if(isset($instructor) && $instructor == $course->user_id): ?> selected <?php endif; ?>>
                                                                <?php echo e(ucfirst(get_user_info($course->user_id)->name)); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div>
                                                    <label for="eDataList" class="form-label ol-form-label"><?php echo e(get_phrase('Price')); ?></label>
                                                    <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="price" class="ol-select-2" data-placeholder="Type to search...">
                                                        <option value="all"><?php echo e(get_phrase('All')); ?>

                                                        </option>

                                                        <option value="free"<?php if(isset($price) && $price == 'free'): ?> selected <?php endif; ?>>
                                                            <?php echo e(get_phrase('Free')); ?></option>
                                                        <option value="paid"<?php if(isset($price) && $price == 'paid'): ?> selected <?php endif; ?>>
                                                            <?php echo e(get_phrase('Paid')); ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="filter-button d-flex justify-content-end align-items-center mt-3">
                                                <button type="submit" class="ol-btn-primary"><?php echo e(get_phrase('Apply')); ?></button>
                                            </div>
                                        </form>
                                    </li>
                                </ul>
                            </div>

                            <?php if(isset($_GET) && count($_GET) > 0): ?>
                                <a href="<?php echo e(route('admin.courses')); ?>" class="me-2" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Clear')); ?>"><i class="fi-rr-cross-circle"></i></a>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-6 mt-3 mt-md-0">
                            <form action="<?php echo e(route('admin.courses')); ?>" method="get">
                                <div class="row row-gap-3">
                                    <div class="col-md-9">
                                        <div class="search-input flex-grow-1">
                                            <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="<?php echo e(get_phrase('Search Title')); ?>" class="ol-form-control form-control" />
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <button type="submit" class="btn ol-btn-primary w-100" id="submit-button"><?php echo e(get_phrase('Search')); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <?php if($courses->count() > 0): ?>
                                <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                                    <p class="admin-tInfo">
                                        <?php echo e(get_phrase('Showing') . ' ' . count($courses) . ' ' . get_phrase('of') . ' ' . $courses->total() . ' ' . get_phrase('data')); ?>

                                    </p>
                                </div>
                                <div class="table-responsive overflow-auto course_list overflow-auto" id="course_list">
                                    <table class="table eTable eTable-2 print-table">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col"><?php echo e(get_phrase('Title')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('Category')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('Lesson & Section')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('Enrolled Student')); ?></th>
                                                <th scope="col" class="print-d-none"><?php echo e(get_phrase('Status')); ?></th>
                                                <th scope="col"><?php echo e(get_phrase('Price')); ?></th>
                                                <th scope="col" class="print-d-none"><?php echo e(get_phrase('Options')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $query = App\Models\Watch_history::where('course_id', $row->id)
                                                        ->where('student_id', auth()->user()->id)
                                                        ->first();

                                                    $query1 = App\Models\Lesson::where('course_id', $row->id)
                                                        ->orderBy('sort', 'asc')
                                                        ->first();

                                                    if (isset($query->watching_lesson_id) && $query->watching_lesson_id != '') {
                                                        $watching_lesson_id = $query->watching_lesson_id;
                                                    } elseif (isset($query1->id)) {
                                                        $watching_lesson_id = $query1->id;
                                                    }
                                                ?>
                                                <tr>
                                                    <th scope="row">
                                                        <p class="row-number"><?php echo e(++$key); ?></p>
                                                    </th>
                                                    <td>
                                                        <div class="dAdmin_profile d-flex align-items-center min-w-200px">
                                                            <div class="dAdmin_profile_name">
                                                                <h4 class="title fs-14px">
                                                                    <a href="<?php echo e(route('admin.course.edit', [$row->id, 'tab' => 'curriculum'])); ?>"><?php echo e(ucfirst($row->title)); ?></a>
                                                                </h4>

                                                                <a href="<?php echo e(route('admin.courses', ['instructor' => $row->user_id])); ?>">
                                                                    <p class="sub-title2 text-12px">
                                                                        <?php echo e(get_phrase('Instructor')); ?>:
                                                                        <?php echo e(get_user_info($row->user_id)->name); ?></p>
                                                                    <p class="sub-title2 text-12px"><?php echo e(get_phrase('Email')); ?>:
                                                                        <?php echo e(get_user_info($row->user_id)->email); ?></p>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="sub-title2 text-12px">
                                                            <a href="<?php echo e(route('admin.courses', ['category' => $row->category->slug])); ?>"><?php echo e(category_by_course($row->category_id)->title); ?></a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="sub-title2 text-12px">
                                                            <a href="<?php echo e(route('admin.course.edit', [$row->id, 'tab' => 'curriculum'])); ?>">
                                                                <p><?php echo e(get_phrase('Lesson')); ?>: <?php echo e(lesson_count($row->id)); ?> </p>
                                                                <p> <?php echo e(get_phrase('Section')); ?>: <?php echo e(section_count($row->id)); ?> </p>
                                                            </a>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="sub-title2 text-12px">
                                                            <p><?php echo e(get_phrase('Enrollment History')); ?>:
                                                                <?php echo e(course_enrollments($row->id)); ?>

                                                            </p>
                                                        </div>
                                                    </td>
                                                    <td class="print-d-none">
                                                        <span class="badge bg-<?php echo e($row->status); ?>"><?php echo e(get_phrase(ucfirst($row->status))); ?></span>
                                                    </td>
                                                    <td>
                                                        <div class="dAdmin_info_name min-w-150px">
                                                            <?php if($row->is_paid == 0): ?>
                                                                <p class="eBadge ebg-soft-success">
                                                                    <?php echo e(get_phrase('Free')); ?>

                                                                </p>
                                                            <?php elseif($row->discount_flag == 1): ?>
                                                                <p><?php echo e(currency($row->discounted_price)); ?> <del><?php echo e(currency($row->price)); ?></del></p>
                                                            <?php else: ?>
                                                                <p><?php echo e(currency($row->price)); ?></p>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>
                                                    <td class="print-d-none">

                                                        <div class="dropdown ol-icon-dropdown ol-icon-dropdown-transparent">
                                                            <button class="btn ol-btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                                <span class="fi-rr-menu-dots-vertical"></span>
                                                            </button>

                                                            <ul class="dropdown-menu">
                                                                <li>
                                                                    <a class="dropdown-item" target="_blank" href="<?php echo e(route('course.details', $row->slug)); ?>"><?php echo e(get_phrase('View Course On Frontend')); ?></a>
                                                                </li>

                                                                <li>
                                                                    <a class="dropdown-item" target="_blank" href="<?php echo e(route('course.player', ['slug' => $row->slug])); ?>"><?php echo e(get_phrase('Go To Course Playing Page')); ?></a>
                                                                </li>
                                                                <li>
                                                                    <a class="dropdown-item" href="<?php echo e(route('admin.course.edit', [$row->id, 'tab' => 'basic'])); ?>"><?php echo e(get_phrase('Edit Course')); ?></a>
                                                                </li>
                                                                <li>
                                                                    <a class="dropdown-item" onclick="confirmModal('<?php echo e(route('admin.course.duplicate', $row->id)); ?>')" href="javascript:void(0)"><?php echo e(get_phrase('Duplicate Course')); ?></a>
                                                                </li>

                                                                <?php if($row->status == 'active'): ?>
                                                                    <li>
                                                                        <a class="dropdown-item" onclick="confirmModal('<?php echo e(route('admin.course.status', ['type' => 'inactive', 'id' => $row->id])); ?>')" href="#"><?php echo e(get_phrase('Make As Inactive')); ?></a>
                                                                    </li>
                                                                <?php elseif($row->status == 'pending'): ?>
                                                                    <li>
                                                                        <a class="dropdown-item" onclick="ajaxModal('<?php echo e(route('view', ['path' => 'admin.course.course_approval', 'course_id' => $row->id])); ?>', '<?php echo e(get_phrase('Write a congratulatory message')); ?>')" href="#"><?php echo e(get_phrase('Make As Active')); ?></a>
                                                                    </li>
                                                                <?php else: ?>
                                                                    <li>
                                                                        <a class="dropdown-item" onclick="confirmModal('<?php echo e(route('admin.course.status', ['type' => 'active', 'id' => $row->id])); ?>')" href="#"><?php echo e(get_phrase('Make As Active')); ?></a>
                                                                    </li>
                                                                <?php endif; ?>
                                                                <li>
                                                                    <a class="dropdown-item" onclick="confirmModal('<?php echo e(route('admin.course.delete', $row->id)); ?>')" href="javascript:void(0)"><?php echo e(get_phrase('Delete Course')); ?></a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                                    <p class="admin-tInfo">
                                        <?php echo e(get_phrase('Showing') . ' ' . count($courses) . ' ' . get_phrase('of') . ' ' . $courses->total() . ' ' . get_phrase('data')); ?>

                                    </p>
                                    <?php echo e($courses->links()); ?>

                                </div>
                            <?php else: ?>
                                <?php echo $__env->make('admin.no_data', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Admin area -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/course/index.blade.php ENDPATH**/ ?>