<?php $__env->startPush('title', get_phrase('إدارة المعاملات')); ?>

<?php $__env->startSection('content'); ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-credit-card me-2"></i>
                    <?php echo e(get_phrase('إدارة المعاملات')); ?>

                </h4>

                <a href="<?php echo e(route('admin.wallet.add-balance.show')); ?>" class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px">
                    <span class="fi-rr-plus"></span>
                    <span><?php echo e(get_phrase('إضافة رصيد')); ?></span>
                </a>
            </div>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">جميع المعاملات</h6>
            <form action="<?php echo e(route('admin.wallet.transactions')); ?>" method="GET" class="form-inline">
                <div class="input-group">
                    <input type="text" name="search" class="form-control bg-light border-0 small" placeholder="بحث..." 
                           value="<?php echo e(request('search')); ?>" aria-label="Search">
                    <div class="input-group-append">
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-search fa-sm"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>رقم العملية</th>
                            <th>المرسل</th>
                            <th>المستلم</th>
                            <th>المبلغ</th>
                            <th>الحالة</th>
                            <th>التاريخ</th>
                            <th>إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($transaction->transaction_id); ?></td>
                            <td><?php echo e($transaction->sender->name); ?> (<?php echo e($transaction->sender->wallet_id); ?>)</td>
                            <td>
    <?php echo e(optional($transaction->receiver)->name ?? 'غير متوفر'); ?>

    (<?php echo e(optional($transaction->receiver)->wallet_id ?? '-'); ?>)
</td>

                            <td><?php echo e(number_format($transaction->amount, 2)); ?> ر.س</td>
                            <td>
    <?php if($transaction->status == 'completed'): ?>
        <span style="color: green;">مكتمل</span>
    <?php elseif($transaction->status == 'pending'): ?>
        <span style="color: orange;">معلق</span>
    <?php elseif($transaction->status == 'cancelled'): ?>
        <span style="color: red;">ملغى</span>
    <?php else: ?>
        <span style="color: gray;">غير معروف</span>
    <?php endif; ?>
</td>
                            <td><?php echo e($transaction->created_at->format('Y-m-d H:i')); ?></td>
                            <td>
                                <a href="<?php echo e(route('admin.wallet.transactions.show', $transaction->id)); ?>" 
                                   class="btn btn-sm btn-info" title="التفاصيل">
                                    <i class="fas fa-eye"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center">لا توجد معاملات</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($transactions->appends(request()->query())->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/wallet/transactions.blade.php ENDPATH**/ ?>