 
<?php $__env->startPush('title', get_phrase('الصفقات')); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title"><span class="icon fi fi-rr-megaphone"></span> إدارة الصفقات</h3>
                    <span class="badge bg-primary"><?php echo e($orders->count()); ?> صفقات</span>
                </div>
                <div class="card-body">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>المستخدم</th>
                                <th>العنوان</th>
                                <th>الفئة</th>
                                <th>السعر</th>
                                <th>الحالة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($order->id); ?></td>
                                <td><?php echo e($order->user->name); ?></td>
                                <td><?php echo e($order->title); ?></td>
                                <td><?php echo e($order->category); ?></td>
                                <td><?php echo e($order->price); ?>$</td>
                                <td>
                                    <span class="badge 
                                        <?php echo e($order->status == 'قيد المراجعة' ? 'bg-warning' : ''); ?>

                                        <?php echo e($order->status == 'موافق' ? 'bg-success' : ''); ?>

                                        <?php echo e($order->status == 'مرفوض' ? 'bg-danger' : ''); ?>

                                    ">
                                        <?php echo e($order->status); ?>

                                    </span>
                                </td>
                                <td>
                                    <button class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#orderModal<?php echo e($order->id); ?>">عرض</button>
                                    <form action="<?php echo e(route('admin.orders.destroy', $order->id)); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من الحذف؟')">حذف</button>
                                    </form>
                                </td>
                            </tr>
                            
                            <!-- Modal لعرض التفاصيل وتغيير الحالة -->
                            <div class="modal fade" id="orderModal<?php echo e($order->id); ?>" tabindex="-1" aria-labelledby="orderModalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="orderModalLabel">تفاصيل الصفقة</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                                        </div>
                                        <div class="modal-body">
                                            <p><strong>المستخدم:</strong> <?php echo e($order->user->name); ?></p>
                                            <p><strong>العنوان:</strong> <?php echo e($order->title); ?></p>
                                            <p><strong>الوصف:</strong> <?php echo e($order->description); ?></p>
                                         
                                            <p><strong>الفئة:</strong> <?php echo e($order->category); ?></p>
                                            <p><strong>السعر:</strong> <?php echo e($order->price); ?>$</p>
                                            
                                            <form action="<?php echo e(route('admin.orders.updateStatus', $order->id)); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <div class="mb-3">
                                                    <label class="form-label">تغيير الحالة</label>
                                                    <select name="status" class="form-control" onchange="this.form.submit()">
                                                        <option value="قيد المراجعة" <?php echo e($order->status == 'قيد المراجعة' ? 'selected' : ''); ?>>قيد المراجعة</option>
                                                        <option value="موافق" <?php echo e($order->status == 'موافق' ? 'selected' : ''); ?>>موافق</option>
                                                        <option value="مرفوض" <?php echo e($order->status == 'مرفوض' ? 'selected' : ''); ?>>مرفوض</option>
                                                    </select>
                                                </div>
                                            </form>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/orders/index.blade.php ENDPATH**/ ?>