<?php $__env->startPush('title', get_phrase('صفقات')); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <!-- عنوان الصفحة -->
    <div class="ol-card radius-8px mb-4">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-briefcase me-2"></i> الإعلانات
                </h4>
            </div>
        </div>
    </div>

    <!-- تصفية الفئات -->
   <div class="row mb-4">
    <div class="col-12">
        <ul class="list-inline text-center">
            <li class="list-inline-item">
                <a href="<?php echo e(route('instructor.deals.index', ['category' => 'all'])); ?>" class="btn btn-outline-primary">الكل</a>
            </li>
            <?php $__currentLoopData = \App\Models\Category::where('parent_id', 0)->orderBy('title')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="list-inline-item">
                    <a href="<?php echo e(route('instructor.deals.index', ['category' => $category->title])); ?>" class="btn btn-outline-primary"><?php echo e($category->title); ?></a>
                </li>
                <?php $__currentLoopData = $category->childs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="list-inline-item">
                        <a href="<?php echo e(route('instructor.deals.index', ['category' => $sub_category->title])); ?>" class="btn btn-outline-secondary">-- <?php echo e($sub_category->title); ?></a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
</div>

    <!-- بطاقات الصفقات -->
    <div class="row g-4">
        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php if($order->status == 'موافق'): ?>
                <div class="col-md-4">
                    <div class="card shadow-sm border-0 rounded-4 h-100">
                        <div class="badge bg-primary position-absolute top-0 end-0 m-2 category-badge">
                            <?php echo e($order->category); ?>

                        </div>
                        <div class="card-body d-flex flex-column">
                            <h5 class="card-title text-primary fw-bold"><?php echo e($order->title); ?></h5>

                            <!-- وصف مختصر وموسع -->
                            <p class="card-text mb-1">
                                <strong>الوصف:</strong>
                                <div class="description-container">
                                    <span class="short-desc description-text"><?php echo e(\Illuminate\Support\Str::limit($order->description, 60)); ?></span>
                                    <span class="full-desc description-text d-none"><?php echo e($order->description); ?></span>
                                    <?php if(strlen($order->description) > 60): ?>
                                        <button class="toggle-description btn btn-link p-0">عرض المزيد</button>
                                    <?php endif; ?>
                                </div>
                            </p>

                            <!-- السعر باللون الأخضر -->
                            <p class="card-text mb-3 price-text">
                                <strong>السعر:</strong> <?php echo e($order->price); ?> ريال
                            </p>

                            <!-- زر إرسال رسالة -->
                            <a href="<?php echo e(route('instructor.conversations.open', ['receiver_id' => $order->user_id])); ?>" class="btn btn-outline-info mt-auto">
                                <i class="fi-rr-envelope"></i> إرسال رسالة
                            </a>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12">
                <p class="text-muted text-center">لا توجد صفقات حالياً.</p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
<style>
    .toggle-description {
        font-size: 0.85rem;
        color: #0d6efd;
        background: none;
        border: none;
        cursor: pointer;
    }
    .description-text {
        color: #ACC572; /* رمادي غامق وواضح */
        font-weight: 500;
    }
    .price-text {
        color: #28a745; /* أخضر */
        font-weight: bold;
    }
    .category-badge {
        font-size: 1rem;
        font-weight: bold;
        color: #ffffff;
        background-color: #007bff;
        padding: 8px 16px;
        border-radius: 12px;
    }
    .category-filter {
        font-size: 1rem;
        margin: 0 8px;
        cursor: pointer;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.toggle-description').forEach(button => {
        button.addEventListener('click', function () {
            const container = this.closest('.description-container');
            const shortDesc = container.querySelector('.short-desc');
            const fullDesc = container.querySelector('.full-desc');

            if (fullDesc.classList.contains('d-none')) {
                shortDesc.classList.add('d-none');
                fullDesc.classList.remove('d-none');
                this.textContent = 'عرض أقل';
            } else {
                shortDesc.classList.remove('d-none');
                fullDesc.classList.add('d-none');
                this.textContent = 'عرض المزيد';
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.instructor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/instructor/deals/index.blade.php ENDPATH**/ ?>