<?php $__env->startPush('title', get_phrase('Blog')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

    <!-- Mani section header and breadcrumb -->
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-4 px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <span><?php echo e(get_phrase('Pending Blog')); ?></span>
                </h4>
            </div>
        </div>
    </div>

    <!-- Start Admin area -->
    <div class="row">
        <div class="col-12">
            <div class="ol-card">
                <div class="ol-card-body p-3">

                    <div class="row print-d-none mb-3 mt-3 row-gap-3">
                        <div class="col-md-6  pt-2 pt-md-0">
                            <div class="custom-dropdown">
                                <button class="dropdown-header btn ol-btn-light">
                                    <?php echo e(get_phrase('Export')); ?>

                                    <i class="fi-rr-file-export ms-2"></i>
                                </button>
                                <ul class="dropdown-list">
                                    <li>
                                        <a class="dropdown-item" href="#" onclick="downloadPDF('.print-table', 'pending-blogs')"><i class="fi-rr-file-pdf"></i> <?php echo e(get_phrase('PDF')); ?></a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#" onclick="window.print();"><i class="fi-rr-print"></i> <?php echo e(get_phrase('Print')); ?></a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <form action="<?php echo e(route('admin.blog.pending')); ?>" method="get">
                                <div class="row row-gap-3">
                                    <div class="col-md-9">
                                        <div class="search-input">
                                            <input type="text" name="search" value="<?php echo e(request('search')); ?>"
                                                placeholder="<?php echo e(get_phrase('Search Title')); ?>" class="ol-form-control form-control" />
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <button type="submit" class="btn ol-btn-primary w-100" id="submit-button"><?php echo e(get_phrase('Search')); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Table -->
                    <?php if(count($blogs) > 0): ?>
                        <div
                            class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                            <p class="admin-tInfo">
                                <?php echo e(get_phrase('Showing') . ' ' . count($blogs) . ' ' . get_phrase('of') . ' ' . $blogs->total() . ' ' . get_phrase('data')); ?>

                            </p>
                        </div>
                        <div class="table-responsive blog_list" id="blog_list">
                            <table class="table eTable eTable-2 print-table">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col"><?php echo e(get_phrase('Creator')); ?></th>
                                        <th scope="col"><?php echo e(get_phrase('Title')); ?></th>
                                        <th scope="col"><?php echo e(get_phrase('Category')); ?></th>
                                        <th scope="col"><?php echo e(get_phrase('Status')); ?></th>
                                        <th class="print-d-none" scope="col"><?php echo e(get_phrase('Options')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row">
                                                <p class="row-number"><?php echo e($key + 1); ?></p>
                                            </th>

                                            <td>
                                                <div class="dAdmin_profile d-flex align-items-center min-w-200px">
                                                    <div class="dAdmin_profile_img">
                                                        <img class="img-fluid rounded-circle image-45" width="40" height="40" src="<?php echo e(get_image($blog->user->photo)); ?>" />
                                                    </div>
                                                    <div class="ms-1 mt-1">
                                                        <h4 class="title fs-14px"><?php echo e($blog->user->name); ?></h4>
                                                        <p class="sub-title2 text-12px"><?php echo e($blog->user->email); ?></p>
                                                    </div>
                                                </div>
                                            </td>

                                            <td>
                                                <div class="dAdmin_info_name min-w-150px">
                                                    <p><a href="<?php echo e(route('blog.details', slugify($blog->title))); ?>"><?php echo e($blog->title); ?></a></p>
                                                    <small class="text-muted"><?php echo e(date('D, d-M-Y', strtotime($blog->created_at))); ?></small>
                                                </div>
                                            </td>

                                            <td>
                                                <?php
                                                    $category = DB::table('blog_categories')
                                                        ->where('id', $blog->category_id)
                                                        ->first();
                                                ?>
                                                <div class="dAdmin_info_name min-w-150px">
                                                    <p><?php echo e($category->title); ?></p>
                                                </div>
                                            </td>

                                            <td>
                                                <div class="dAdmin_info_name min-w-150px">
                                                    <p><span class="badge <?php echo e($blog->status ? 'bg-success' : 'bg-danger'); ?> text-white"><?php echo e(get_phrase($blog->status ? 'Active' : 'Inactive')); ?></span></p>
                                                </div>
                                            </td>

                                            <td class="print-d-none">
                                                <div class="dropdown ol-icon-dropdown ol-icon-dropdown-transparent">
                                                    <button class="btn ol-btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                        <span class="fi-rr-menu-dots-vertical"></span>
                                                    </button>
                                                    <ul class="dropdown-menu">
                                                        <li><a class="dropdown-item" href="<?php echo e(route('admin.blog.edit', ['id' => $blog->id])); ?>"><?php echo e(get_phrase('Edit')); ?></a></li>
                                                        <li><a class="dropdown-item" href="#" onclick="confirmModal('<?php echo e(route('admin.blog.status', $blog->id)); ?>')"><?php echo e(get_phrase($blog->status ? 'Inactive' : 'Activate')); ?></a></li>
                                                        <li><a class="dropdown-item" href="#" onclick="confirmModal('<?php echo e(route('admin.blog.delete', $blog->id)); ?>')"><?php echo e(get_phrase('Delete')); ?></a></li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('admin.no_data', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?>
                    <!-- Data info and Pagination -->
                    <?php if(count($blogs) > 0): ?>
                        <div
                            class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                            <p class="admin-tInfo">
                                <?php echo e(get_phrase('Showing') . ' ' . count($blogs) . ' ' . get_phrase('of') . ' ' . $blogs->total() . ' ' . get_phrase('data')); ?>

                            </p>
                            <?php echo e($blogs->links()); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <!-- End Admin area -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?><?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/blog/pending.blade.php ENDPATH**/ ?>