<?php $__env->startPush('title', get_phrase('سجل المعاملات')); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-time-past me-2"></i>
                    <?php echo e(get_phrase('سجل المعاملات')); ?>

                </h4>
                <a href="<?php echo e(route('wallet.index')); ?>" class="btn btn-sm btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i> <?php echo e(get_phrase('رجوع')); ?>

                </a>
            </div>
        </div>
    </div>

    <div class="card shadow mb-4 mt-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary"><?php echo e(get_phrase('جميع المعاملات')); ?></h6>
            <form action="<?php echo e(route('instructor.wallet.transactions')); ?>" method="GET" class="form-inline">
                <div class="input-group">
                    <input type="text" name="search" class="form-control bg-light border-0 small" placeholder="بحث..." 
                           value="<?php echo e(request('search')); ?>" aria-label="Search">
                    <div class="input-group-append">
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-search fa-sm"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th><?php echo e(get_phrase('رقم العملية')); ?></th>
                            <th><?php echo e(get_phrase('المرسل')); ?></th>
                            <th><?php echo e(get_phrase('المستلم')); ?></th>
                            <th><?php echo e(get_phrase('المبلغ')); ?></th>
                            <th><?php echo e(get_phrase('النوع')); ?></th>
                            <th><?php echo e(get_phrase('الحالة')); ?></th>
                            <th><?php echo e(get_phrase('التاريخ')); ?></th>
                            <th><?php echo e(get_phrase('الإجراءات')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($transaction->transaction_id); ?></td>
                            <td><?php echo e($transaction->sender->name ?? 'غير متاح'); ?></td>
                            <td><?php echo e($transaction->receiver->name ?? 'غير متاح'); ?></td>
                            <td><?php echo e(number_format($transaction->amount, 2)); ?> ر.س</td>
                            <td>
                                <?php if($transaction->type == 'deposit'): ?>
                                    <span class="badge bg-info">إيداع</span>
                                <?php elseif($transaction->type == 'withdrawal'): ?>
                                    <span class="badge bg-warning">سحب</span>
                                <?php else: ?>
                                    <span class="badge bg-primary">تحويل</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($transaction->status == 'completed'): ?>
                                    <span class="badge bg-success">مكتمل</span>
                                <?php elseif($transaction->status == 'pending'): ?>
                                    <span class="badge bg-warning">معلق</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">ملغى</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($transaction->created_at->format('Y-m-d H:i')); ?></td>
                            <td>
                                <?php if($transaction->status == 'pending' && $transaction->sender_id == auth()->id()): ?>
                                    <div class="btn-group">
                                        <form action="<?php echo e(route('wallet.transaction.confirm', $transaction->transaction_id)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-sm btn-success" title="تأكيد">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('wallet.transaction.cancel', $transaction->transaction_id)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-sm btn-danger" title="إلغاء">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </form>
                                    </div>
                                <?php else: ?>
                                    <a href="#" class="btn btn-sm btn-info" title="التفاصيل">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center"><?php echo e(get_phrase('لا توجد معاملات')); ?></td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            $transactions = Transaction::where('user_id', $userId)->paginate(10);

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/instructor/wallet/transactions.blade.php ENDPATH**/ ?>