<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">إحصائيات النزاعات</h3>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-3 col-6">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3><?php echo e($stats['total']); ?></h3>
                        <p>إجمالي النزاعات</p>
                    </div>
                    <div class="icon"><i class="fas fa-file-alt"></i></div>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3><?php echo e($stats['pending']); ?></h3>
                        <p>معلقة</p>
                    </div>
                    <div class="icon"><i class="fas fa-clock"></i></div>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="small-box bg-primary">
                    <div class="inner">
                        <h3><?php echo e($stats['in_progress']); ?></h3>
                        <p>قيد المعالجة</p>
                    </div>
                    <div class="icon"><i class="fas fa-sync-alt"></i></div>
                </div>
            </div>
            <div class="col-md-3 col-6">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3><?php echo e($stats['resolved']); ?></h3>
                        <p>تم حلها</p>
                    </div>
                    <div class="icon"><i class="fas fa-check"></i></div>
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">حلها اليوم</h3>
                    </div>
                    <div class="card-body text-center">
                        <h1 class="display-4"><?php echo e($stats['resolved_today']); ?></h1>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">متوسط وقت الحل (ساعات)</h3>
                    </div>
                    <div class="card-body text-center">
                        <h1 class="display-4"><?php echo e(number_format($stats['avg_resolution_time'], 1)); ?></h1>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/disputes/stats.blade.php ENDPATH**/ ?>