<?php $__env->startPush('title', get_phrase('Payout setting')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <?php
        $user_data = App\Models\User::where('id', auth()->user()->id)->first();
        $payment_keys = json_decode($user_data->paymentkeys, true);
    ?>

    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-4 px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('Payout setting')); ?>

                </h4>
            </div>
        </div>
    </div>


    <div class="alert alert-primary ol-alert-primary mb-3" role="alert">
        <p class="sub-title2 fs-16px">
            <span class="title2"><?php echo e(get_phrase('Be careful !!')); ?></span>
            <?php echo e(get_phrase('Just configure the payment gateway you want to use, leave the rest blank.')); ?>

            <?php echo e(get_phrase('Also, make sure that you have configured your payment settings correctly')); ?>

        </p>
    </div>


    <form action="<?php echo e(route('instructor.payout.setting.store')); ?>" class="mb-5" method="post" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row g-3">
            <?php
                $payment_gateways = App\Models\Payment_gateway::where('identifier', '!=', 'offline')->get();
            ?>
            <?php $__currentLoopData = $payment_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $payment_gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $keys = json_decode($payment_gateway->keys, true);
                    $user_keys = json_decode($user_data->paymentkeys, true);
                ?>
                <div class="col-md-6">
                    <div class="ol-card p-3">
                        <div class="ol-card-body">
                            <div class=" <?php if($payment_gateway->status != 1): ?> d-none <?php endif; ?>">
                                <h4 class="title fs-16px mb-3"><?php echo e($payment_gateway->title); ?></h4>
                                <?php $__currentLoopData = $keys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $value = '';
                                        if ($user_keys !== '' && isset($user_keys[$payment_gateway->identifier][$index])) {
                                            $value = $user_keys[$payment_gateway->identifier][$index];
                                        }
                                        $indexs = implode(' ', explode('_', $index));
                                    ?>
                                    <div class="mb-3">
                                        <input type="text" id="<?php echo e($payment_gateway->identifier . $index); ?>" name="gateways[<?php echo e($payment_gateway->identifier); ?>][<?php echo e($index); ?>]" value="<?php echo e($value); ?>" class="form-control ol-form-control" placeholder="<?php echo e(get_phrase(ucfirst($indexs))); ?>">
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="row">
            <div class="col-4 offset-4">
                <button class="btn ol-btn-primary mt-4 w-100" type="submit"><?php echo e(get_phrase('Save changes')); ?></button>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?><?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.instructor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/instructor/payout_setting/index.blade.php ENDPATH**/ ?>