

<?php $__env->startPush('title', get_phrase('Categories')); ?>

<?php $__env->startPush('meta'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>



<?php $__env->startSection('content'); ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('Tutor categories')); ?> <span class="text-muted">(<?php echo e($categories->count()); ?>)</span>
                </h4>

                <a onclick="ajaxModal('<?php echo e(route('modal', ['admin.tutor_booking.category_add', 'parent' => 0])); ?>', '<?php echo e(get_phrase('Add new category')); ?>')" href="#" class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px">
                    <span class="fi-rr-plus"></span>
                    <span><?php echo e(get_phrase('Add new category')); ?></span>
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-7">
            <div class="ol-card p-4">
                <div class="ol-card-body">
                    <div class="col-lg-12">

                        <?php if($categories->count() > 0): ?>
                            <div class="admin-tInfo-pagi d-flex justify-content-md-between justify-content-center align-items-center gr-15 flex-wrap">
                                <p class="admin-tInfo">
                                    <?php echo e(get_phrase('Showing') . ' ' . count($categories) . ' ' . get_phrase('of') . ' ' . $categories->total() . ' ' . get_phrase('data')); ?>

                                </p>
                            </div>
                            <div class="table-responsive package_list overflow-auto" id="package_list">
                                <table class="eTable eTable-2 print-table table">
                                    <thead>
                                        <tr>
                                            <th scope="col">#</th>
                                            <th scope="col"><?php echo e(get_phrase('Name')); ?></th>
                                            <th scope="col" class="text-center"><?php echo e(get_phrase('Status')); ?></th>
                                            <th scope="col" class="print-d-none text-center"><?php echo e(get_phrase('Action')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th scope="row">
                                                    <p class="row-number"><?php echo e(++$key); ?></p>
                                                </th>

                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="ms-1 mt-1">
                                                            <h4 class="title fs-14px">
                                                                <a href="">
                                                                    <?php echo e(ucfirst($category->name)); ?>

                                                                </a>
                                                            </h4>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="sub-title2 text-12px text-center">
                                                        <?php if($category['status'] == 1): ?>
                                                            <p><?php echo e(get_phrase('Active')); ?> </p>
                                                        <?php else: ?>
                                                            <p><?php echo e(get_phrase('Deactive')); ?> </p>
                                                        <?php endif; ?>
                                                    </div>
                                                </td>
                                                <td class="print-d-none text-center">
                                                    <div class="dropdown ol-icon-dropdown ol-icon-dropdown-transparent d-flex justify-content-center">
                                                        <button class="btn ol-btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                            <span class="fi-rr-menu-dots-vertical"></span>
                                                        </button>

                                                        <ul class="dropdown-menu">
                                                            <li>
                                                                <a href="#" class="dropdown-item" onclick="ajaxModal('<?php echo e(route('modal', ['admin.tutor_booking.category_edit', 'id' => $category->id])); ?>', '<?php echo e(get_phrase('Edit subject')); ?>')"> <?php echo e(get_phrase('Edit')); ?></a>
                                                            </li>
                                                            <li>
                                                                <?php if($category['status'] == 1): ?>
                                                                    <a class="dropdown-item" href="<?php echo e(route('admin.tutor_category_status', ['id' => $category->id, 'status' => 'deactive'])); ?>"><?php echo e(get_phrase('Deactive')); ?></a>
                                                                <?php else: ?>
                                                                    <a class="dropdown-item" href="<?php echo e(route('admin.tutor_category_status', ['id' => $category->id, 'status' => 'active'])); ?>"><?php echo e(get_phrase('Active')); ?></a>
                                                                <?php endif; ?>
                                                            </li>
                                                            <li>
                                                                <a class="dropdown-item" onclick="confirmModal('<?php echo e(route('admin.tutor_category_delete', $category->id)); ?>')"><?php echo e(get_phrase('Delete')); ?></a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="admin-tInfo-pagi d-flex justify-content-md-between justify-content-center align-items-center gr-15 flex-wrap">
                                <p class="admin-tInfo">
                                    <?php echo e(get_phrase('Showing') . ' ' . count($categories) . ' ' . get_phrase('of') . ' ' . $categories->total() . ' ' . get_phrase('data')); ?>

                                </p>
                                <?php echo e($categories->links()); ?>

                            </div>
                        <?php else: ?>
                            <?php echo $__env->make('admin.no_data', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        <?php endif; ?>


                    </div>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/tutor_booking/categories.blade.php ENDPATH**/ ?>