<?php $__env->startPush('title', get_phrase('إدارة رصيد المستخدمين')); ?>

<?php $__env->startSection('content'); ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px d-flex align-items-center">
                    <i class="fi-rr-wallet me-2"></i>
                    <?php echo e(get_phrase('إدارة رصيد المستخدمين')); ?>

                </h4>

                <a href="<?php echo e(route('admin.wallet.transactions')); ?>" class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px">
                    <i class="fas fa-arrow-left fa-sm me-1"></i>
                    <span><?php echo e(get_phrase('رجوع')); ?></span>
                </a>
            </div>
        </div>
    </div>

    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">

            <form action="<?php echo e(route('admin.wallet.add-balance')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <!-- اختيار المستخدم -->
                    <div class="col-md-6 form-group">
                        <label for="user_id" class="mb-2"><?php echo e(get_phrase('اختر المستخدم')); ?></label>
                        <select class="form-control select2" id="user_id" name="user_id" required>
                            <option value=""><?php echo e(get_phrase('-- اختر مستخدم --')); ?></option>
                            <?php $__currentLoopData = \App\Models\User::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>">
                                    <?php echo e($user->name); ?> (<?php echo e($user->wallet_id); ?>) - رصيد: <?php echo e(number_format($user->wallet_balance, 2)); ?> ر.س
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- نوع العملية -->
                    <div class="col-md-6 form-group">
                        <label for="transaction_type" class="mb-2"><?php echo e(get_phrase('نوع العملية')); ?></label>
                        <select class="form-control" id="transaction_type" name="transaction_type" required>
                            <option value="deposit"><?php echo e(get_phrase('إيداع')); ?></option>
                            <option value="withdraw"><?php echo e(get_phrase('سحب')); ?></option>
                        </select>
                    </div>

                    <!-- المبلغ -->
                    <div class="col-md-6 form-group">
                        <label for="amount" class="mb-2"><?php echo e(get_phrase('المبلغ')); ?></label>
                        <input type="number" step="0.01" min="0.01" class="form-control" id="amount" name="amount" required>
                    </div>

                    <!-- ملاحظات -->
                    <div class="col-md-6 form-group">
                        <label for="notes" class="mb-2"><?php echo e(get_phrase('ملاحظات (اختياري)')); ?></label>
                        <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                    </div>

                    <!-- زر التطبيق -->
                    <div class="col-12 mt-4">
                        <button type="submit" class="btn ol-btn-primary d-flex align-items-center cg-10px">
                            <i class="fas fa-check-circle me-2"></i>
                            <?php echo e(get_phrase('تطبيق العملية')); ?>

                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.select2').select2({
            placeholder: '-- اختر مستخدم --',
            allowClear: true
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/wallet/add-balance.blade.php ENDPATH**/ ?>