<!-- resources/views/admin/disputes/index.blade.php -->


<?php $__env->startSection('content'); ?>
<div class="container">
    <h1>إدارة النزاعات</h1>
    
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between">
                <h3>قائمة النزاعات</h3>
                <div>
                    <select class="form-select" onchange="window.location.href='?status='+this.value">
                        <option value="">جميع الحالات</option>
                        <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>" <?php echo e(request('status') == $key ? 'selected' : ''); ?>>
                                <?php echo e($status); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>
        
        <div class="card-body">
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>المحادثة</th>
                        <th>المبلغ</th>
                        <th>السبب</th>
                        <th>الحالة</th>
                        <th>التاريخ</th>
                        <th>إجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $disputes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dispute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($dispute->id); ?></td>
                        <td>المحادثة #<?php echo e($dispute->conversation_id); ?></td>
                        <td><?php echo e($dispute->reporter->name); ?></td>
                        <td><?php echo e(Str::limit($dispute->reason, 30)); ?></td>
                        <td>
                            <span class="badge bg-<?php echo e($dispute->status == 'resolved' ? 'success' : ($dispute->status == 'in_progress' ? 'warning' : 'danger')); ?>">
                                <?php echo e($statuses[$dispute->status]); ?>

                            </span>
                        </td>
                        <td><?php echo e($dispute->created_at->diffForHumans()); ?></td>
                        <td>
                            <a href="<?php echo e(route('admin.disputes.show', $dispute)); ?>" class="btn btn-sm btn-primary">
                                عرض
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            
            <?php echo e($disputes->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/disputes/index.blade.php ENDPATH**/ ?>