<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">تفاصيل المعاملة #<?php echo e($transaction->transaction_id); ?></h6>
            <a href="<?php echo e(route('admin.wallet.transactions')); ?>" class="btn btn-sm btn-secondary">
                <i class="fas fa-arrow-left"></i> رجوع
            </a>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <th width="30%">رقم المعاملة</th>
                                    <td><?php echo e($transaction->transaction_id); ?></td>
                                </tr>
                                <tr>
                                    <th>المرسل</th>
                                    <td>
                                        <?php echo e($transaction->sender->name); ?>

                                        <small class="text-muted d-block">(<?php echo e($transaction->sender->wallet_id); ?>)</small>
                                    </td>
                                </tr>
                                <tr>
                                    <th>المستلم</th>
                                    <td>
                                        <?php echo e($transaction->receiver->name); ?>

                                        <small class="text-muted d-block">(<?php echo e($transaction->receiver->wallet_id); ?>)</small>
                                    </td>
                                </tr>
                                <tr>
                                    <th>المبلغ</th>
                                    <td class="font-weight-bold">
                                        <?php echo e(number_format($transaction->amount, 2)); ?> ر.س
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <th width="30%">الحالة</th>
                                    <td>
    <?php if($transaction->status == 'completed'): ?>
        <span style="color: green;">مكتمل</span>
    <?php elseif($transaction->status == 'pending'): ?>
        <span style="color: orange;">معلق</span>
    <?php elseif($transaction->status == 'cancelled'): ?>
        <span style="color: red;">ملغى</span>
    <?php else: ?>
        <span style="color: gray;">غير معروف</span>
    <?php endif; ?>
</td>
                                </tr>
                                <tr>
                                    <th>تاريخ الإنشاء</th>
                                    <td><?php echo e($transaction->created_at->format('Y-m-d H:i:s')); ?></td>
                                </tr>
                                <tr>
                                    <th>آخر تحديث</th>
                                    <td><?php echo e($transaction->updated_at->format('Y-m-d H:i:s')); ?></td>
                                </tr>
                                <tr>
                                    <th>ملاحظات</th>
                                    <td><?php echo e($transaction->notes ?? 'لا توجد ملاحظات'); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <?php if($transaction->status == 'pending' && auth()->user()->can('admin.wallet.transactions.update')): ?>
            <div class="mt-4">
                <form action="<?php echo e(route('admin.wallet.transactions.update', $transaction->id)); ?>" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <input type="hidden" name="status" value="completed">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-check"></i> تأكيد المعاملة
                    </button>
                </form>

                <form action="<?php echo e(route('admin.wallet.transactions.update', $transaction->id)); ?>" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    <input type="hidden" name="status" value="cancelled">
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-times"></i> إلغاء المعاملة
                    </button>
                </form>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/wallet/transaction-details.blade.php ENDPATH**/ ?>