<!-- Modal -->
<div class="modal fade" id="createDealModal" tabindex="-1" aria-labelledby="createDealModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form id="createDealForm" method="POST">
        <?php echo csrf_field(); ?>
        <div class="modal-header">
          <h5 class="modal-title" id="createDealModalLabel">إضافة صفقة جديدة</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="user_id" value="<?php echo e(auth()->user()->id); ?>">

          <div class="mb-3">
            <label class="form-label">عنوان الصفقة</label>
            <input type="text" name="title" class="form-control" required>
          </div>

          <div class="mb-3">
            <label class="form-label">الوصف</label>
            <textarea name="description" class="form-control" rows="4" required></textarea>
          </div>

          <div class="mb-3">
            <label class="form-label">الفئة</label>
            <select name="category" class="form-select" required>
                <option value="" disabled selected>اختر الفئة</option>
                <?php $__currentLoopData = \App\Models\Category::where('parent_id', 0)->orderBy('title')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($category->id); ?>"><?php echo e($category->title); ?></option>
                    <?php $__currentLoopData = $category->childs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($sub_category->id); ?>">-- <?php echo e($sub_category->title); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <div class="text-danger mt-1"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
          </div>

          <div class="mb-3">
            <label class="form-label">السعر</label>
            <input type="number" name="price" class="form-control" step="0.01" required>
          </div>

          <div class="response-message"></div> <!-- مكان عرض الرد -->
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-success" id="submitDealBtn">
            <span class="spinner-border spinner-border-sm d-none" id="submitSpinner" role="status" aria-hidden="true"></span>
            <span class="submit-text">إضافة</span>
          </button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Toast Component -->
<div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 1055;">
  <div class="toast align-items-center text-bg-success border-0" id="dealToast" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="d-flex">
      <div class="toast-body" id="dealToastMessage">تمت إضافة الصفقة بنجاح</div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
  </div>
</div>

<script>
  $(document).ready(function() {
    $('#createDealForm').on('submit', function(e) {
      e.preventDefault();

      let $submitBtn = $('#submitDealBtn');
      let $spinner = $('#submitSpinner');
      let $submitText = $submitBtn.find('.submit-text');

      $submitBtn.prop('disabled', true);
      $spinner.removeClass('d-none');
      $submitText.text('جاري الإضافة...');

      $.ajax({
        url: "<?php echo e(route('instructor.deals.store')); ?>",
        type: "POST",
        data: $(this).serialize(),
        success: function(response) {
          if (response.success) {
            $('#createDealForm')[0].reset();
            $('#createDealModal').modal('hide');

            $('#dealToastMessage').text(response.message);
            $('#dealToast').removeClass('text-bg-danger').addClass('text-bg-success');
            new bootstrap.Toast(document.getElementById('dealToast')).show();

            setTimeout(function() {
              location.reload();
            }, 2000);
          } else {
            $('#dealToastMessage').text(response.message);
            $('#dealToast').removeClass('text-bg-success').addClass('text-bg-danger');
            new bootstrap.Toast(document.getElementById('dealToast')).show();

            $submitBtn.prop('disabled', false);
            $spinner.addClass('d-none');
            $submitText.text('إضافة');
          }
        },
        error: function() {
          $('#dealToastMessage').text('حدث خطأ أثناء إرسال البيانات. حاول مرة أخرى لاحقًا.');
          $('#dealToast').removeClass('text-bg-success').addClass('text-bg-danger');
          new bootstrap.Toast(document.getElementById('dealToast')).show();

          $submitBtn.prop('disabled', false);
          $spinner.addClass('d-none');
          $submitText.text('إضافة');
        }
      });
    });
  });
</script>
<?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/instructor/deals/create.blade.php ENDPATH**/ ?>