<?php
    $applicant_details = App\Models\Application::where('id', $id)->first();
    $user = get_user_info($applicant_details->user_id);
?>

<style>
    .instructor-info li:nth-last-child(1){
        border: none;
    }
    .instructor-info li{
        display: flex;
        align-content: center;
        justify-content: space-between;
        border-bottom: 1px solid var(--borderColor);
        padding: 16px 0;
    }
    .instructor-info li span:nth-child(1){
        font-size: 14px;
        font-weight: 600;
        color: var(--darkColor);
    }
    .instructor-info li span:nth-child(2){
        font-size: 14px;
        font-weight: 500;
        color: var(--grayColor);
    }
</style>

<div class="text-center mb-2">
    <img class="mr-2 rounded-circle image-100" src="<?php echo e(asset(get_user_info($applicant_details->user_id)->photo)); ?>" alt=""
        height="80">
</div>

<ul class="instructor-info">
    <li>
        <span><?php echo e(get_phrase('Applicant')); ?></span>
        <span><?php echo e($user->name); ?></span>
    </li>
    <li>
        <span><?php echo e(get_phrase('Email')); ?></span>
        <span><?php echo e($user->email); ?></span>
    </li>
    <li>
        <span><?php echo e(get_phrase('Phone number')); ?></span>
        <span><?php echo e($user->phone); ?></span>
    </li>
    <li>
        <span><?php echo e(get_phrase('Address')); ?></span>
        <span><?php echo e($user->address); ?></span>
    </li>
    <li>
        <span><?php echo e(get_phrase('Message')); ?>&nbsp</span>: &nbsp
        <span><?php echo e($applicant_details->description); ?></span>
    </li>
    <li>
        <span><?php echo e(get_phrase('Status')); ?></span>
        <?php if($applicant_details->status): ?>
            <span class="badge bg-success"><?php echo e(get_phrase('Accepted')); ?></span>
        <?php else: ?>
            <span class="badge bg-danger"><?php echo e(get_phrase('Pending')); ?></span>
        <?php endif; ?>
    </li>
</ul>
<?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/instructor/show_document.blade.php ENDPATH**/ ?>