<?php $__env->startPush('title', get_phrase('طلبات سحب')); ?>

<?php $__env->startSection('content'); ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px d-flex align-items-center">
                    <i class="fi-rr-bank me-2"></i>

                    <?php echo e(get_phrase('طلبات سحب الأموال')); ?>

                </h4>

                <div class="btn-group">
                    <a href="<?php echo e(route('admin.wallet.withdrawal-requests', ['status' => 'all'])); ?>" 
                       class="btn btn-sm btn-<?php echo e(request('status') == 'all' ? 'primary' : 'secondary'); ?>">
                        <?php echo e(get_phrase('الكل')); ?>

                    </a>
                    <a href="<?php echo e(route('admin.wallet.withdrawal-requests', ['status' => 'pending'])); ?>" 
                       class="btn btn-sm btn-<?php echo e(request('status', 'pending') == 'pending' ? 'primary' : 'secondary'); ?>">
                        <?php echo e(get_phrase('قيد الانتظار')); ?>

                    </a>
                    <a href="<?php echo e(route('admin.wallet.withdrawal-requests', ['status' => 'approved'])); ?>" 
                       class="btn btn-sm btn-<?php echo e(request('status') == 'approved' ? 'primary' : 'secondary'); ?>">
                        <?php echo e(get_phrase('تمت الموافقة')); ?>

                    </a>
                    <a href="<?php echo e(route('admin.wallet.withdrawal-requests', ['status' => 'rejected'])); ?>" 
                       class="btn btn-sm btn-<?php echo e(request('status') == 'rejected' ? 'primary' : 'secondary'); ?>">
                        <?php echo e(get_phrase('مرفوضة')); ?>

                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">طلبات السحب</h6>
            <form action="<?php echo e(route('admin.wallet.withdrawal-requests')); ?>" method="GET" class="form-inline">
                <input type="hidden" name="status" value="<?php echo e(request('status', 'pending')); ?>">
                <div class="input-group">
                    <input type="text" name="search" class="form-control bg-light border-0 small" placeholder="بحث..." 
                           value="<?php echo e(request('search')); ?>" aria-label="Search">
                    <div class="input-group-append">
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-search fa-sm"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>رقم الطلب</th>
                            <th>المستخدم</th>
                            <th>المبلغ</th>
                            <th>طريقة السحب</th>
                            <th>الحالة</th>
                            <th>تاريخ الطلب</th>
                            <th>إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($request->request_id); ?></td>
                            <td><?php echo e($request->user->name); ?> (<?php echo e($request->user->wallet_id); ?>)</td>
                            <td><?php echo e(number_format($request->amount, 2)); ?> ر.س</td>
                            <td>
                                <?php if($request->withdrawal_method == 'bank_transfer'): ?>
                                    حوالة بنكية
                                <?php else: ?>
                                    محفظة إلكترونية
                                <?php endif; ?>
                            </td>
                            <td>
    <?php if($request->status == 'pending'): ?>
        <span style="color: orange;">قيد الانتظار</span>
    <?php elseif($request->status == 'approved'): ?>
        <span style="color: green;">تمت الموافقة</span>
    <?php elseif($request->status == 'rejected'): ?>
        <span style="color: red;">مرفوض</span>
    <?php else: ?>
        <span style="color: gray;">غير معروف</span>
    <?php endif; ?>
</td>
                            <td><?php echo e($request->created_at->format('Y-m-d H:i')); ?></td>
                            <td>
                                <a href="<?php echo e(route('admin.wallet.withdrawal-requests.show', $request->id)); ?>" 
                                   class="btn btn-sm btn-info" title="التفاصيل">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <?php if($request->status == 'pending'): ?>
                                <form action="<?php echo e(route('admin.wallet.withdrawal-requests.approve', $request->id)); ?>" 
                                      method="POST" style="display: inline-block;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-sm btn-success" title="موافقة">
                                        <i class="fas fa-check"></i>
                                    </button>
                                </form>
                                <button type="button" class="btn btn-sm btn-danger" title="رفض" data-toggle="modal" 
                                        data-target="#rejectModal<?php echo e($request->id); ?>">
                                    <i class="fas fa-times"></i>
                                </button>

                                <!-- Reject Modal -->
                                <div class="modal fade" id="rejectModal<?php echo e($request->id); ?>" tabindex="-1" role="dialog" 
                                     aria-labelledby="rejectModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="rejectModalLabel">رفض طلب السحب</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form action="<?php echo e(route('admin.wallet.withdrawal-requests.reject', $request->id)); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <div class="modal-body">
                                                    <div class="form-group">
                                                        <label for="admin_notes">سبب الرفض</label>
                                                        <textarea class="form-control" id="admin_notes" name="admin_notes" required></textarea>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                    <button type="submit" class="btn btn-danger">تأكيد الرفض</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center">لا توجد طلبات سحب</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($requests->appends(request()->query())->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/wallet/withdrawal-requests.blade.php ENDPATH**/ ?>