<?php $__env->startPush('title', get_phrase('حظر مستخدم جديد')); ?>

<?php $__env->startSection('content'); ?>
<div class="ban-management-container">
    <!-- Header Section -->
    <div class="page-header">
        <div class="header-content">
            <div class="header-text">
                <h1 class="page-title">
                    <i class="fas fa-user-slash"></i>
                    حظر مستخدم جديد
                </h1>
                <p class="page-subtitle">إضافة حظر جديد للمستخدمين المخالفين للقوانين</p>
            </div>
            <div class="header-actions">
                <a href="<?php echo e(route('admin.ban_management.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-right"></i>
                    العودة للقائمة
                </a>
                <a href="<?php echo e(route('admin.ban_management.violations')); ?>" class="btn btn-info">
                    <i class="fas fa-exclamation-triangle"></i>
                    عرض الانتهاكات
                </a>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card warning">
            <div class="stat-icon">
                <i class="fas fa-user-slash"></i>
            </div>
            <div class="stat-content">
                <h3>حظر جديد</h3>
                <p>إضافة مستخدم للقائمة المحظورة</p>
            </div>
        </div>
        
        <div class="stat-card info">
            <div class="stat-icon">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stat-content">
                <h3>مؤقت أو دائم</h3>
                <p>اختر مدة الحظر المناسبة</p>
            </div>
        </div>
        
        <div class="stat-card active">
            <div class="stat-icon">
                <i class="fas fa-shield-alt"></i>
            </div>
            <div class="stat-content">
                <h3>حماية النظام</h3>
                <p>منع المستخدمين المخالفين</p>
            </div>
        </div>
        
        <div class="stat-card total">
            <div class="stat-icon">
                <i class="fas fa-gavel"></i>
            </div>
            <div class="stat-content">
                <h3>إجراء فوري</h3>
                <p>تطبيق الحظر مباشرة</p>
            </div>
        </div>
    </div>

    <!-- Main Form Container -->
    <div class="form-container">
        <div class="form-header">
            <h3>
                <i class="fas fa-user-times"></i>
                بيانات الحظر
            </h3>
            <p>املأ جميع الحقول المطلوبة لإضافة حظر جديد</p>
        </div>
        
        <div class="form-wrapper">
            <form action="<?php echo e(route("admin.ban_management.store")); ?>" method="POST" enctype="multipart/form-data" class="ban-form">
                <?php echo csrf_field(); ?>
                
                <!-- User Selection -->
                <div class="form-group">
                    <label for="user_id" class="form-label">
                        <i class="fas fa-user"></i>
                        المستخدم المراد حظره
                    </label>
                    <div class="select-wrapper">
                        <select class="form-control" id="user_id" name="user_id" required>
                            <option value="">اختر المستخدم من القائمة</option>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?> (<?php echo e($user->email); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <i class="fas fa-chevron-down select-icon"></i>
                    </div>
                    <small class="form-hint">اختر المستخدم الذي تريد حظره من القائمة</small>
                </div>

                <!-- Ban Reason -->
                <div class="form-group">
                    <label for="reason" class="form-label">
                        <i class="fas fa-exclamation-circle"></i>
                        سبب الحظر
                    </label>
                    <input type="text" class="form-control" id="reason" name="reason" required placeholder="أدخل سبب الحظر بوضوح">
                    <small class="form-hint">وضح السبب الذي أدى إلى قرار الحظر</small>
                </div>

                <!-- Ban Duration -->
                <div class="form-group">
                    <label for="duration" class="form-label">
                        <i class="fas fa-hourglass-half"></i>
                        مدة الحظر (بالدقائق)
                    </label>
                    <input type="number" class="form-control" id="duration" name="duration" min="0" placeholder="اترك فارغاً للحظر الدائم">
                    <small class="form-hint">أدخل المدة بالدقائق، أو اتركها فارغة للحظر الدائم</small>
                </div>

                <!-- Ban Message -->
                <div class="form-group">
                    <label for="ban_message" class="form-label">
                        <i class="fas fa-comment-alt"></i>
                        رسالة الحظر
                    </label>
                    <textarea class="form-control" id="ban_message" name="ban_message" rows="4" placeholder="اكتب الرسالة التي ستظهر للمستخدم المحظور"></textarea>
                    <small class="form-hint">هذه الرسالة ستظهر للمستخدم عند محاولة الدخول</small>
                </div>

                <!-- Ban Image URL -->
                <div class="form-group">
                    <label for="ban_image_url" class="form-label">
                        <i class="fas fa-image"></i>
                        رابط صورة الحظر (اختياري)
                    </label>
                    <input type="url" class="form-control" id="ban_image_url" name="ban_image_url" placeholder="https://license.zeinplatform.com/banned.png">
                    <small class="form-hint">رابط صورة توضيحية تظهر مع رسالة الحظر (اختياري)</small>
                </div>

                <!-- Form Actions -->
                <div class="form-actions">
                    <button type="submit" class="btn btn-danger btn-lg">
                        <i class="fas fa-ban"></i>
                        تطبيق الحظر
                    </button>
                    <a href="<?php echo e(route('admin.ban_management.index')); ?>" class="btn btn-secondary btn-lg">
                        <i class="fas fa-times"></i>
                        إلغاء
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
/* Main Container Styles */
.ban-management-container {
    padding: 2rem;
    background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
    min-height: 100vh;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

/* Page Header */
.page-header {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    border: 1px solid rgba(255,255,255,0.2);
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1rem;
}

.page-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: #2d3748;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 1rem;
}

.page-title i {
    color: #f56565;
    font-size: 2rem;
}

.page-subtitle {
    color: #718096;
    font-size: 1.1rem;
    margin: 0.5rem 0 0 0;
}

.header-actions {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

/* Buttons */
.btn {
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    border: none;
    font-weight: 600;
    font-size: 0.95rem;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    text-decoration: none;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
}

.btn-secondary {
    background: linear-gradient(135deg, #a0aec0 0%, #718096 100%);
    color: white;
}

.btn-secondary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(160, 174, 192, 0.4);
}

.btn-info {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.btn-info:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(66, 153, 225, 0.4);
}

.btn-danger {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.btn-danger:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(245, 101, 101, 0.4);
}

.btn-lg {
    padding: 1rem 2rem;
    font-size: 1.1rem;
}

/* Statistics Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: white;
    border-radius: 16px;
    padding: 1.5rem;
    display: flex;
    align-items: center;
    gap: 1rem;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
    border-left: 4px solid;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.15);
}

.stat-card.active {
    border-left-color: #48bb78;
}

.stat-card.warning {
    border-left-color: #ed8936;
}

.stat-card.info {
    border-left-color: #4299e1;
}

.stat-card.total {
    border-left-color: #9f7aea;
}

.stat-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
}

.stat-card.active .stat-icon {
    background: linear-gradient(135deg, #48bb78, #38a169);
    color: white;
}

.stat-card.warning .stat-icon {
    background: linear-gradient(135deg, #ed8936, #dd6b20);
    color: white;
}

.stat-card.info .stat-icon {
    background: linear-gradient(135deg, #4299e1, #3182ce);
    color: white;
}

.stat-card.total .stat-icon {
    background: linear-gradient(135deg, #9f7aea, #805ad5);
    color: white;
}

.stat-content h3 {
    font-size: 1.5rem;
    font-weight: 700;
    color: #2d3748;
    margin: 0;
}

.stat-content p {
    color: #718096;
    margin: 0;
    font-size: 0.9rem;
}

/* Form Container */
.form-container {
    background: white;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.form-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    padding: 2rem;
    border-bottom: 1px solid #e2e8f0;
}

.form-header h3 {
    font-size: 1.8rem;
    font-weight: 600;
    color: #2d3748;
    margin: 0 0 0.5rem 0;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.form-header h3 i {
    color: #f56565;
}

.form-header p {
    color: #718096;
    margin: 0;
    font-size: 1rem;
}

.form-wrapper {
    padding: 2rem;
}

/* Form Styles */
.ban-form {
    max-width: 800px;
    margin: 0 auto;
}

.form-group {
    margin-bottom: 2rem;
}

.form-label {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
    color: #2d3748;
    margin-bottom: 0.75rem;
    font-size: 1rem;
}

.form-label i {
    color: #667eea;
    font-size: 0.9rem;
}

.form-control {
    width: 100%;
    padding: 1rem 1.25rem;
    border: 2px solid #e2e8f0;
    border-radius: 12px;
    font-size: 1rem;
    transition: all 0.3s ease;
    background: white;
    color: #2d3748;
}

.form-control:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    transform: translateY(-1px);
}

.form-control::placeholder {
    color: #a0aec0;
}

/* Select Wrapper */
.select-wrapper {
    position: relative;
}

.select-icon {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #a0aec0;
    pointer-events: none;
    transition: all 0.3s ease;
}

.select-wrapper:focus-within .select-icon {
    color: #667eea;
}

/* Form Hint */
.form-hint {
    color: #718096;
    font-size: 0.85rem;
    margin-top: 0.5rem;
    display: block;
}

/* Form Actions */
.form-actions {
    display: flex;
    gap: 1rem;
    justify-content: center;
    margin-top: 3rem;
    padding-top: 2rem;
    border-top: 1px solid #e2e8f0;
}

/* Responsive Design */
@media (max-width: 768px) {
    .ban-management-container {
        padding: 1rem;
    }
    
    .header-content {
        flex-direction: column;
        align-items: stretch;
    }
    
    .header-actions {
        justify-content: center;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .form-actions {
        flex-direction: column;
        align-items: stretch;
    }
    
    .page-title {
        font-size: 2rem;
    }
    
    .form-header h3 {
        font-size: 1.5rem;
    }
}

/* Animation */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.form-container {
    animation: fadeInUp 0.6s ease;
}

.stat-card {
    animation: fadeInUp 0.6s ease;
}

.stat-card:nth-child(1) { animation-delay: 0.1s; }
.stat-card:nth-child(2) { animation-delay: 0.2s; }
.stat-card:nth-child(3) { animation-delay: 0.3s; }
.stat-card:nth-child(4) { animation-delay: 0.4s; }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Form validation
    const form = document.querySelector('.ban-form');
    const userSelect = document.getElementById('user_id');
    const reasonInput = document.getElementById('reason');
    
    form.addEventListener('submit', function(e) {
        let isValid = true;
        
        // Validate user selection
        if (!userSelect.value) {
            showError(userSelect, 'يجب اختيار مستخدم');
            isValid = false;
        } else {
            clearError(userSelect);
        }
        
        // Validate reason
        if (!reasonInput.value.trim()) {
            showError(reasonInput, 'يجب إدخال سبب الحظر');
            isValid = false;
        } else {
            clearError(reasonInput);
        }
        
        if (!isValid) {
            e.preventDefault();
        }
    });
    
    // Real-time validation
    userSelect.addEventListener('change', function() {
        if (this.value) {
            clearError(this);
        }
    });
    
    reasonInput.addEventListener('input', function() {
        if (this.value.trim()) {
            clearError(this);
        }
    });
    
    function showError(element, message) {
        clearError(element);
        element.style.borderColor = '#f56565';
        const errorDiv = document.createElement('div');
        errorDiv.className = 'error-message';
        errorDiv.style.color = '#f56565';
        errorDiv.style.fontSize = '0.85rem';
        errorDiv.style.marginTop = '0.5rem';
        errorDiv.textContent = message;
        element.parentNode.appendChild(errorDiv);
    }
    
    function clearError(element) {
        element.style.borderColor = '#e2e8f0';
        const errorMessage = element.parentNode.querySelector('.error-message');
        if (errorMessage) {
            errorMessage.remove();
        }
    }
    
    // Enhanced form interactions
    const formControls = document.querySelectorAll('.form-control');
    
    formControls.forEach(control => {
        control.addEventListener('focus', function() {
            this.parentNode.classList.add('focused');
        });
        
        control.addEventListener('blur', function() {
            this.parentNode.classList.remove('focused');
        });
    });
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/ban_management/create.blade.php ENDPATH**/ ?>