<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <?php echo e(config(['app.name' => get_settings('system_title')])); ?>

    <title><?php echo $__env->yieldPushContent('title'); ?> | <?php echo e(config('app.name')); ?></title>

    <!-- all the meta tags -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta content="" name="description" />
    <meta content="" name="author" />
    <link rel="shortcut icon" href="<?php echo e(asset(get_frontend_settings('favicon'))); ?>" />

    <meta content="<?php echo e(csrf_token()); ?>" name="csrf_token" />
    <?php echo $__env->yieldPushContent('meta'); ?>
    <!-- End meta -->

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/backend/vendors/bootstrap/bootstrap.min.css')); ?>" />

    
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/icons/uicons-solid-rounded/css/uicons-solid-rounded.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/icons/uicons-bold-rounded/css/uicons-bold-rounded.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/icons/uicons-bold-straight/css/uicons-bold-straight.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/icons/uicons-regular-rounded/css/uicons-regular-rounded.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/icons/uicons-thin-rounded/css/uicons-thin-rounded.css')); ?>" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/icon-picker/fontawesome-iconpicker.min.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/icon-picker/icons/fontawesome-all.min.css')); ?>" />

    
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/summernote/summernote-lite.min.css')); ?>" rel="stylesheet">

    
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/tagify-master/dist/tagify.css')); ?>" rel="stylesheet" type="text/css" />

    
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/select2/select2.min.css')); ?>" rel="stylesheet" type="text/css" />

    
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/backend/vendors/daterangepicker/daterangepicker.css')); ?>" rel="stylesheet" type="text/css" />


    
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/backend/css/style.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/backend/css/responsive.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/backend/css/custom.css')); ?>">

    <?php echo $__env->yieldPushContent('css'); ?>

    <script type="text/javascript" src="<?php echo e(asset('assets/backend/js/jquery-3.7.1.min.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

</head>

<body>
    <main>
        <!-- Sidebar Navigation -->
        <div class="ol-sidebar">
            <?php echo $__env->make('admin.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>

        <div class="ol-sidebar-content">
            <?php echo $__env->make('admin.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <div class="ol-body-content">
                <div class="container-fluid">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
    </main>


    <?php echo $__env->make('admin.modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <script src="<?php echo e(asset('assets/backend/vendors/bootstrap/bootstrap.bundle.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('assets/global/summernote/summernote-lite.min.js')); ?>"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    
    <script src="<?php echo e(asset('assets/global/icon-picker/fontawesome-iconpicker.min.js')); ?>"></script>

    
    <script type="text/javascript" src="<?php echo e(asset('assets/global/jquery-form/jquery.form.min.js')); ?>"></script>

    
    <script type="text/javascript" src="<?php echo e(asset('assets/global/jquery-ui-1.13.2/jquery-ui.min.js')); ?>"></script>

    
    <script src="<?php echo e(asset('assets/global/tagify-master/dist/tagify.min.js')); ?>"></script>

    
    <script src="<?php echo e(asset('assets/global/select2/select2.min.js')); ?>"></script>

    
    <script src="<?php echo e(asset('assets/backend/vendors/daterangepicker/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/backend/vendors/daterangepicker/daterangepicker.js')); ?>"></script>

    
    <script src="<?php echo e(asset('assets/backend/js/html2pdf.bundle.min.js')); ?>"></script>

    
    <script src="<?php echo e(asset('assets/global/duration-picker/DurationPickerMaker.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/backend/js/script.js')); ?>"></script>

    <?php echo $__env->make('admin.toaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('admin.common_scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('admin.init', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->yieldPushContent('js'); ?>
</body>

</html>
<?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/layouts/admin.blade.php ENDPATH**/ ?>