<?php $__env->startPush('title', get_phrase('إدارة اشتراكات الوظائف')); ?>

<?php $__env->startSection('content'); ?>
<div class="subscription-management-container">
    <!-- Header Section -->
    <div class="page-header">
        <div class="header-content">
            <div class="header-text">
                <h1 class="page-title">
                    <i class="fas fa-crown"></i>
                    إدارة اشتراكات الوظائف
                </h1>
                <p class="page-subtitle">إدارة وتفعيل اشتراكات المستخدمين السنوية</p>
            </div>
            <div class="header-actions">
                <a href="<?php echo e(route('admin.jobs.subscriptions.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i>
                    إضافة اشتراك جديد
                </a>
                <button class="btn btn-secondary" onclick="exportSubscriptions()">
                    <i class="fas fa-download"></i>
                    تصدير البيانات
                </button>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card active">
            <div class="stat-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo e($stats['total_active']); ?></h3>
                <p>اشتراكات نشطة</p>
            </div>
        </div>
        
        <div class="stat-card expired">
            <div class="stat-icon">
                <i class="fas fa-times-circle"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo e($stats['total_expired']); ?></h3>
                <p>اشتراكات منتهية</p>
            </div>
        </div>
        
        <div class="stat-card warning">
            <div class="stat-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo e($stats['expiring_soon']); ?></h3>
                <p>تنتهي خلال أسبوع</p>
            </div>
        </div>
        
        <div class="stat-card total">
            <div class="stat-icon">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-content">
                <h3><?php echo e($stats['total_users']); ?></h3>
                <p>إجمالي المستخدمين</p>
            </div>
        </div>
    </div>

    <!-- Tabs Navigation -->
    <div class="tabs-container">
        <div class="tabs-nav">
            <button class="tab-btn active" data-tab="active">
                <i class="fas fa-check-circle"></i>
                الاشتراكات النشطة
                <span class="badge"><?php echo e($stats['total_active']); ?></span>
            </button>
            <button class="tab-btn" data-tab="expired">
                <i class="fas fa-times-circle"></i>
                الاشتراكات المنتهية
                <span class="badge"><?php echo e($stats['total_expired']); ?></span>
            </button>
        </div>

        <!-- Active Subscriptions Tab -->
        <div class="tab-content active" id="active-tab">
            <div class="table-container">
                <div class="table-header">
                    <h3>الاشتراكات النشطة</h3>
                    <div class="table-actions">
                        <div class="search-box">
                            <i class="fas fa-search"></i>
                            <input type="text" placeholder="البحث في الاشتراكات النشطة..." id="search-active">
                        </div>
                    </div>
                </div>
                
                <div class="table-wrapper">
                    <table class="subscriptions-table">
                        <thead>
                            <tr>
                                <th>المستخدم</th>
                                <th>البريد الإلكتروني</th>
                                <th>تاريخ الانتهاء</th>
                                <th>الأيام المتبقية</th>
                                <th>الحالة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $activeSubscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="user-info">
                                        <div class="user-avatar">
                                            <?php echo e(substr($user->name, 0, 1)); ?>

                                        </div>
                                        <span class="user-name"><?php echo e($user->name); ?></span>
                                    </div>
                                </td>
                                <td><?php echo e($user->email); ?></td>
                                <td>
                                    <span class="date">
                                        <?php echo e(\Carbon\Carbon::parse($user->job_subscription_expires_at)->format('d/m/Y')); ?>

                                    </span>
                                </td>
                                <td>

<?php
    $daysRemaining = \Carbon\Carbon::now()->diffInDays(\Carbon\Carbon::parse($user->job_subscription_expires_at), false);
    $daysRemaining = abs(floor($daysRemaining));
?>
<span class="days-remaining <?php echo e($daysRemaining <= 7 ? 'warning' : 'normal'); ?>">
    <?php echo e($daysRemaining); ?> يوم
</span>
 </td>
                                <td>
                                    <span class="status-badge active">نشط</span>
                                </td>
                                <td>
                                    <div class="action-buttons">
                                        <button class="btn-action edit" onclick="editSubscription(<?php echo e($user->id); ?>)">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn-action view" onclick="viewSubscription(<?php echo e($user->id); ?>)">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button class="btn-action delete" onclick="cancelSubscription(<?php echo e($user->id); ?>)">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="no-data">
                                    <div class="no-data-content">
                                        <i class="fas fa-inbox"></i>
                                        <p>لا توجد اشتراكات نشطة حالياً</p>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                
                <?php if($activeSubscriptions->hasPages()): ?>
                <div class="pagination-wrapper">
                    <?php echo e($activeSubscriptions->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Expired Subscriptions Tab -->
        <div class="tab-content" id="expired-tab">
            <div class="table-container">
                <div class="table-header">
                    <h3>الاشتراكات المنتهية</h3>
                    <div class="table-actions">
                        <div class="search-box">
                            <i class="fas fa-search"></i>
                            <input type="text" placeholder="البحث في الاشتراكات المنتهية..." id="search-expired">
                        </div>
                    </div>
                </div>
                
                <div class="table-wrapper">
                    <table class="subscriptions-table">
                        <thead>
                            <tr>
                                <th>المستخدم</th>
                                <th>البريد الإلكتروني</th>
                                <th>تاريخ الانتهاء</th>
                                <th>منتهي منذ</th>
                                <th>الحالة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $expiredSubscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="user-info">
                                        <div class="user-avatar">
                                            <?php echo e(substr($user->name, 0, 1)); ?>

                                        </div>
                                        <span class="user-name"><?php echo e($user->name); ?></span>
                                    </div>
                                </td>
                                <td><?php echo e($user->email); ?></td>
                                <td>
                                    <span class="date">
                                        <?php echo e(\Carbon\Carbon::parse($user->job_subscription_expires_at)->format('d/m/Y')); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php
                                        $daysPassed = \Carbon\Carbon::parse($user->job_subscription_expires_at)->diffInDays(now());
                                    ?>
                                    <span class="days-passed">
                                        <?php echo e($daysPassed); ?> يوم
                                    </span>
                                </td>
                                <td>
                                    <span class="status-badge expired">منتهي</span>
                                </td>
                                <td>
                                    <div class="action-buttons">
                                        <button class="btn-action renew" onclick="renewSubscription(<?php echo e($user->id); ?>)">
                                            <i class="fas fa-redo"></i>
                                        </button>
                                        <button class="btn-action view" onclick="viewSubscription(<?php echo e($user->id); ?>)">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="no-data">
                                    <div class="no-data-content">
                                        <i class="fas fa-inbox"></i>
                                        <p>لا توجد اشتراكات منتهية</p>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                
                <?php if($expiredSubscriptions->hasPages()): ?>
                <div class="pagination-wrapper">
                    <?php echo e($expiredSubscriptions->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Subscription Details -->
<div id="subscriptionModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3 id="modalTitle">تفاصيل الاشتراك</h3>
            <button class="modal-close" onclick="closeModal()">&times;</button>
        </div>
        <div class="modal-body" id="modalBody">
            <!-- Content will be loaded dynamically -->
        </div>
    </div>
</div>

<style>
/* Main Container Styles */
.subscription-management-container {
    padding: 2rem;
    background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
    min-height: 100vh;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

/* Page Header */
.page-header {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    border: 1px solid rgba(255,255,255,0.2);
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1rem;
}

.page-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: #2d3748;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 1rem;
}

.page-title i {
    color: #f6ad55;
    font-size: 2rem;
}

.page-subtitle {
    color: #718096;
    font-size: 1.1rem;
    margin: 0.5rem 0 0 0;
}

.header-actions {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

/* Buttons */
.btn {
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    border: none;
    font-weight: 600;
    font-size: 0.95rem;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    text-decoration: none;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
}

.btn-secondary {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    color: white;
}

.btn-secondary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(240, 147, 251, 0.4);
}

/* Statistics Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: white;
    border-radius: 16px;
    padding: 1.5rem;
    display: flex;
    align-items: center;
    gap: 1rem;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
    border-left: 4px solid;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.15);
}

.stat-card.active {
    border-left-color: #48bb78;
}

.stat-card.expired {
    border-left-color: #f56565;
}

.stat-card.warning {
    border-left-color: #ed8936;
}

.stat-card.total {
    border-left-color: #4299e1;
}

.stat-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
}

.stat-card.active .stat-icon {
    background: linear-gradient(135deg, #48bb78, #38a169);
    color: white;
}

.stat-card.expired .stat-icon {
    background: linear-gradient(135deg, #f56565, #e53e3e);
    color: white;
}

.stat-card.warning .stat-icon {
    background: linear-gradient(135deg, #ed8936, #dd6b20);
    color: white;
}

.stat-card.total .stat-icon {
    background: linear-gradient(135deg, #4299e1, #3182ce);
    color: white;
}

.stat-content h3 {
    font-size: 2rem;
    font-weight: 700;
    color: #2d3748;
    margin: 0;
}

.stat-content p {
    color: #718096;
    margin: 0;
    font-size: 0.9rem;
}

/* Tabs */
.tabs-container {
    background: white;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.tabs-nav {
    display: flex;
    background: #f7fafc;
    border-bottom: 1px solid #e2e8f0;
}

.tab-btn {
    flex: 1;
    padding: 1.5rem 2rem;
    border: none;
    background: transparent;
    cursor: pointer;
    font-weight: 600;
    color: #718096;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    position: relative;
}

.tab-btn.active {
    color: #667eea;
    background: white;
}

.tab-btn.active::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    height: 3px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.tab-btn .badge {
    background: #e2e8f0;
    color: #4a5568;
    padding: 0.25rem 0.5rem;
    border-radius: 12px;
    font-size: 0.75rem;
    font-weight: 600;
}

.tab-btn.active .badge {
    background: #667eea;
    color: white;
}

/* Tab Content */
.tab-content {
    display: none;
    padding: 2rem;
}

.tab-content.active {
    display: block;
}

/* Table Styles */
.table-container {
    background: white;
    border-radius: 16px;
}

.table-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1.5rem 0;
    border-bottom: 1px solid #e2e8f0;
    margin-bottom: 1rem;
}

.table-header h3 {
    font-size: 1.5rem;
    font-weight: 600;
    color: #2d3748;
    margin: 0;
}

.search-box {
    position: relative;
    width: 300px;
}

.search-box i {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #a0aec0;
}

.search-box input {
    width: 100%;
    padding: 0.75rem 1rem 0.75rem 2.5rem;
    border: 2px solid #e2e8f0;
    border-radius: 12px;
    font-size: 0.9rem;
    transition: all 0.3s ease;
}

.search-box input:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.table-wrapper {
    overflow-x: auto;
}

.subscriptions-table {
    width: 100%;
    border-collapse: collapse;
}

.subscriptions-table th {
    background: #f7fafc;
    padding: 1rem;
    text-align: right;
    font-weight: 600;
    color: #4a5568;
    border-bottom: 2px solid #e2e8f0;
}

.subscriptions-table td {
    padding: 1rem;
    border-bottom: 1px solid #e2e8f0;
    vertical-align: middle;
}

.user-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.user-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 1.1rem;
}

.user-name {
    font-weight: 600;
    color: #2d3748;
}

.date {
    color: #4a5568;
    font-weight: 500;
}

.days-remaining {
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.85rem;
    font-weight: 600;
}

.days-remaining.normal {
    background: #c6f6d5;
    color: #22543d;
}

.days-remaining.warning {
    background: #fed7aa;
    color: #9c4221;
}

.days-passed {
    color: #a0aec0;
    font-size: 0.9rem;
}

.status-badge {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-size: 0.85rem;
    font-weight: 600;
}

.status-badge.active {
    background: #c6f6d5;
    color: #22543d;
}

.status-badge.expired {
    background: #fed7d7;
    color: #742a2a;
}

.action-buttons {
    display: flex;
    gap: 0.5rem;
}

.btn-action {
    width: 36px;
    height: 36px;
    border: none;
    border-radius: 8px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
}

.btn-action.edit {
    background: #bee3f8;
    color: #2b6cb0;
}

.btn-action.edit:hover {
    background: #90cdf4;
    transform: scale(1.1);
}

.btn-action.view {
    background: #d6f5d6;
    color: #22543d;
}

.btn-action.view:hover {
    background: #c6f6d5;
    transform: scale(1.1);
}

.btn-action.delete {
    background: #fed7d7;
    color: #c53030;
}

.btn-action.delete:hover {
    background: #feb2b2;
    transform: scale(1.1);
}

.btn-action.renew {
    background: #faf089;
    color: #744210;
}

.btn-action.renew:hover {
    background: #f6e05e;
    transform: scale(1.1);
}

.no-data {
    text-align: center;
    padding: 3rem;
}

.no-data-content {
    color: #a0aec0;
}

.no-data-content i {
    font-size: 3rem;
    margin-bottom: 1rem;
}

.no-data-content p {
    font-size: 1.1rem;
    margin: 0;
}

/* Modal Styles */
.modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0,0,0,0.5);
    backdrop-filter: blur(5px);
}

.modal-content {
    background-color: white;
    margin: 5% auto;
    padding: 0;
    border-radius: 20px;
    width: 90%;
    max-width: 600px;
    box-shadow: 0 20px 60px rgba(0,0,0,0.3);
    animation: modalSlideIn 0.3s ease;
}

@keyframes modalSlideIn {
    from {
        opacity: 0;
        transform: translateY(-50px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.modal-header {
    padding: 1.5rem 2rem;
    border-bottom: 1px solid #e2e8f0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.modal-header h3 {
    margin: 0;
    color: #2d3748;
    font-weight: 600;
}

.modal-close {
    background: none;
    border: none;
    font-size: 1.5rem;
    cursor: pointer;
    color: #a0aec0;
    transition: color 0.3s ease;
}

.modal-close:hover {
    color: #4a5568;
}

.modal-body {
    padding: 2rem;
}

/* Responsive Design */
@media (max-width: 768px) {
    .subscription-management-container {
        padding: 1rem;
    }
    
    .header-content {
        flex-direction: column;
        align-items: stretch;
    }
    
    .header-actions {
        justify-content: center;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .tabs-nav {
        flex-direction: column;
    }
    
    .search-box {
        width: 100%;
    }
    
    .table-wrapper {
        font-size: 0.85rem;
    }
    
    .subscriptions-table th,
    .subscriptions-table td {
        padding: 0.5rem;
    }
}
</style>

<script>
// Tab switching functionality
document.addEventListener('DOMContentLoaded', function() {
    const tabButtons = document.querySelectorAll('.tab-btn');
    const tabContents = document.querySelectorAll('.tab-content');
    
    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            const targetTab = button.getAttribute('data-tab');
            
            // Remove active class from all tabs and contents
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => content.classList.remove('active'));
            
            // Add active class to clicked tab and corresponding content
            button.classList.add('active');
            document.getElementById(targetTab + '-tab').classList.add('active');
        });
    });
});

// Search functionality
document.getElementById('search-active').addEventListener('input', function(e) {
    searchTable(e.target.value, 'active-tab');
});

document.getElementById('search-expired').addEventListener('input', function(e) {
    searchTable(e.target.value, 'expired-tab');
});

function searchTable(query, tabId) {
    const table = document.querySelector(`#${tabId} .subscriptions-table tbody`);
    const rows = table.querySelectorAll('tr');
    
    rows.forEach(row => {
        const text = row.textContent.toLowerCase();
        const shouldShow = text.includes(query.toLowerCase());
        row.style.display = shouldShow ? '' : 'none';
    });
}

// Modal functions
function viewSubscription(userId) {
    fetch(`<?php echo e(route('admin.jobs.subscriptions.show', '')); ?>/${userId}`)
        .then(response => response.json())
        .then(data => {
            document.getElementById('modalTitle').textContent = 'تفاصيل اشتراك ' + data.name;
            document.getElementById('modalBody').innerHTML = `
                <div class="subscription-details">
                    <div class="detail-row">
                        <strong>الاسم:</strong> ${data.name}
                    </div>
                    <div class="detail-row">
                        <strong>البريد الإلكتروني:</strong> ${data.email}
                    </div>
                    <div class="detail-row">
                        <strong>تاريخ انتهاء الاشتراك:</strong> ${data.job_subscription_expires_at ? new Date(data.job_subscription_expires_at).toLocaleDateString('ar-SA') : 'غير محدد'}
                    </div>
                    <div class="detail-row">
                        <strong>حالة الاشتراك:</strong> 
                        <span class="status-badge ${data.is_active ? 'active' : 'expired'}">
                            ${data.is_active ? 'نشط' : 'منتهي'}
                        </span>
                    </div>
                    ${data.days_remaining !== null ? `
                    <div class="detail-row">
                        <strong>الأيام المتبقية:</strong> ${Math.abs(data.days_remaining)} يوم
                    </div>
                    ` : ''}
                </div>
            `;
            document.getElementById('subscriptionModal').style.display = 'block';
        })
        .catch(error => {
            console.error('Error:', error);
            alert('حدث خطأ أثناء جلب البيانات');
        });
}

function editSubscription(userId) {
    window.location.href = `<?php echo e(route('admin.jobs.subscriptions.create')); ?>?user_id=${userId}`;
}

function renewSubscription(userId) {
    window.location.href = `<?php echo e(route('admin.jobs.subscriptions.create')); ?>?user_id=${userId}&action=renew`;
}

function cancelSubscription(userId) {
    Swal.fire({
        title: 'تأكيد الإلغاء',
        text: 'هل أنت متأكد من إلغاء هذا الاشتراك؟',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'نعم، إلغاء',
        cancelButtonText: 'إلغاء',
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6'
    }).then((result) => {
        if (result.isConfirmed) {
            fetch(`<?php echo e(route('admin.jobs.subscriptions.destroy', '')); ?>/${userId}`, {
                method: 'DELETE',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf_token"]').getAttribute('content'),
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire('تم!', data.message, 'success').then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire('خطأ', data.message, 'error');
                }
            })
            .catch(error => {
                console.error('Error:', error);
                Swal.fire('خطأ', 'حدث خطأ أثناء إلغاء الاشتراك', 'error');
            });
        }
    });
}

function closeModal() {
    document.getElementById('subscriptionModal').style.display = 'none';
}

function exportSubscriptions() {
    // Implementation for export functionality
    alert('ميزة التصدير ستكون متاحة قريباً');
}

// Close modal when clicking outside
window.onclick = function(event) {
    const modal = document.getElementById('subscriptionModal');
    if (event.target === modal) {
        modal.style.display = 'none';
    }
}
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/jobs/subscriptions/index.blade.php ENDPATH**/ ?>