<?php $__env->startPush('title', get_phrase('صفقاتي')); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-briefcase me-2"></i>
                    <?php echo e(get_phrase('صفقاتي')); ?>

                </h4>
                <button class="btn btn-primary btn-sm px-3" data-bs-toggle="modal" data-bs-target="#createDealModal">
                    + صفقة جديدة
                </button>
            </div>
        </div>
    </div>

    <!-- قائمة الصفقات -->
    <div class="row">
        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="col-md-4 deal-card-<?php echo e($order->id); ?>">
                <div class="card shadow-sm border-0 rounded-4 mb-4 position-relative">
                    <div class="card-body">
                        <h5 class="card-title text-primary"><?php echo e($order->title); ?></h5>

                        <!-- الوصف المختصر والموسع -->
                        <div class="description-container">
                            <p class="card-text text-info mb-1">
    <strong>الوصف:</strong> 
    <span class="short-desc"><?php echo e(\Illuminate\Support\Str::limit($order->description, 60)); ?></span>
    <span class="full-desc d-none"><?php echo e($order->description); ?></span>

    <?php if(strlen($order->description) > 60): ?>
        <button class="toggle-description btn btn-link p-0">عرض المزيد</button>
    <?php endif; ?>
</p>
                        </div>

                        <p class="card-text text-secondary mb-1">
                            <strong>الفئة:</strong> 
                            <?php echo e(\App\Models\Category::find($order->category)->title ?? 'غير متوفر'); ?>

                        </p>
                        <p class="card-text text-success">
                            <strong>السعر:</strong> <?php echo e($order->price); ?> ريال
                        </p>

                        <!-- عرض الحالة -->
                        <div class="badge position-absolute top-0 end-0 mt-2 me-2 
                            <?php if($order->status == 'موافق'): ?> bg-success 
                            <?php elseif($order->status == 'مرفوض'): ?> bg-danger 
                            <?php elseif($order->status == 'قيد المراجعة'): ?> bg-warning 
                            <?php endif; ?>">
                            <?php echo e($order->status); ?>

                        </div>

                        <!-- أيقونات التعديل والحذف -->
                        <div class="d-flex justify-content-end gap-2 mt-2">
                            <!-- Trigger Button for Modal -->
                            <button class="btn btn-outline-primary btn-sm edit-deal-btn"
                              data-id="<?php echo e($order->id); ?>"
                              data-title="<?php echo e($order->title); ?>"
                              data-description="<?php echo e($order->description); ?>"
                              data-price="<?php echo e($order->price); ?>"
                              data-category="<?php echo e($order->category); ?>"
                              data-action="<?php echo e(route('instructor.deals.uppdate', $order->id)); ?>"
                              data-bs-toggle="modal"
                              data-bs-target="#editDealModal">
                              <i class="fi-rr-edit me-2"></i> تعديل
                            </button>

                            <!-- زر الحذف -->
                            <button type="button" class="btn btn-outline-danger btn-sm delete-deal" 
                                data-id="<?php echo e($order->id); ?>"
                                data-title="<?php echo e($order->title); ?>">
                                <i class="fi-rr-trash"></i> حذف
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-12">
                <div class="alert alert-info text-center py-4">
                    <i class="fi-rr-info-alt fs-3"></i>
                    <p class="mb-0 mt-2">لا توجد صفقات خاصة بك حالياً</p>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php echo $__env->make('instructor.deals.create', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('instructor.deals.edit', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">
<style>
    /* تخصيص SweetAlert */
    .swal2-popup {
        font-family: 'Tajawal', sans-serif;
        direction: rtl;
        text-align: right;
        border-radius: 12px !important;
    }
    
    .swal2-title {
        font-weight: 600 !important;
        color: #333 !important;
        font-size: 1.25rem !important;
    }
    
    .swal2-html-container {
        font-size: 1rem !important;
    }
    
    /* تخصيص Toastr */
    .toast {
        border-radius: 8px !important;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15) !important;
        font-family: 'Tajawal', sans-serif;
        direction: rtl;
        text-align: right;
    }
    
    .toast-success {
        background-color: #28a745 !important;
    }
    
    .toast-error {
        background-color: #dc3545 !important;
    }
    
    /* تأثيرات الحذف */
    [class*="deal-card-"] {
        transition: all 0.3s ease;
    }
    
    .toggle-description {
        font-size: 0.85rem;
        color: #0d6efd;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // تهيئة Toastr بنفس أسلوب نموذج التعديل
    toastr.options = {
        closeButton: true,
        progressBar: true,
        positionClass: "toast-top-left",
        rtl: true,
        timeOut: 5000,
        extendedTimeOut: 1000,
        showMethod: "fadeIn",
        hideMethod: "fadeOut",
        tapToDismiss: false
    };

    // دالة لعرض رسائل النجاح
    function showSuccess(message) {
        toastr.success(message, '', {
            timeOut: 3000,
            extendedTimeOut: 1000,
            progressBar: true,
            closeButton: true
        });
    }

    // دالة لعرض رسائل الخطأ
    function showError(message) {
        if (typeof message === 'object') {
            message = formatValidationErrors(message);
        }
        toastr.error(message, '', {
            timeOut: 5000,
            extendedTimeOut: 1000,
            progressBar: true,
            closeButton: true
        });
    }

    // تنسيق أخطاء التحقق
    function formatValidationErrors(errors) {
        let message = '<ul style="list-style-type:none;padding-right:0;margin:0;">';
        for (const key in errors) {
            message += `<li><i class="fi-rr-info-alt me-1"></i>${errors[key][0]}</li>`;
        }
        message += '</ul>';
        return message;
    }

    // حذف الصفقة مع SweetAlert2
    document.querySelectorAll('.delete-deal').forEach(button => {
        button.addEventListener('click', function() {
            const dealId = this.getAttribute('data-id');
            const dealTitle = this.getAttribute('data-title');
            const url = "<?php echo e(route('deals.destroy', ':id')); ?>".replace(':id', dealId);
            
            Swal.fire({
                title: 'تأكيد الحذف',
                html: `<div class="text-start">
                        <div class="mb-3 text-danger">
                            <i class="fi-rr-trash fs-4"></i>
                            <span>هل أنت متأكد من حذف الصفقة <strong>"${dealTitle}"</strong>؟</span>
                        </div>
                        <div class="alert alert-warning p-2 text-start">
                            <i class="fi-rr-info-alt"></i>
                            <small>هذا الإجراء لا يمكن التراجع عنه</small>
                        </div>
                      </div>`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'نعم، احذف',
                cancelButtonText: 'إلغاء',
                customClass: {
                    confirmButton: 'btn btn-danger mx-2 px-3',
                    cancelButton: 'btn btn-outline-secondary mx-2 px-3'
                },
                buttonsStyling: false,
                reverseButtons: true,
                focusCancel: true
            }).then((result) => {
                if (result.isConfirmed) {
                    // عرض تحميل
                    Swal.fire({
                        title: 'جاري الحذف...',
                        html: 'الرجاء الانتظار',
                        allowOutsideClick: false,
                        didOpen: () => {
                            Swal.showLoading();
                        }
                    });
                    
                    fetch(url, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                            'Content-Type': 'application/json',
                            'X-Requested-With': 'XMLHttpRequest'
                        },
                        body: JSON.stringify({ _method: 'DELETE' })
                    })
                    .then(response => {
                        if (!response.ok) {
                            throw response;
                        }
                        return response.json();
                    })
                    .then(data => {
                        Swal.close();
                        
                        if (data.success) {
                            // إزالة البطاقة بسلاسة
                            const card = document.querySelector(`.deal-card-${dealId}`);
                            card.style.transition = 'all 0.3s';
                            card.style.opacity = '0';
                            card.style.transform = 'scale(0.95)';
                            
                            setTimeout(() => {
                                card.remove();
                                showSuccess(data.message || 'تم الحذف بنجاح');
                                
                                // إذا لم يعد هناك صفقات
                                if (document.querySelectorAll('[class*="deal-card-"]').length === 0) {
                                    document.querySelector('.row').innerHTML = `
                                        <div class="col-12">
                                            <div class="alert alert-info text-center py-4">
                                                <i class="fi-rr-info-alt fs-3"></i>
                                                <p class="mb-0 mt-2">لا توجد صفقات خاصة بك حالياً</p>
                                            </div>
                                        </div>
                                    `;
                                }
                            }, 300);
                        } else {
                            showError(data.message || 'حدث خطأ أثناء الحذف');
                        }
                    })
                    .catch(async error => {
                        Swal.close();
                        const errorData = await error.json();
                        showError(errorData.message || errorData.errors || 'فشل الاتصال بالخادم');
                    });
                }
            });
        });
    });
document.querySelectorAll('.toggle-description').forEach(button => {
        button.addEventListener('click', function() {
            const shortDesc = this.parentElement.querySelector('.short-desc');
            const fullDesc = this.parentElement.querySelector('.full-desc');
            
            if (shortDesc.classList.contains('d-none')) {
                shortDesc.classList.remove('d-none');
                fullDesc.classList.add('d-none');
                this.textContent = 'عرض المزيد';
            } else {
                shortDesc.classList.add('d-none');
                fullDesc.classList.remove('d-none');
                this.textContent = 'عرض أقل';
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.instructor', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/instructor/deals/my_deals.blade.php ENDPATH**/ ?>