<?php $__env->startPush('title', get_phrase('تفاصيل الإبلاغ #' . $report->id)); ?>

<?php $__env->startSection('content'); ?>
<div class="report-details-container">
    <!-- Header Section -->
    <div class="page-header">
        <div class="header-content">
            <div class="header-text">
                <h1 class="page-title">
                    <i class="fas fa-flag"></i>
                    تفاصيل الإبلاغ #<?php echo e($report->id); ?>

                </h1>
                <p class="page-subtitle">عرض تفاصيل الإبلاغ والمحادثة المرتبطة به</p>
            </div>
            <div class="header-actions">
                <a href="<?php echo e(route('admin.reports.index')); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i>
                    العودة للقائمة
                </a>
                <button onclick="printReport()" class="btn btn-info">
                    <i class="fas fa-print"></i>
                    طباعة التقرير
                </button>
            </div>
        </div>
    </div>

    <!-- Alert Messages -->
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i>
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-circle"></i>
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    <!-- Main Content Grid -->
    <div class="content-grid">
        <!-- Left Column - Report Details -->
        <div class="left-column">
            <!-- Report Information Card -->
            <div class="info-card">
                <div class="card-header">
                    <h3>
                        <i class="fas fa-info-circle"></i>
                        معلومات الإبلاغ
                    </h3>
                    <span class="status-badge <?php echo e($report->status); ?>">
                        <?php switch($report->status):
                            case ('pending'): ?>
                                <i class="fas fa-clock"></i>
                                في الانتظار
                                <?php break; ?>
                            <?php case ('under_review'): ?>
                                <i class="fas fa-search"></i>
                                قيد المراجعة
                                <?php break; ?>
                            <?php case ('resolved'): ?>
                                <i class="fas fa-check-circle"></i>
                                تم الحل
                                <?php break; ?>
                            <?php case ('dismissed'): ?>
                                <i class="fas fa-times-circle"></i>
                                تم الرفض
                                <?php break; ?>
                        <?php endswitch; ?>
                    </span>
                </div>
                <div class="card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <div class="info-label">
                                <i class="fas fa-hashtag"></i>
                                رقم الإبلاغ
                            </div>
                            <div class="info-value">#<?php echo e($report->id); ?></div>
                        </div>
                        
                        <div class="info-item">
                            <div class="info-label">
                                <i class="fas fa-comments"></i>
                                معرف المحادثة
                            </div>
                            <div class="info-value">#<?php echo e($report->conversation_id); ?></div>
                        </div>
                        
                        <div class="info-item">
                            <div class="info-label">
                                <i class="fas fa-user"></i>
                                المبلغ
                            </div>
                            <div class="info-value">
                                <?php if($report->reporter): ?>
                                    <div class="user-info">
                                        <div class="user-avatar">
                                            <?php if($report->reporter->photo): ?>
                                                <img src="<?php echo e(asset($report->reporter->photo)); ?>" alt="user-img">
                                            <?php else: ?>
                                                <?php echo e(substr($report->reporter->name, 0, 1)); ?>

                                            <?php endif; ?>
                                        </div>
                                        <div class="user-details">
                                            <span class="user-name"><?php echo e($report->reporter->name); ?></span>
                                            <span class="user-email"><?php echo e($report->reporter->email); ?></span>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <span class="deleted-user">مستخدم محذوف</span>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="info-item">
                            <div class="info-label">
                                <i class="fas fa-calendar-plus"></i>
                                تاريخ الإبلاغ
                            </div>
                            <div class="info-value">
                                <div class="date-time">
                                    <span class="date"><?php echo e($report->created_at->format('d/m/Y')); ?></span>
                                    <span class="time"><?php echo e($report->created_at->format('H:i:s')); ?></span>
                                </div>
                            </div>
                        </div>
                        
                        <?php if($report->reviewed_at): ?>
                        <div class="info-item">
                            <div class="info-label">
                                <i class="fas fa-calendar-check"></i>
                                تاريخ المراجعة
                            </div>
                            <div class="info-value">
                                <div class="date-time">
                                    <span class="date"><?php echo e($report->reviewed_at->format('d/m/Y')); ?></span>
                                    <span class="time"><?php echo e($report->reviewed_at->format('H:i:s')); ?></span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="info-item">
                            <div class="info-label">
                                <i class="fas fa-user-cog"></i>
                                تمت المراجعة بواسطة
                            </div>
                            <div class="info-value">
                                <?php if($report->reviewer): ?>
                                    <?php echo e($report->reviewer->name); ?>

                                <?php else: ?>
                                    <span class="unknown">غير محدد</span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <div class="info-item">
                            <div class="info-label">
                                <i class="fas fa-lock"></i>
                                حالة المحادثة
                            </div>
                            <div class="info-value">
                                <?php if($report->conversation_closed): ?>
                                    <span class="status-badge closed">
                                        <i class="fas fa-lock"></i>
                                        مغلقة
                                    </span>
                                <?php else: ?>
                                    <span class="status-badge open">
                                        <i class="fas fa-unlock"></i>
                                        مفتوحة
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Report Reason Card -->
            <div class="info-card">
                <div class="card-header">
                    <h3>
                        <i class="fas fa-exclamation-triangle"></i>
                        سبب الإبلاغ
                    </h3>
                </div>
                <div class="card-body">
                    <div class="reason-content">
                        <?php echo e($report->reason); ?>

                    </div>
                </div>
            </div>

            <?php if($report->admin_notes): ?>
            <!-- Admin Notes Card -->
            <div class="info-card">
                <div class="card-header">
                    <h3>
                        <i class="fas fa-sticky-note"></i>
                        ملاحظات الإدارة
                    </h3>
                </div>
                <div class="card-body">
                    <div class="admin-notes-content">
                        <?php echo e($report->admin_notes); ?>

                    </div>
                </div>
            </div>
            <?php endif; ?>

            <?php if($report->conversation_closed && $report->closedConversation): ?>
            <!-- Closure Information Card -->
            <div class="info-card closure-card">
                <div class="card-header">
                    <h3>
                        <i class="fas fa-ban"></i>
                        معلومات إغلاق المحادثة
                    </h3>
                </div>
                <div class="card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <div class="info-label">
                                <i class="fas fa-calendar-times"></i>
                                تاريخ الإغلاق
                            </div>
                            <div class="info-value">
                                <div class="date-time">
                                    <span class="date"><?php echo e($report->closedConversation->created_at->format('d/m/Y')); ?></span>
                                    <span class="time"><?php echo e($report->closedConversation->created_at->format('H:i:s')); ?></span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="info-item">
                            <div class="info-label">
                                <i class="fas fa-user-shield"></i>
                                تم الإغلاق بواسطة
                            </div>
                            <div class="info-value">
                                <?php if($report->closedConversation->closedBy): ?>
                                    <?php echo e($report->closedConversation->closedBy->name); ?>

                                <?php else: ?>
                                    <span class="unknown">غير محدد</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="closure-reason">
                        <div class="info-label">
                            <i class="fas fa-comment-alt"></i>
                            سبب الإغلاق
                        </div>
                        <div class="reason-content">
                            <?php echo e($report->closedConversation->closure_reason); ?>

                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Right Column - Actions & Conversation -->
        <div class="right-column">
            <!-- Actions Card -->
            <div class="actions-card">
                <div class="card-header">
                    <h3>
                        <i class="fas fa-cogs"></i>
                        الإجراءات
                    </h3>
                </div>
                <div class="card-body">
                    <?php if($report->status !== 'resolved' && $report->status !== 'dismissed'): ?>
                    <!-- Status Update Form -->
                    <form action="<?php echo e(route('admin.reports.update-status', $report->id)); ?>" method="POST" class="action-form">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        
                        <div class="form-group">
                            <label for="status">تحديث الحالة</label>
                            <select name="status" id="status" class="form-control" required>
                                <option value="pending" <?php echo e($report->status == 'pending' ? 'selected' : ''); ?>>في الانتظار</option>
                                <option value="under_review" <?php echo e($report->status == 'under_review' ? 'selected' : ''); ?>>قيد المراجعة</option>
                                <option value="resolved" <?php echo e($report->status == 'resolved' ? 'selected' : ''); ?>>تم الحل</option>
                                <option value="dismissed" <?php echo e($report->status == 'dismissed' ? 'selected' : ''); ?>>تم الرفض</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="admin_notes">ملاحظات الإدارة</label>
                            <textarea name="admin_notes" id="admin_notes" class="form-control" rows="4" 
                                      placeholder="أضف ملاحظاتك حول هذا الإبلاغ..."><?php echo e(old('admin_notes', $report->admin_notes)); ?></textarea>
                        </div>

                        <button type="submit" class="btn btn-primary btn-full">
                            <i class="fas fa-save"></i>
                            تحديث الحالة
                        </button>
                    </form>
                    <?php else: ?>
                    <div class="status-final">
                        <i class="fas fa-check-circle"></i>
                        <p>تم الانتهاء من معالجة هذا الإبلاغ</p>
                    </div>
                    <?php endif; ?>

                    <?php if(!$report->conversation_closed): ?>
                    <div class="divider"></div>
                    
                    <!-- Close Conversation Form -->
                    <form action="<?php echo e(route('admin.reports.close-conversation', $report->id)); ?>" method="POST" 
                          class="action-form close-form"
                          onsubmit="return confirm('هل أنت متأكد من إغلاق هذه المحادثة؟ لا يمكن التراجع عن هذا الإجراء.')">
                        <?php echo csrf_field(); ?>
                        
                        <div class="warning-box">
                            <i class="fas fa-exclamation-triangle"></i>
                            <p><strong>تحذير:</strong> إغلاق المحادثة سيمنع المستخدمين من إرسال رسائل جديدة نهائياً.</p>
                        </div>
                        
                        <div class="form-group">
                            <label for="closure_reason">سبب الإغلاق *</label>
                            <textarea name="closure_reason" id="closure_reason" class="form-control" rows="3" 
                                      placeholder="اذكر سبب إغلاق المحادثة..." required></textarea>
                        </div>

                        <button type="submit" class="btn btn-danger btn-full">
                            <i class="fas fa-lock"></i>
                            إغلاق المحادثة نهائياً
                        </button>
                    </form>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Statistics Card -->
            <div class="stats-card">
                <div class="card-header">
                    <h3>
                        <i class="fas fa-chart-bar"></i>
                        إحصائيات سريعة
                    </h3>
                </div>
                <div class="card-body">
                    <div class="stats-grid-small">
                        <div class="stat-item">
                            <div class="stat-number" id="total-reports">-</div>
                            <div class="stat-label">إجمالي الإبلاغات</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number" id="pending-reports">-</div>
                            <div class="stat-label">في الانتظار</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number" id="resolved-reports">-</div>
                            <div class="stat-label">تم الحل</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number" id="closed-conversations">-</div>
                            <div class="stat-label">محادثات مغلقة</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Conversation Messages Section -->
    <div class="conversation-section">
        <div class="section-header">
            <h2>
                <i class="fas fa-comments"></i>
                رسائل المحادثة
                <span class="message-count"><?php echo e($conversationMessages->count()); ?> رسالة</span>
            </h2>
        </div>
        
        <div class="conversation-container">
            <?php if($conversationMessages->count() > 0): ?>
                <div class="messages-list">
                    <?php $__currentLoopData = $conversationMessages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="message-item">
                            <div class="message-header">
                                <div class="sender-info">
                                    <div class="sender-avatar">
                                        <?php if(isset($message->sender_name)): ?>
                                            <?php echo e(substr($message->sender_name, 0, 1)); ?>

                                        <?php else: ?>
                                            ?
                                        <?php endif; ?>
                                    </div>
                                    <div class="sender-details">
                                        <span class="sender-name">
                                            <?php if(isset($message->sender_name)): ?>
                                                <?php echo e($message->sender_name); ?>

                                            <?php else: ?>
                                                مستخدم غير معروف
                                            <?php endif; ?>
                                        </span>
                                        <?php if(isset($message->sender_email)): ?>
                                            <span class="sender-email"><?php echo e($message->sender_email); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="message-time">
                                    <?php echo e(\Carbon\Carbon::parse($message->created_at)->format('d/m/Y H:i:s')); ?>

                                </div>
                            </div>
                            <div class="message-content">
                                <?php echo e($message->message ?? $message->content ?? 'محتوى الرسالة غير متاح'); ?>

                            </div>
                            <?php if(isset($message->receiver_name)): ?>
                                <div class="message-footer">
                                    <span class="receiver-info">
                                        <i class="fas fa-arrow-left"></i>
                                        إلى: <?php echo e($message->receiver_name); ?>

                                        <?php if(isset($message->receiver_email)): ?>
                                            (<?php echo e($message->receiver_email); ?>)
                                        <?php endif; ?>
                                    </span>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="no-messages">
                    <div class="no-messages-content">
                        <i class="fas fa-comments"></i>
                        <h3>لا توجد رسائل</h3>
                        <p>لا توجد رسائل في هذه المحادثة أو لا يمكن الوصول إليها.</p>
                        <small>قد يكون السبب: المحادثة محذوفة، أو تغيير في بنية قاعدة البيانات، أو عدم وجود صلاحيات للوصول.</small>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
/* Main Container */
.report-details-container {
    padding: 2rem;
    background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
    min-height: 100vh;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

/* Page Header */
.page-header {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1rem;
}

.page-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: #2d3748;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 1rem;
}

.page-title i {
    color: #667eea;
    font-size: 2rem;
}

.page-subtitle {
    color: #718096;
    font-size: 1.1rem;
    margin: 0.5rem 0 0 0;
}

.header-actions {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

/* Buttons */
.btn {
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    border: none;
    font-weight: 600;
    font-size: 0.95rem;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    text-decoration: none;
}

.btn-secondary {
    background: linear-gradient(135deg, #a0aec0 0%, #718096 100%);
    color: white;
}

.btn-info {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-danger {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.2);
}

.btn-full {
    width: 100%;
    justify-content: center;
}

/* Alert Messages */
.alert {
    padding: 1rem 1.5rem;
    border-radius: 12px;
    margin-bottom: 1.5rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
}

.alert-success {
    background: #c6f6d5;
    color: #276749;
    border: 1px solid #9ae6b4;
}

.alert-danger {
    background: #fed7d7;
    color: #c53030;
    border: 1px solid #feb2b2;
}

/* Content Grid */
.content-grid {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 2rem;
    margin-bottom: 2rem;
}

/* Cards */
.info-card,
.actions-card,
.stats-card {
    background: white;
    border-radius: 16px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    margin-bottom: 1.5rem;
    overflow: hidden;
}

.card-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 1.5rem;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.card-header h3 {
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 1.2rem;
}

.card-body {
    padding: 1.5rem;
}

/* Info Grid */
.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
}

.info-item {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.info-label {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
    color: #4a5568;
    font-size: 0.9rem;
}

.info-label i {
    color: #667eea;
    width: 16px;
}

.info-value {
    color: #2d3748;
    font-weight: 500;
}

/* User Info */
.user-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.user-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea, #764ba2);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 600;
    overflow: hidden;
}

.user-avatar img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.user-details {
    display: flex;
    flex-direction: column;
}

.user-name {
    font-weight: 600;
    color: #2d3748;
}

.user-email {
    font-size: 0.8rem;
    color: #718096;
}

.deleted-user,
.unknown {
    color: #a0aec0;
    font-style: italic;
}

/* Date Time */
.date-time {
    display: flex;
    flex-direction: column;
}

.date {
    font-weight: 600;
    color: #2d3748;
}

.time {
    font-size: 0.8rem;
    color: #718096;
}

/* Status Badges */
.status-badge {
    display: inline-flex;
    align-items: center;
    gap: 0.25rem;
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
}

.status-badge.pending {
    background: #fed7d7;
    color: #c53030;
}

.status-badge.under_review {
    background: #bee3f8;
    color: #2b6cb0;
}

.status-badge.resolved {
    background: #c6f6d5;
    color: #276749;
}

.status-badge.dismissed {
    background: #e2e8f0;
    color: #4a5568;
}

.status-badge.open {
    background: #c6f6d5;
    color: #276749;
}

.status-badge.closed {
    background: #fed7d7;
    color: #c53030;
}

/* Reason Content */
.reason-content,
.admin-notes-content {
    background: #f7fafc;
    padding: 1.5rem;
    border-radius: 12px;
    border: 1px solid #e2e8f0;
    line-height: 1.6;
    color: #2d3748;
}

/* Closure Card */
.closure-card .card-header {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
}

.closure-reason {
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid #e2e8f0;
}

/* Action Forms */
.action-form {
    margin-bottom: 1.5rem;
}

.form-group {
    margin-bottom: 1rem;
}

.form-group label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: #4a5568;
}

.form-control {
    width: 100%;
    padding: 0.75rem;
    border: 2px solid #e2e8f0;
    border-radius: 8px;
    font-size: 0.9rem;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.divider {
    height: 1px;
    background: #e2e8f0;
    margin: 1.5rem 0;
}

.warning-box {
    background: #fef5e7;
    color: #744210;
    border: 1px solid #f6e05e;
    padding: 1rem;
    border-radius: 8px;
    margin-bottom: 1rem;
    display: flex;
    align-items: flex-start;
    gap: 0.5rem;
}

.warning-box i {
    margin-top: 0.2rem;
}

.status-final {
    text-align: center;
    padding: 2rem;
    color: #48bb78;
}

.status-final i {
    font-size: 3rem;
    margin-bottom: 1rem;
}

/* Stats Grid Small */
.stats-grid-small {
    display: grid;
    grid-template-columns: repeat(2, 1fr);
    gap: 1rem;
}

.stat-item {
    text-align: center;
    padding: 1rem;
    background: #f7fafc;
    border-radius: 12px;
    border: 1px solid #e2e8f0;
}

.stat-number {
    font-size: 1.5rem;
    font-weight: 700;
    color: #667eea;
    margin-bottom: 0.25rem;
}

.stat-label {
    font-size: 0.8rem;
    color: #718096;
}

/* Conversation Section */
.conversation-section {
    background: white;
    border-radius: 16px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    overflow: hidden;
}

.section-header {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
    padding: 1.5rem;
}

.section-header h2 {
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 1.5rem;
}

.message-count {
    background: rgba(255,255,255,0.2);
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.8rem;
    margin-right: auto;
}

.conversation-container {
    padding: 1.5rem;
    max-height: 600px;
    overflow-y: auto;
}

/* Messages */
.messages-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.message-item {
    background: #f7fafc;
    border: 1px solid #e2e8f0;
    border-radius: 12px;
    padding: 1rem;
    transition: all 0.3s ease;
}

.message-item:hover {
    background: #edf2f7;
    border-color: #cbd5e0;
}

.message-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 0.75rem;
}

.sender-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.sender-avatar {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    background: linear-gradient(135deg, #4299e1, #3182ce);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 600;
    font-size: 0.9rem;
}

.sender-details {
    display: flex;
    flex-direction: column;
}

.sender-name {
    font-weight: 600;
    color: #2d3748;
}

.sender-email {
    font-size: 0.8rem;
    color: #718096;
}

.message-time {
    font-size: 0.8rem;
    color: #a0aec0;
}

.message-content {
    color: #2d3748;
    line-height: 1.6;
    margin-bottom: 0.5rem;
}

.message-footer {
    border-top: 1px solid #e2e8f0;
    padding-top: 0.5rem;
    margin-top: 0.5rem;
}

.receiver-info {
    font-size: 0.8rem;
    color: #718096;
    display: flex;
    align-items: center;
    gap: 0.25rem;
}

/* No Messages */
.no-messages {
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 300px;
}

.no-messages-content {
    text-align: center;
    color: #a0aec0;
}

.no-messages-content i {
    font-size: 4rem;
    margin-bottom: 1rem;
}

.no-messages-content h3 {
    color: #4a5568;
    margin-bottom: 0.5rem;
}

.no-messages-content p {
    color: #718096;
    margin-bottom: 0.5rem;
}

.no-messages-content small {
    color: #a0aec0;
    font-size: 0.8rem;
}

/* Responsive Design */
@media (max-width: 1024px) {
    .content-grid {
        grid-template-columns: 1fr;
    }
    
    .info-grid {
        grid-template-columns: 1fr;
    }
    
    .stats-grid-small {
        grid-template-columns: repeat(4, 1fr);
    }
}

@media (max-width: 768px) {
    .report-details-container {
        padding: 1rem;
    }
    
    .header-content {
        flex-direction: column;
        align-items: stretch;
    }
    
    .page-title {
        font-size: 2rem;
    }
    
    .stats-grid-small {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .message-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
    }
}

@media (max-width: 480px) {
    .stats-grid-small {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
// Load statistics on page load
document.addEventListener('DOMContentLoaded', function() {
    loadStatistics();
});

function loadStatistics() {
    fetch('/admin/api/reports/stats')
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('total-reports').textContent = data.data.total_reports;
                document.getElementById('pending-reports').textContent = data.data.pending_reports;
                document.getElementById('resolved-reports').textContent = data.data.resolved_reports;
                document.getElementById('closed-conversations').textContent = data.data.closed_conversations;
            }
        })
        .catch(error => {
            console.error('Error loading statistics:', error);
        });
}

function printReport() {
    window.print();
}

// Auto-scroll to latest message
const conversationContainer = document.querySelector('.conversation-container');
if (conversationContainer) {
    conversationContainer.scrollTop = conversationContainer.scrollHeight;
}
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/reports/show.blade.php ENDPATH**/ ?>