<?php $__env->startPush('title', get_phrase('المحفظه')); ?>
<?php $__env->startSection('content'); ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('المحفظه')); ?>

                </h4>

               
            </div>
        </div>
    </div>
    
    
<div class="container-fluid">

    <div class="row">
        <!-- إجمالي الرصيد -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow-lg h-100 py-3">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                <?php echo e(get_phrase('إجمالي الرصيد')); ?>

                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e(number_format($stats['total_balance'], 2)); ?> ر.س
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-wallet fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- رصيد متاح -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow-lg h-100 py-3">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                <?php echo e(get_phrase('رصيد متاح')); ?>

                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e(number_format($stats['available_balance'], 2)); ?> ر.س
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-money-bill-wave fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- رصيد مجمد -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow-lg h-100 py-3">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                <?php echo e(get_phrase('رصيد مجمد')); ?>

                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e(number_format($stats['frozen_balance'], 2)); ?> ر.س
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-lock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- طلبات سحب معلقة -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow-lg h-100 py-3">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                <?php echo e(get_phrase('طلبات سحب معلقة')); ?>

                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($stats['pending_withdrawals']); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- آخر المعاملات -->
    <div class="row">
        <div class="col-md-6">
            <div class="card shadow-lg mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary"><?php echo e(get_phrase('آخر المعاملات')); ?></h6>
                    <a href="<?php echo e(route('admin.wallet.transactions')); ?>" class="btn btn-sm btn-primary"><?php echo e(get_phrase('عرض الكل')); ?></a>
                </div>
                <div class="card-body">
                    <?php
                        $latestTransactions = \App\Models\WalletTransaction::with(['sender', 'receiver'])
                            ->orderBy('created_at', 'desc')
                            ->take(5)
                            ->get();
                    ?>

                    <?php if($latestTransactions->count() > 0): ?>
                        <div class="list-group">
                            <?php $__currentLoopData = $latestTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('admin.wallet.transactions.show', $transaction->id)); ?>" 
                                   class="list-group-item list-group-item-action">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h6 class="mb-1"><?php echo e(get_phrase('عملية')); ?> #<?php echo e($transaction->transaction_id); ?></h6>
                                        <small class="text-<?php echo e($transaction->status == 'completed' ? 'success' : ($transaction->status == 'pending' ? 'warning' : 'danger')); ?>">
                                            <?php echo e($transaction->status == 'completed' ? get_phrase('مكتمل') : ($transaction->status == 'pending' ? get_phrase('معلق') : get_phrase('ملغى'))); ?>

                                        </small>
                                    </div>
                                    <p class="mb-1">
                                        <?php echo e(get_phrase('من')); ?>: <?php echo e($transaction->sender->name); ?> 
                                        <?php echo e(get_phrase('إلى')); ?>: <?php echo e(optional($transaction->receiver)->name); ?>


                                    </p>
                                    <small class="text-muted">
                                        <?php echo e($transaction->amount); ?> ر.س - <?php echo e($transaction->created_at->diffForHumans()); ?>

                                    </small>
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <p class="text-center text-muted"><?php echo e(get_phrase('لا توجد معاملات حديثة')); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- طلبات سحب حديثة -->
        <div class="col-md-6">
            <div class="card shadow-lg mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary"><?php echo e(get_phrase('طلبات سحب حديثة')); ?></h6>
                    <a href="<?php echo e(route('admin.wallet.withdrawal-requests')); ?>" class="btn btn-sm btn-primary"><?php echo e(get_phrase('عرض الكل')); ?></a>
                </div>
                <div class="card-body">
                    <?php
                        $latestWithdrawals = \App\Models\WithdrawalRequest::with(['user'])
                            ->where('status', 'pending')
                            ->orderBy('created_at', 'desc')
                            ->take(5)
                            ->get();
                    ?>

                    <?php if($latestWithdrawals->count() > 0): ?>
                        <div class="list-group">
                            <?php $__currentLoopData = $latestWithdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdrawal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('admin.wallet.withdrawal-requests.show', $withdrawal->id)); ?>" 
                                   class="list-group-item list-group-item-action">
                                    <div class="d-flex w-100 justify-content-between">
                                        <h6 class="mb-1"><?php echo e(get_phrase('طلب')); ?> #<?php echo e($withdrawal->request_id); ?></h6>
                                        <small class="text-warning"><?php echo e(get_phrase('قيد الانتظار')); ?></small>
                                    </div>
                                    <p class="mb-1"><?php echo e(get_phrase('المستخدم')); ?>: <?php echo e($withdrawal->user->name); ?></p>
                                    <small class="text-muted">
                                        <?php echo e($withdrawal->amount); ?> ر.س - <?php echo e($withdrawal->created_at->diffForHumans()); ?>

                                    </small>
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <p class="text-center text-muted"><?php echo e(get_phrase('لا توجد طلبات سحب حديثة')); ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/wallet/dashboard.blade.php ENDPATH**/ ?>