<!DOCTYPE html>
<html lang="en">

<head>
    <title><?php echo e(get_phrase('Course Playing Page')); ?>| <?php echo e(config('app.name')); ?></title>
    <!-- all the meta tags -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta content="" name="description" />
    <meta content="" name="author" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- all the css files -->
    <link rel="shortcut icon" href="<?php echo e(asset(get_frontend_settings('favicon'))); ?>" />
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/default/css/bootstrap.min.css')); ?>">
    <!-- Fontawesome CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/course_player/vendors/fontawesome/fontawesome.css')); ?>" />
    <!-- Player CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/plyr/plyr.css')); ?>" />
    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/course_player/css/style.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/course_player/css/custom.css')); ?>" />
    <!-- FlatIcons Css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/icons/uicons-bold-rounded/css/uicons-bold-rounded.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/icons/uicons-bold-straight/css/uicons-bold-straight.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/icons/uicons-regular-rounded/css/uicons-regular-rounded.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/icons/uicons-solid-rounded/css/uicons-solid-rounded.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/icons/uicons-solid-rounded/css/uicons-solid-rounded.css')); ?>" />

    <!-- Summernote Css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/summernote/summernote.min.css')); ?>">

    <!-- Yaireo Tagify -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/tagify-master/dist/tagify.css')); ?>" rel="stylesheet" type="text/css" />

</head>

<body>

    <!-- Start Course Playing Header -->
    <header class="playing-header-section">
        <?php echo $__env->make('course_player.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </header>
    <!-- End Course Playing Header -->

    <!-- Start Course Playing Video and Playlist Area -->
    <section class="video-playlist-section">
        <div class="my-container">
            <div class="row">
                <div class="col-lg-8" id="player_content">
<?php if(
    optional($lesson_details)->id &&
    optional($course_details)->id &&
    optional(auth()->user())->id &&
    in_array($lesson_details->id, get_locked_lesson_ids($course_details->id, auth()->user()->id)) &&
    $course_details->enable_drip_content
): ?>
                        <?php
                           $drip_content_settings =  json_decode($course_details->drip_content_settings);
                        ?>
                        <div class="py-5 my-5">
                            <?php echo remove_js(htmlspecialchars_decode($drip_content_settings->locked_lesson_message ?? "")); ?>

                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('course_player.player_page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?>
                    <!-- Tab -->
                    <div class="course-video-navtab">
                        <?php echo $__env->make('course_player.tab_bar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                </div>
                <div class="col-lg-4" id="player_side_bar">
                    <?php echo $__env->make('course_player.side_bar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            </div>
        </div>
    </section>
    <!-- End Course Playing Video and Playlist Area -->

    <!-- Main Jquery -->
    <script src="<?php echo e(asset('assets/frontend/default/js/jquery-3.7.1.min.js')); ?>"></script>

    <!-- Bootstrap bundle with popper -->
    <script src="<?php echo e(asset('assets/frontend/default/js/bootstrap.bundle.min.js')); ?>"></script>

    <!-- Summernote Css -->
    <script src="<?php echo e(asset('assets/global/summernote/summernote.min.js')); ?>"></script>

    <!-- Fontawesome JS -->
    <script src="<?php echo e(asset('assets/global/course_player/vendors/fontawesome/fontawesome.all.min.js')); ?>"></script>

    <!-- Player JS -->
    <script src="<?php echo e(asset('assets/global/plyr/plyr.js')); ?>"></script>

    <!-- Yaireo Tagify -->
    <script src="<?php echo e(asset('assets/global/tagify-master/dist/tagify.min.js')); ?>"></script>

    <!-- Jquery form -->
    <script type="text/javascript" src="<?php echo e(asset('assets/global/jquery-form/jquery.form.min.js')); ?>"></script>

    <!-- toster file -->
    <?php echo $__env->make('frontend.default.toaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Custom Script -->
    <script src="<?php echo e(asset('assets/global/course_player/js/script.js')); ?>"></script>

    <?php echo $__env->make('course_player.init', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->yieldPushContent('js'); ?>
</body>

</html>
<?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/course_player/index.blade.php ENDPATH**/ ?>