<?php
    $countries = App\Models\Country::all();
?>

<form class="ajaxFormSubmission" action="<?php echo e(route('instructor.manage.education_add')); ?>" method="post" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>

    <div class="form-group mb-3">
        <label class="form-label ol-form-label"><?php echo e(get_phrase('Title')); ?></label>
        <input type="text" name="title" class="form-control ol-form-control" required>
    </div>
    
    <div class="form-group mb-3">
        <label class="form-label ol-form-label"><?php echo e(get_phrase('Institute')); ?></label>
        <input type="text" name="institute" class="form-control ol-form-control" required>
    </div>

    <!-- Country and City in the same row -->
    <div class="row">
        <div class="col-md-6 form-group mb-3">
            <label class="form-label ol-form-label"><?php echo e(get_phrase('Country')); ?></label>
            <select class="form-control ol-select2" data-toggle="select2" name="country" required>
                <option value=""><?php echo e(get_phrase('Select a country')); ?></option>
                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($country->name); ?>"><?php echo e($country->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="col-md-6 form-group mb-3">
            <label class="form-label ol-form-label"><?php echo e(get_phrase('City')); ?></label>
            <input type="text" name="city" class="form-control ol-form-control" required>
        </div>
    </div>

    <!-- Start Date and End Date in the same row -->
    <div class="row">
        <div class="col-md-6 form-group mb-3">
            <label class="form-label ol-form-label" for="start_date"><?php echo e(get_phrase('Start Date')); ?></label>
            <input type="date" name="start_date" id="start_date" class="form-control ol-form-control">
        </div>

        <div class="col-md-6 form-group mb-3">
            <label class="form-label ol-form-label" for="end_date"><?php echo e(get_phrase('End Date')); ?></label>
            <input type="date" name="end_date" id="end_date" class="form-control ol-form-control">
        </div>
    </div>

    <div class="form-group mb-3">
        <input type="checkbox" name="status" id="status" value="ongoing" class="form-check-input">
        <label for="status" class="form-label ol-form-label"><?php echo e(get_phrase('This degree/course is currently ongoing')); ?></label>
    </div>

    <div class="form-group mb-3">
        <label class="form-label ol-form-label"><?php echo e(get_phrase('description')); ?></label>
        <textarea name="description" class="form-control text_editor"></textarea>
    </div>

    <div class="text-center">
        <button class="btn ol-btn-primary ol-btn-sm w-100 formSubmissionBtn" type="submit" name="button"><?php echo e(get_phrase('Save')); ?></button>
    </div>
</form>

<?php echo $__env->make('instructor.init', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/instructor/resume/add_education.blade.php ENDPATH**/ ?>