<?php $__env->startPush('title', get_phrase('Application')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <?php
        $pendings = App\Models\Application::where('status', 0)->paginate(10);
        $approved = App\Models\Application::where('status', 1)->paginate(10);
    ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-4 px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('Instructor Applicationss')); ?>

                </h4>
            </div>
        </div>
    </div>

    <div class="ol-card p-4">
        <div class="ol-card-body">
            <ul class="nav nav-tabs eNav-Tabs-custom eTab" id="myTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="cHome-tab" data-bs-toggle="tab" data-bs-target="#cHome" type="button" role="tab" aria-controls="cHome"
                        aria-selected="true">
                        <?php echo e(get_phrase('Pending applications')); ?>

                        <span></span>
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="cProfile-tab" data-bs-toggle="tab" data-bs-target="#cProfile" type="button" role="tab" aria-controls="cProfile"
                        aria-selected="false">
                        <?php echo e(get_phrase('Approved applications')); ?>

                        <span></span>
                    </button>
                </li>
            </ul>
            <div class="tab-content eNav-Tabs-content mt-4" id="myTabContent">
                <div class="tab-pane fade show active" id="cHome" role="tabpanel" aria-labelledby="cHome-tab">
                    <?php if(count($pendings) > 0): ?>
                        <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                            <p class="admin-tInfo">
                                <?php echo e(get_phrase('Showing') . ' ' . count($pendings) . ' ' . get_phrase('of') . ' ' . $pendings->total() . ' ' . get_phrase('data')); ?>

                            </p>
                        </div>
                        <div class="table-responsive">
                            <table id="pending-application" class="table eTable">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(get_phrase('Name')); ?></th>
                                        <th><?php echo e(get_phrase('Document')); ?></th>
                                        <th><?php echo e(get_phrase('Details')); ?></th>
                                        <th><?php echo e(get_phrase('Status')); ?></th>
                                        <th><?php echo e(get_phrase('Action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $pendings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pending): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="gradeU">
                                            <td><?php echo e(++$key); ?></td>
                                            <td><?php echo e(get_user_info($pending->user_id)->name); ?></td>
                                            <td>
                                                <a href="javascript:void(0);" class="btn ol-btn-primary"
                                                    onclick="ajaxModal('<?php echo e(route('modal', ['admin.instructor.show_document', 'id' => $pending->id])); ?>', '<?php echo e(get_phrase('Applicant details')); ?>')">
                                                    <i class="fa fa-info-circle"></i>
                                                    <?php echo e(get_phrase('Application details')); ?>

                                                </a>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('admin.instructor.application.download', ['id' => $pending->id])); ?>" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Download')); ?>" class="btn ol-btn-light ol-icon-btn">
                                                    <span class="fi-rr-download"></span></a>
                                            </td>
                                            <td>
                                                <?php if($pending->status == 0): ?>
                                                    <div class="badge bg-danger">
                                                        <?php echo e(get_phrase('Pending')); ?>

                                                    </div>
                                                <?php else: ?>
                                                    <div class="badge bg-success">
                                                        <?php echo e(get_phrase('Approved')); ?>

                                                    </div>
                                                <?php endif; ?>

                                            </td>
                                            <td>
                                                <div class="dropdown ol-icon-dropdown ol-icon-dropdown-transparent">
                                                    <button class="btn ol-btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                        <span class="fi-rr-menu-dots-vertical"></span>
                                                    </button>
                                                    <ul class="dropdown-menu">
                                                        <li>
                                                            <a class="dropdown-item" href="#"
                                                                onclick="confirmModal('<?php echo e(route('admin.instructor.application.approve', $pending->id)); ?>')"><?php echo e(get_phrase('Approve')); ?>

                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item" href="#"
                                                                onclick="confirmModal('<?php echo e(route('admin.instructor.application.delete', $pending->id)); ?>')"><?php echo e(get_phrase('Delete')); ?>

                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <?php if(count($pendings)): ?>
                            <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                                <p class="admin-tInfo">
                                    <?php echo e(get_phrase('Showing') . ' ' . count($pendings) . ' ' . get_phrase('of') . ' ' . $pendings->total() . ' ' . get_phrase('data')); ?>

                                </p>
                            </div>
                            <?php echo e($pendings->links()); ?>

                        <?php endif; ?>
                    <?php endif; ?>
                </div>
                <div class="tab-pane fade" id="cProfile" role="tabpanel" aria-labelledby="cProfile-tab">
                    <?php if(count($approved)): ?>
                        <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                            <p class="admin-tInfo">
                                <?php echo e(get_phrase('Showing') . ' ' . count($approved) . ' ' . get_phrase('of') . ' ' . $approved->total() . ' ' . get_phrase('data')); ?>

                            </p>
                        </div>
                        <div class="table-responsive">
                            <table id="approved-application" class="table eTable">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(get_phrase('Name')); ?></th>
                                        <th><?php echo e(get_phrase('Document')); ?></th>
                                        <th><?php echo e(get_phrase('Details')); ?></th>
                                        <th><?php echo e(get_phrase('Status')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $approved; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $approve): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="gradeU">
                                            <td><?php echo e(++$key); ?></td>
                                            <td><?php echo e(get_user_info($approve->user_id)->name); ?></td>
                                            <td>
                                                <a href="javascript:void(0);" class="btn ol-btn-primary"
                                                    onclick="ajaxModal('<?php echo e(route('modal', ['admin.instructor.show_document', 'id' => $approve->id])); ?>', '<?php echo e(get_phrase('Applicant details')); ?>')">
                                                    <i class="fa fa-info-circle"></i>
                                                    <?php echo e(get_phrase('Application details')); ?>

                                                </a>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('admin.instructor.application.download', ['id' => $approve->id])); ?>" class="btn ol-btn-light ol-icon-btn"><span
                                                        class="fi-rr-download"></span></a>
                                            </td>
                                            <td>
                                                <?php if($approve->status == 0): ?>
                                                    <div class="badge bg-danger">
                                                        <?php echo e(get_phrase('Pending')); ?>

                                                    </div>
                                                <?php else: ?>
                                                    <div class="badge bg-success">
                                                        <?php echo e(get_phrase('Approved')); ?>

                                                    </div>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <?php if(count($approved)): ?>
                            <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                                <p class="admin-tInfo">
                                    <?php echo e(get_phrase('Showing') . ' ' . count($approved) . ' ' . get_phrase('of') . ' ' . $approved->total() . ' ' . get_phrase('data')); ?>

                                </p>
                            </div>
                            <?php echo e($approved->links()); ?>

                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div> <!-- end card-body-->
    </div> <!-- end card-->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script type="text/javascript">
        "use strict";

        $(document).ready(function() {
            initDataTable(['#pending-application', '#approved-application']);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/admin/instructor/application.blade.php ENDPATH**/ ?>