<?php $__env->startPush('title', get_phrase('My Bootcamps')); ?>
<?php $__env->startSection('content'); ?>
    <section class="my-course-content mt-50">
        <div class="profile-banner-area"></div>
        <div class="profile-banner-area-container container">
            <div class="row">
                <?php echo $__env->make('frontend.default.student.left_sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

                <div class="col-lg-9">
                    <h4 class="g-title text-capitalize"><?php echo e(get_phrase('My Bootcamps')); ?></h4>
                    <div class="my-panel mt-5">
                        <div class="row">
                            <?php if(count($my_bootcamps) > 0): ?>
                                <ul class="my-bootcamps">
                                    <?php $__currentLoopData = $my_bootcamps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bootcamp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="p-0" id="bootcamp-<?php echo e($bootcamp->id); ?>">
                                            <a href="<?php echo e(route('my.bootcamp.details', $bootcamp->slug)); ?>" class="bootcamp d-flex gap-4">
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="bootcamp-thumbnail">
                                                            <img src="<?php echo e(get_image($bootcamp->thumbnail)); ?>">
                                                        </div>
                                                    </div>

                                                    <div class="col-md-9">
                                                        <div class="bootcamp-details">
                                                            <div class="inner">
                                                                <h4 class="bootcamp-title">
                                                                    <span class="ellipsis-2"><?php echo e($bootcamp->title); ?></span>
                                                                    <i class="fi fi-br-angle-small-right"></i>
                                                                </h4>

                                                                <p class="d-inline-block me-4">
                                                                    <span>
                                                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" class="m-0">
                                                                            <path d="M18.3307 10.0003C18.3307 14.6003 14.5974 18.3337 9.9974 18.3337C5.3974 18.3337 1.66406 14.6003 1.66406 10.0003C1.66406 5.40033 5.3974 1.66699 9.9974 1.66699C14.5974 1.66699 18.3307 5.40033 18.3307 10.0003Z"
                                                                                stroke="#6B7385" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round">
                                                                            </path>
                                                                            <path d="M13.0875 12.65L10.5042 11.1083C10.0542 10.8416 9.6875 10.2 9.6875 9.67497V6.2583" stroke="#6B7385" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round">
                                                                            </path>
                                                                        </svg>
                                                                    </span>
                                                                    <?php echo e(date('d M, Y', $bootcamp->publish_date)); ?>

                                                                </p>

                                                                <p class="d-inline-block me-4">
                                                                    <span>
                                                                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg" class="m-0">
                                                                            <path d="M1.67188 7.5V6.66667C1.67188 4.16667 3.33854 2.5 5.83854 2.5H14.1719C16.6719 2.5 18.3385 4.16667 18.3385 6.66667V13.3333C18.3385 15.8333 16.6719 17.5 14.1719 17.5H13.3385" stroke="#6B7385" stroke-width="1.25"
                                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                                            <path d="M3.07812 9.7583C6.92813 10.25 9.75313 13.0833 10.2531 16.9333" stroke="#6B7385" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round" />
                                                                            <path d="M2.1875 12.5586C5.0125 12.9169 7.08751 15.0003 7.45417 17.8253" stroke="#6B7385" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round" />
                                                                            <path d="M1.65234 15.7168C3.06068 15.9001 4.10235 16.9335 4.28568 18.3501" stroke="#6B7385" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round" />
                                                                        </svg>
                                                                    </span>
                                                                    <span><?php echo e(count_bootcamp_classes($bootcamp->id)); ?></span>
                                                                    <span><?php echo e(get_phrase('Live class')); ?></span>
                                                                </p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php else: ?>
                                <?php echo $__env->make('frontend.default.empty', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pagination -->
            <?php if(count($my_bootcamps) > 0): ?>
                <div class="entry-pagination">
                    <nav aria-label="Page navigation example">
                        <?php echo e($my_bootcamps->links()); ?>

                    </nav>
                </div>
            <?php endif; ?>
            <!-- Pagination -->
        </div>
    </section>
    <!------------ My wishlist area End  ------------>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/frontend/default/student/my_bootcamps/index.blade.php ENDPATH**/ ?>