<div class="modal fade" id="editDealModal" tabindex="-1" aria-labelledby="editDealModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content border-0">
      <form id="editDealForm" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <div class="modal-header bg-white text-dark rounded-top-3">
          <h5 class="modal-title fw-bold" id="editDealModalLabel">تعديل بيانات الصفقة</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
        </div>

        <div class="modal-body p-4">
          <input type="hidden" name="user_id" value="<?php echo e(auth()->user()->id); ?>">
          <input type="hidden" name="deal_id" id="modalDealId">

          <div class="row g-4">
            <!-- العنوان -->
            <div class="col-md-6">
              <div class="form-floating">
                <input type="text" name="title" class="form-control border-2 border-primary" id="titleInput" placeholder="عنوان الصفقة" required>
                <label for="titleInput" class="text-muted">عنوان الصفقة</label>
              </div>
            </div>

            <!-- الفئة -->
            <div class="col-md-6">
              <div class="form-floating">
                <select name="category" class="form-select border-2 border-primary" id="categorySelect" required>
                  <option value="" disabled selected>اختر الفئة</option>
                  <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($category->id); ?>"><?php echo e($category->title); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <label for="categorySelect" class="text-muted">الفئة</label>
              </div>
            </div>

            <!-- الوصف -->
            <div class="col-12">
              <div class="form-floating">
                <textarea name="description" class="form-control border-2 border-primary" id="descriptionTextarea" placeholder="وصف الصفقة" style="height: 120px" required></textarea>
                <label for="descriptionTextarea" class="text-muted">الوصف</label>
              </div>
            </div>

            <!-- السعر -->
            <div class="col-md-6">
              <div class="form-floating">
                <input type="number" name="price" class="form-control border-2 border-primary" id="priceInput" step="0.01" placeholder="السعر" required>
                <label for="priceInput" class="text-muted">السعر (ر.س)</label>
              </div>
            </div>
          </div>
        </div>

        <div class="modal-footer bg-light rounded-bottom-3">
          <button type="button" class="btn btn-outline-secondary rounded-pill px-4" data-bs-dismiss="modal">
            <i class="bi bi-x-circle me-2"></i> إلغاء
          </button>
          <button type="submit" class="btn btn-primary rounded-pill px-4" id="submitDealBtn">
            <span class="spinner-border spinner-border-sm d-none" id="submitSpinner"></span>
            <span class="submit-text"><i class="bi bi-check-circle me-2"></i> حفظ التغييرات</span>
          </button>
        </div>
      </form>
    </div>
  </div>
</div>


<script>
  document.addEventListener('DOMContentLoaded', function () {
    $('.edit-deal-btn').on('click', function () {
      const button = $(this);

      $('#modalDealId').val(button.data('id'));
      $('#titleInput').val(button.data('title'));
      $('#descriptionTextarea').val(button.data('description'));
      $('#priceInput').val(button.data('price'));
      $('#categorySelect').val(button.data('category'));
      $('#editDealForm').attr('action', button.data('action'));
    });

    $('#editDealForm').on('submit', function (e) {
      e.preventDefault();

      const $form = $(this);
      const $submitBtn = $('#submitDealBtn');
      const $spinner = $('#submitSpinner');

      $submitBtn.prop('disabled', true);
      $spinner.removeClass('d-none');

      $.ajax({
        url: $form.attr('action'),
        method: 'POST',
        data: $form.serialize(),
        success: function (response) {
          success(response.message || 'تم التحديث بنجاح');
          $('#editDealModal').modal('hide');
          setTimeout(() => location.reload(), 1500);
        },
        error: function (xhr) {
          let message = 'حدث خطأ أثناء الحفظ';
          if (xhr.responseJSON && xhr.responseJSON.errors) {
            const errors = xhr.responseJSON.errors;
            message = '<ul>';
            for (const key in errors) {
              message += '<li>' + errors[key][0] + '</li>';
            }
            message += '</ul>';
          } else if (xhr.responseJSON?.message) {
            message = xhr.responseJSON.message;
          }
          error(message);
        },
        complete: function () {
          $submitBtn.prop('disabled', false);
          $spinner.addClass('d-none');
        }
      });
    });
  });
</script>
<?php /**PATH /home/zeinplat/license.zeinplatform.com/resources/views/instructor/deals/edit.blade.php ENDPATH**/ ?>