<?php

use App\Http\Controllers\CommonController;
use App\Http\Controllers\InstallController;
use App\Http\Controllers\ModalController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\frontend\HomeController;
use App\Http\Controllers\Admin\AdminOrderController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\Admin\WalletAdminController;
use App\Http\Controllers\Admin\DisputeController;
use App\Http\Controllers\Api\JobController;
use App\Http\Controllers\Api\DealsMessagesController;
use App\Http\Controllers\ConversationController;
use App\Http\Controllers\ReportController;


//Cache clear route
Route::get('/clear-cache', function () {
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');
    Cache::flush();

    return 'Application cache cleared';
});

Route::get('home/switch/{id}', [HomeController::class, 'homepage_switcher'])->name('home.switch');

//Redirect route
Route::get('/dashboard', function () {
    if (auth()->user()->role == 'admin') {
        return redirect(route('admin.dashboard'));
    }elseif(auth()->user()->role == 'student'){
        return redirect(route('my.courses'));
    } else {
        return redirect(route('home'));
    }
})->middleware(['auth', 'verified'])->name('dashboard');

//Common modal route
Route::get('modal/{view_path}', [ModalController::class, 'common_view_function'])->name('modal');
Route::any('get-video-details/{url?}', [CommonController::class, 'get_video_details'])->name('get.video.details');
Route::get('view/{path}', [CommonController::class, 'rendered_view'])->name('view');
Route::prefix('admin')->group(function () {
    Route::get('/orders', [AdminOrderController::class, 'index'])->name('admin.orders.index');
});
Route::put('/admin/orders/{id}/status', [AdminOrderController::class, 'updateStatus'])->name('admin.orders.updateStatus');
Route::delete('/admin/orders/{id}', [AdminOrderController::class, 'destroy'])->name('admin.orders.destroy');
Route::get('closed_back_to_mobile_ber', function () {
    session()->forget('app_url');
    return redirect()->back();
})->name('closed_back_to_mobile_ber');

Route::middleware(['auth'])->group(function () {
    // عرض المحفظة
    Route::get('/instructor/wallet', [WalletController::class, 'index'])->name('instructor.wallet');
    
    // عمليات المحفظة
    Route::post('/instructor/wallet/send', [WalletController::class, 'sendMoney'])->name('wallet.send');
    Route::post('/instructor/wallet/withdraw', [WalletController::class, 'withdrawMoney'])->name('wallet.withdraw');
    
    // تأكيد/إلغاء المعاملات
    Route::post('/instructor/wallet/transaction/{id}/confirm', [WalletController::class, 'confirmTransaction'])
         ->name('wallet.transaction.confirm');
    Route::post('/instructor/wallet/transaction/{id}/cancel', [WalletController::class, 'cancelTransaction'])
         ->name('wallet.transaction.cancel');
});

Route::middleware(['auth'])->group(function () {
    Route::get('instructor/deals', [OrderController::class, 'index'])->name('instructor.deals.index');
    Route::get('instructor/my-deals', [OrderController::class, 'myDeals'])->name('instructor.deals.my_deals');
    Route::get('instructor/deals/{id}', [OrderController::class, 'show'])->name('instructor.deals.show');
Route::get('/instructor/deals/uppdate', [OrderController::class, 'uppdate'])->name('instructor.deals.uppdate');

});

Route::get('/reports/check-conversation-status/{conversationId}', [ReportController::class, 'checkConversationStatus'])
    ->name('reports.check-conversation-status');

Route::post('/reports/store', [\App\Http\Controllers\ReportController::class, 'store'])
    ->name('reports.store');

// طرق المشرفين
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    // لوحة تحكم المحفظة
    Route::prefix('wallet')->name('wallet.')->group(function () {
        Route::get('/dashboard', [WalletAdminController::class, 'dashboard'])->name('dashboard');
        
        // المعاملات
        Route::get('/transactions', [WalletAdminController::class, 'transactions'])->name('transactions');
        Route::get('/transactions/{id}', [WalletAdminController::class, 'showTransaction'])->name('transactions.show');
        
        // إضافة رصيد
        Route::get('/add-balance', [WalletAdminController::class, 'showAddBalanceForm'])->name('add-balance.show');
        Route::post('/add-balance', [WalletAdminController::class, 'addBalance'])->name('add-balance');
        
        // طلبات السحب
        Route::get('/withdrawal-requests', [WalletAdminController::class, 'withdrawalRequests'])->name('withdrawal-requests');
        Route::get('/withdrawal-requests/{id}', [WalletAdminController::class, 'showWithdrawalRequest'])->name('withdrawal-requests.show');
        Route::post('/withdrawal-requests/{id}/approve', [WalletAdminController::class, 'approveWithdrawal'])->name('withdrawal-requests.approve');
        Route::post('/withdrawal-requests/{id}/reject', [WalletAdminController::class, 'rejectWithdrawal'])->name('withdrawal-requests.reject');
    });
    
    // قسم النزاعات
    Route::prefix('disputes')->name('disputes.')->group(function () {
        Route::get('/', [DisputeController::class, 'index'])->name('index');
        Route::post('/', [DisputeController::class, 'store'])->name('store');
        Route::get('/{id}', [DisputeController::class, 'show'])->name('show');
        Route::put('/{id}', [DisputeController::class, 'update'])->name('update');
 Route::get('/stats', [DisputeController::class, 'stats'])->name('stats');

    });

    // إدارة الوظائف
    Route::get('/jobs', [JobController::class, 'index'])->name('jobs.index');
    Route::get('/jobs/create', [JobController::class, 'create'])->name('jobs.create');
    Route::post('/jobs/store', [JobController::class, 'store'])->name('jobs.store');
    Route::get('/jobs/{id}/edit', [JobController::class, 'edit'])->name('jobs.edit');
    Route::post('/jobs/{id}/update', [JobController::class, 'update'])->name('jobs.update');
    Route::delete('/jobs/{id}', [JobController::class, 'destroy'])->name('jobs.destroy');
    Route::get('/jobs/{id}/applications', [JobController::class, 'showApplications'])->name('jobs.applications');
    
    // إدارة اشتراكات الوظائف
    Route::prefix('jobs/subscriptions')->name('jobs.subscriptions.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\JobSubscriptionController::class, 'index'])->name('index');
        Route::get('/create', [\App\Http\Controllers\Admin\JobSubscriptionController::class, 'create'])->name('create');
        Route::post('/store', [\App\Http\Controllers\Admin\JobSubscriptionController::class, 'store'])->name('store');
        Route::get('/search-users', [\App\Http\Controllers\Admin\JobSubscriptionController::class, 'searchUsers'])->name('search-users');
        Route::get('/{id}', [\App\Http\Controllers\Admin\JobSubscriptionController::class, 'show'])->name('show');
        Route::delete('/{id}', [\App\Http\Controllers\Admin\JobSubscriptionController::class, 'destroy'])->name('destroy');
        Route::get('/export', [\App\Http\Controllers\Admin\JobSubscriptionController::class, 'export'])->name('export');
    });
});

Route::prefix('jobs/subscriptions')->name('jobs.subscriptions.')->group(function () {
    Route::get('/search-users', [\App\Http\Controllers\Admin\JobSubscriptionController::class, 'searchUsers'])->name('search-users');
});


// مسارات الصفقات والمحادثات
Route::middleware(['auth'])->prefix('instructor/deals')->name('instructor.deals.')->group(function () {
    Route::get('/', [OrderController::class, 'index'])->name('index');  
    Route::get('/create', [OrderController::class, 'create'])->name('create');
    Route::post('/store', [OrderController::class, 'store'])->name('store');
    Route::get('/{id}/edit', [OrderController::class, 'edit'])->name('edit');
    Route::put('/{id}', [OrderController::class, 'update'])->name('update');
});

Route::middleware(['auth'])->group(function () {
    Route::delete('/instructor/my-deals/{id}', [OrderController::class, 'destroy'])->name('deals.destroy');
});

// مسارات نظام المراسلة المحدث
Route::middleware(['auth'])->prefix('instructor')->name('instructor.')->group(function () {
    // المحادثات
    Route::prefix('conversations')->name('conversations.')->group(function () {
        Route::get('/', [DealsMessagesController::class, 'index'])->name('index');
        Route::get('/{thread_id}', [DealsMessagesController::class, 'show'])->name('show');
        Route::post('/start', [DealsMessagesController::class, 'startConversation'])->name('start');
        Route::post('/send-message', [DealsMessagesController::class, 'sendMessage'])->name('send-message');
        Route::get('/open/{receiver_id}', [DealsMessagesController::class, 'openOrCreateConversation'])->name('open');
    });
});

// مسارات API للمراسلة (للاستخدام مع JavaScript)
Route::middleware(['auth'])->prefix('api/conversations')->name('api.conversations.')->group(function () {
    Route::get('/{thread_id}/messages', [DealsMessagesController::class, 'getMessages'])->name('messages');
    Route::post('/{thread_id}/send', [DealsMessagesController::class, 'sendMessage'])->name('send');
    Route::post('/{thread_id}/mark-read', [DealsMessagesController::class, 'markAsRead'])->name('mark-read');
    Route::get('/unread-count', [DealsMessagesController::class, 'getUnreadCount'])->name('unread-count');
});

// مسارات نظام المحادثات البديل (للتوافق مع النظام السابق إذا لزم الأمر)
Route::middleware(["auth"])->group(function () {
    // Display a listing of the user's conversations
    Route::get("/conversations", [ConversationController::class, "index"])->name("conversations.index");

    // Display the specified conversation
    Route::get("/conversations/{conversation}", [ConversationController::class, "show"])->name("conversations.show");

    // Start a new conversation with a specific user
    Route::post("/conversations/start", [ConversationController::class, "startConversation"])->name("conversations.start");
});

//Installation routes
Route::controller(InstallController::class)->group(function () {
    Route::get('/install_ended', 'index');
    Route::get('install/step0', 'step0')->name('step0');
    Route::get('install/step1', 'step1')->name('step1');
    Route::get('install/step2', 'step2')->name('step2');
    Route::any('install/step3', 'step3')->name('step3');
    Route::get('install/step4', 'step4')->name('step4');
    Route::get('install/step4/{confirm_import}', 'confirmImport')->name('step4.confirm_import');
    Route::get('install/install', 'confirmInstall')->name('confirm_install');
    Route::post('install/validate', 'validatePurchaseCode')->name('install.validate');
    Route::any('install/finalizing_setup', 'finalizingSetup')->name('finalizing_setup');
    Route::get('install/success', 'success')->name('success');
});
//Installation routes


Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    
    // صفحة عرض جميع الإبلاغات
    Route::get('/reports', [ReportController::class, 'index'])->name('reports.index');
    
    // صفحة عرض تفاصيل إبلاغ واحد
    Route::get('/reports/{id}', [ReportController::class, 'show'])->name('reports.show');
    
    // تحديث حالة الإبلاغ
    Route::patch('/reports/{id}/status', [ReportController::class, 'updateStatus'])->name('reports.update-status');
    
    // إغلاق المحادثة
    Route::post('/reports/{id}/close-conversation', [ReportController::class, 'closeConversation'])->name('reports.close-conversation');
    
});

// Route إضافي للإحصائيات في لوحة التحكم الرئيسية
Route::middleware(['auth', 'admin'])->group(function () {
    
    // API للحصول على إحصائيات الإبلاغات للوحة التحكم
    Route::get('/admin/api/reports/stats', [ReportController::class, 'getStatistics'])->name('admin.reports.stats');
    
});



// Ban Management Routes
Route::middleware(["auth", "admin"])->prefix("admin")->name("admin.")->group(function () {
    Route::prefix("ban-management")->name("ban_management.")->group(function () {
        Route::get("/", [App\Http\Controllers\Admin\BanManagementController::class, "index"])->name("index");
        Route::get("/create", [App\Http\Controllers\Admin\BanManagementController::class, "create"])->name("create");
        Route::post("/store", [App\Http\Controllers\Admin\BanManagementController::class, "store"])->name("store");
        Route::put("/{id}/unban", [App\Http\Controllers\Admin\BanManagementController::class, "unban"])->name("unban");
                Route::put('/reban/{user}', [App\Http\Controllers\Admin\BanManagementController::class, "reban"])->name("reban");
Route::get('/check-ban-status/{user_id}', [App\Http\Controllers\Admin\BanManagementController::class, 'checkBanStatus'])->name('checkBanStatus');
        Route::get("/violations", [App\Http\Controllers\Admin\BanManagementController::class, "showViolations"])->name("violations");
    });
});


