@extends('layouts.instructor')
@push('title', get_phrase('المحفظه'))

@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="container">
    <div class="ol-card radius-8px mb-4">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-wallet me-2"></i>  المحفظة المالية
                </h4>
            </div>
        </div>
    </div>

    <div class="ol-card radius-8px mb-4">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-key me-2"></i> معرف المحفظة
                </h4>
            </div>
            <div class="wallet-info text-center mb-4 mt-4">
                <p><strong id="walletId">{{ $user->wallet_id }}</strong>
                    <i class="fi-rr-copy" style="cursor: pointer;" onclick="copyWalletId()"></i>
                </p>
            </div>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-md-4">
            <div class="ol-card radius-8px h-100">
                <div class="ol-card-body text-center my-3 py-12px px-20px">
                    <h4 class="title fs-16px">
                        <i class="fi-rr-wallet me-2"></i> الرصيد الكلي
                    </h4>
                    <p class="mt-3 mb-0"><strong>ريال {{ number_format($totalBalance, 2) }}</strong></p>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="ol-card radius-8px h-100">
                <div class="ol-card-body text-center my-3 py-12px px-20px">
                    <h4 class="title fs-16px">
                        <i class="fi-rr-check me-2"></i> الرصيد المتاح
                    </h4>
                    <p class="mt-3 mb-0"><strong>ريال {{ number_format($availableBalance, 2) }}</strong></p>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="ol-card radius-8px h-100">
                <div class="ol-card-body text-center my-3 py-12px px-20px">
                    <h4 class="title fs-16px">
                        <i class="fi-rr-lock me-2"></i> الرصيد المجمد
                    </h4>
                    <p class="mt-3 mb-0"><strong>ريال {{ number_format($frozenBalance, 2) }}</strong></p>
                </div>
            </div>
        </div>
    </div>

    <!-- أزرار العمليات -->
    <div class="mb-4">
        <div class="row g-3">
            <div class="col-md-6">
                <button class="btn btn-gradient-success w-100 btn-lg shadow-sm" 
                        onclick="checkBalance('send')" 
                        data-bs-toggle="modal" 
                        data-bs-target="#sendMoneyModal">
                    <i class="fas fa-paper-plane me-2"></i>
                    إرسال أموال
                    <small class="d-block mt-1 opacity-75">تحويل فوري للمحافظ الأخرى</small>
                </button>
            </div>
            <div class="col-md-6">
                <button class="btn btn-gradient-primary w-100 btn-lg shadow-sm" 
                        onclick="checkBalance('withdraw')" 
                        data-bs-toggle="modal" 
                        data-bs-target="#withdrawModal">
                    <i class="fas fa-money-bill-wave me-2"></i>
                    طلب سحب
                    <small class="d-block mt-1 opacity-75">سحب الأموال إلى حسابك البنكي</small>
                </button>
            </div>
        </div>
    </div>

    <!-- التبويبات -->
    <ul class="nav nav-tabs mb-3" id="walletTabs" role="tablist">
        <li class="nav-item">
            <button class="nav-link active" id="transactions-tab" data-bs-toggle="tab" data-bs-target="#transactions" type="button">المعاملات</button>
        </li>
        <li class="nav-item">
            <button class="nav-link" id="withdrawals-tab" data-bs-toggle="tab" data-bs-target="#withdrawals" type="button">طلبات السحب</button>
        </li>
    </ul>

    <div class="tab-content" id="walletTabsContent">
        <div class="tab-pane fade show active" id="transactions">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>المرسل</th>
                        <th>المستلم</th>
                        <th>المبلغ</th>
                        <th>النوع</th>
                        <th>الحالة</th>
                        <th>ملاحظات</th>
                        <th>التاريخ</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($transactions as $t)
                    <tr>
                        <td>{{ optional($t->sender)->name ?? '---' }}</td>
                        <td>{{ optional($t->receiver)->name ?? '---' }}</td>
                        <td>{{ number_format($t->amount, 2) }}</td>
                        <td>
                            @if($t->type == 'deposit')
                                <span class="badge bg-info">إيداع</span>
                            @elseif($t->type == 'withdraw')
                                <span class="badge bg-warning">سحب</span>
                            @else
                                <span class="badge bg-primary">تحويل</span>
                            @endif
                        </td>
                        <td>
                            @if($t->status == 'completed')
                                <span class="badge bg-success">مكتمل</span>
                            @elseif($t->status == 'pending')
                                <span class="badge bg-warning">معلق</span>
                            @else
                                <span class="badge bg-danger">ملغى</span>
                            @endif
                        </td>
                        <td>{{ $t->notes }}</td>
                        <td>{{ $t->created_at->format('Y-m-d H:i') }}</td>
                        <td>
                            @if($t->status == 'pending' && $t->sender_id == auth()->user()->wallet_id && $t->type == 'transfer')
                                <div class="btn-group">
                                    <form action="{{ route('wallet.transaction.confirm', $t->id) }}" method="POST">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-success" title="تأكيد التحويل">
                                            <i class="fas fa-check"></i>
                                        </button>
                                    </form>
                                    <form action="{{ route('wallet.transaction.cancel', $t->id) }}" method="POST">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-danger" title="إلغاء التحويل">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </form>
                                </div>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8">لا توجد معاملات.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="tab-pane fade" id="withdrawals">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>المبلغ</th>
                        <th>طريقة السحب</th>
                        <th>الحالة</th>
                        <th>ملاحظات</th>
                        <th>التاريخ</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($withdrawals as $w)
                    <tr>
                        <td>{{ number_format($w->amount, 2) }}</td>
                        <td>{{ $w->methodName() }}</td>
                        <td>
                            @if($w->status == 'pending')
                                <span class="badge bg-warning">قيد الانتظار</span>
                            @elseif($w->status == 'approved')
                                <span class="badge bg-success">تم الموافقة</span>
                            @else
                                <span class="badge bg-danger">مرفوض</span>
                            @endif
                        </td>
                        <td>{{ $w->withdrawal_requests }}</td>
                        <td>{{ $w->created_at->format('Y-m-d H:i') }}</td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5">لا توجد طلبات سحب.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal إرسال الأموال -->
<div class="modal fade" id="sendMoneyModal" tabindex="-1">
    <div class="modal-dialog">
        <form class="modal-content" id="sendMoneyForm">
            @csrf
            <div class="modal-header">
                <h5 class="modal-title">إرسال أموال</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="wallet_id" class="form-label">معرّف المحفظة</label>
                    <input type="text" class="form-control" name="wallet_id" required>
                </div>
                <div class="mb-3">
                    <label for="amount" class="form-label">المبلغ</label>
                    <input type="number" step="0.01" min="0.01" max="{{ auth()->user()->available_balance }}" class="form-control" name="amount" required>
                </div>
                <div class="alert alert-success d-none" id="sendSuccess"></div>
                <div class="alert alert-danger d-none" id="sendError"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                <button type="submit" class="btn btn-primary">إرسال</button>
            </div>
        </form>
    </div>
</div>

<!-- Modal طلب سحب -->
<div class="modal fade" id="withdrawModal" tabindex="-1">
    <div class="modal-dialog">
        <form class="modal-content" id="withdrawForm">
            @csrf
            <div class="modal-header">
                <h5 class="modal-title">طلب سحب</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="amount" class="form-label">المبلغ</label>
                    <input type="number" step="0.01" min="0.01" max="{{ auth()->user()->available_balance }}" class="form-control" name="amount" required>
                </div>
                
                <div class="mb-3">
                    <label for="withdrawal_method" class="form-label">طريقة السحب</label>
                    <select class="form-select" name="withdrawal_method" required>
                        <option value="">اختر طريقة السحب</option>
                        <option value="bank_transfer">حوالة بنكية</option>
                        <option value="electronic_wallet">محفظة إلكترونية</option>
                    </select>
                </div>
                
                <div class="mb-3">
                    <label for="withdrawal_details" class="form-label">تفاصيل السحب</label>
                    <textarea class="form-control" name="withdrawal_details" rows="4" required
                        placeholder="أدخل تفاصيل الحساب البنكي أو المحفظة الإلكترونية"></textarea>
                </div>
                
                <div class="alert alert-success d-none" id="withdrawSuccess"></div>
                <div class="alert alert-danger d-none" id="withdrawError"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إغلاق</button>
                <button type="submit" class="btn btn-primary">طلب السحب</button>
            </div>
        </form>
    </div>
</div>
@endsection

@push('js')
<script>
    // نسخ معرف المحفظة
    function copyWalletId() {
        const walletId = document.getElementById('walletId').innerText;
        navigator.clipboard.writeText(walletId).then(() => {
            alert('تم نسخ معرف المحفظة: ' + walletId);
        });
    }

    // إرسال الأموال
    document.getElementById('sendMoneyForm').addEventListener('submit', function(e) {
        e.preventDefault();
        const form = e.target;
        const submitBtn = form.querySelector('button[type="submit"]');
        submitBtn.disabled = true;
        
        // إضافة معالجة الأخطاء
        const formData = new FormData(form);
        const amount = formData.get('amount');
        const wallet_id = formData.get('wallet_id');
        
        if (!amount || amount <= 0) {
            document.getElementById('sendError').classList.remove('d-none');
            document.getElementById('sendError').innerHTML = 'الرجاء إدخال مبلغ صحيح';
            submitBtn.disabled = false;
            return;
        }

        if (!wallet_id) {
            document.getElementById('sendError').classList.remove('d-none');
            document.getElementById('sendError').innerHTML = 'الرجاء إدخال معرف المحفظة';
            submitBtn.disabled = false;
            return;
        }
        
        fetch("{{ route('wallet.send') }}", {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json',
            },
            body: formData
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('حدث خطأ في الاتصال');
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                document.getElementById('sendError').classList.add('d-none');
                document.getElementById('sendSuccess').classList.remove('d-none');
                document.getElementById('sendSuccess').innerHTML = data.success;
                form.reset();
                setTimeout(() => window.location.reload(), 1500);
            } else {
                document.getElementById('sendSuccess').classList.add('d-none');
                document.getElementById('sendError').classList.remove('d-none');
                document.getElementById('sendError').innerHTML = data.error || 'حدث خطأ غير متوقع';
            }
        })
        .catch(error => {
            document.getElementById('sendSuccess').classList.add('d-none');
            document.getElementById('sendError').classList.remove('d-none');
            document.getElementById('sendError').innerHTML = error.message;
        })
        .finally(() => {
            submitBtn.disabled = false;
        });
    });

    // تحديث كود طلب السحب بنفس الطريقة
    document.getElementById('withdrawForm').addEventListener('submit', function(e) {
        e.preventDefault();
        const form = e.target;
        const submitBtn = form.querySelector('button[type="submit"]');
        submitBtn.disabled = true;
        
        const formData = new FormData(form);
        const amount = formData.get('amount');
        const method = formData.get('withdrawal_method');
        const details = formData.get('withdrawal_details');
        
        if (!amount || amount <= 0) {
            document.getElementById('withdrawError').classList.remove('d-none');
            document.getElementById('withdrawError').innerHTML = 'الرجاء إدخال مبلغ صحيح';
            submitBtn.disabled = false;
            return;
        }

        if (!method) {
            document.getElementById('withdrawError').classList.remove('d-none');
            document.getElementById('withdrawError').innerHTML = 'الرجاء اختيار طريقة السحب';
            submitBtn.disabled = false;
            return;
        }

        if (!details) {
            document.getElementById('withdrawError').classList.remove('d-none');
            document.getElementById('withdrawError').innerHTML = 'الرجاء إدخال تفاصيل السحب';
            submitBtn.disabled = false;
            return;
        }
        
        fetch("{{ route('wallet.withdraw') }}", {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Accept': 'application/json',
            },
            body: formData
        })
        .then(response => {
            if (!response.ok) {
                throw new Error('حدث خطأ في الاتصال');
            }
            return response.json();
        })
        .then(data => {
            if (data.success) {
                document.getElementById('withdrawError').classList.add('d-none');
                document.getElementById('withdrawSuccess').classList.remove('d-none');
                document.getElementById('withdrawSuccess').innerHTML = data.success;
                form.reset();
                setTimeout(() => window.location.reload(), 1500);
            } else {
                document.getElementById('withdrawSuccess').classList.add('d-none');
                document.getElementById('withdrawError').classList.remove('d-none');
                document.getElementById('withdrawError').innerHTML = data.error || 'حدث خطأ غير متوقع';
            }
        })
        .catch(error => {
            document.getElementById('withdrawSuccess').classList.add('d-none');
            document.getElementById('withdrawError').classList.remove('d-none');
            document.getElementById('withdrawError').innerHTML = error.message;
        })
        .finally(() => {
            submitBtn.disabled = false;
        });
    });

function checkBalance(type) {
    const availableBalance = {{ $availableBalance }};
    if (availableBalance <= 0) {
        event.preventDefault();
        alert('عذراً، رصيدك غير كافي لإجراء هذه العملية');
        return false;
    }
}

// التحقق من صحة المدخلات قبل الإرسال
function validateTransaction(formId) {
    const form = document.getElementById(formId);
    const amount = form.querySelector('input[name="amount"]').value;
    
    if (!amount || isNaN(amount) || amount <= 0) {
        alert('الرجاء إدخال مبلغ صحيح');
        return false;
    }
    
    if (amount > {{ $availableBalance }}) {
        alert('المبلغ المطلوب أكبر من رصيدك المتاح');
        return false;
    }
    
    return true;
}
</script>
@endpush

<style>
/* تصميم الأزرار المحسن */
.btn-gradient-success {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
    border: none;
    color: white;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.btn-gradient-success:hover {
    background: linear-gradient(135deg, #218838 0%, #1ea085 100%);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(40, 167, 69, 0.3);
    color: white;
}

.btn-gradient-primary {
    background: linear-gradient(135deg, #007bff 0%, #6610f2 100%);
    border: none;
    color: white;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.btn-gradient-primary:hover {
    background: linear-gradient(135deg, #0056b3 0%, #520dc2 100%);
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 123, 255, 0.3);
    color: white;
}

.btn-gradient-success::before,
.btn-gradient-primary::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
    transition: left 0.5s;
}

.btn-gradient-success:hover::before,
.btn-gradient-primary:hover::before {
    left: 100%;
}

.btn-lg {
    padding: 1rem 1.5rem;
    font-size: 1.1rem;
    border-radius: 12px;
}

.btn-lg small {
    font-size: 0.85rem;
    font-weight: 400;
}

/* تحسين بطاقات الرصيد */
.ol-card {
    border-radius: 15px;
    border: none;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    transition: all 0.3s ease;
}

.ol-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 30px rgba(0,0,0,0.12);
}

/* تحسين التبويبات */
.nav-tabs .nav-link {
    border-radius: 10px 10px 0 0;
    border: none;
    background: #f8f9fa;
    color: #6c757d;
    margin-right: 5px;
    transition: all 0.3s ease;
}

.nav-tabs .nav-link.active {
    background: linear-gradient(135deg, #007bff 0%, #6610f2 100%);
    color: white;
    border: none;
}

.nav-tabs .nav-link:hover {
    background: #e9ecef;
    border: none;
}

/* تحسين الجداول */
.table {
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 2px 15px rgba(0,0,0,0.05);
}

.table thead th {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border: none;
    font-weight: 600;
    color: #495057;
}

.table tbody tr:hover {
    background-color: #f8f9fa;
    transform: scale(1.01);
    transition: all 0.2s ease;
}

/* تحسين النماذج المنبثقة */
.modal-content {
    border-radius: 15px;
    border: none;
    box-shadow: 0 10px 40px rgba(0,0,0,0.15);
}

.modal-header {
    background: linear-gradient(135deg, #007bff 0%, #6610f2 100%);
    color: white;
    border-radius: 15px 15px 0 0;
    border: none;
}

.modal-footer {
    border: none;
    padding: 1.5rem;
}

.form-control {
    border-radius: 8px;
    border: 2px solid #e9ecef;
    transition: all 0.3s ease;
}

.form-control:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

/* تحسين الشارات */
.badge {
    padding: 0.5rem 0.8rem;
    border-radius: 20px;
    font-weight: 500;
}

/* تأثيرات الحركة */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.ol-card {
    animation: fadeInUp 0.6s ease-out;
}

.ol-card:nth-child(2) {
    animation-delay: 0.1s;
}

.ol-card:nth-child(3) {
    animation-delay: 0.2s;
}

.ol-card:nth-child(4) {
    animation-delay: 0.3s;
}
</style>

