@extends('layouts.instructor')
@push('title', get_phrase('سجل المعاملات'))

@section('content')
<div class="container-fluid">
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-time-past me-2"></i>
                    {{ get_phrase('سجل المعاملات') }}
                </h4>
                <a href="{{ route('wallet.index') }}" class="btn btn-sm btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i> {{ get_phrase('رجوع') }}
                </a>
            </div>
        </div>
    </div>

    <div class="card shadow mb-4 mt-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">{{ get_phrase('جميع المعاملات') }}</h6>
            <form action="{{ route('instructor.wallet.transactions') }}" method="GET" class="form-inline">
                <div class="input-group">
                    <input type="text" name="search" class="form-control bg-light border-0 small" placeholder="بحث..." 
                           value="{{ request('search') }}" aria-label="Search">
                    <div class="input-group-append">
                        <button class="btn btn-primary" type="submit">
                            <i class="fas fa-search fa-sm"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>{{ get_phrase('رقم العملية') }}</th>
                            <th>{{ get_phrase('المرسل') }}</th>
                            <th>{{ get_phrase('المستلم') }}</th>
                            <th>{{ get_phrase('المبلغ') }}</th>
                            <th>{{ get_phrase('النوع') }}</th>
                            <th>{{ get_phrase('الحالة') }}</th>
                            <th>{{ get_phrase('التاريخ') }}</th>
                            <th>{{ get_phrase('الإجراءات') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($transactions as $transaction)
                        <tr>
                            <td>{{ $transaction->transaction_id }}</td>
                            <td>{{ $transaction->sender->name ?? 'غير متاح' }}</td>
                            <td>{{ $transaction->receiver->name ?? 'غير متاح' }}</td>
                            <td>{{ number_format($transaction->amount, 2) }} ر.س</td>
                            <td>
                                @if($transaction->type == 'deposit')
                                    <span class="badge bg-info">إيداع</span>
                                @elseif($transaction->type == 'withdrawal')
                                    <span class="badge bg-warning">سحب</span>
                                @else
                                    <span class="badge bg-primary">تحويل</span>
                                @endif
                            </td>
                            <td>
                                @if($transaction->status == 'completed')
                                    <span class="badge bg-success">مكتمل</span>
                                @elseif($transaction->status == 'pending')
                                    <span class="badge bg-warning">معلق</span>
                                @else
                                    <span class="badge bg-danger">ملغى</span>
                                @endif
                            </td>
                            <td>{{ $transaction->created_at->format('Y-m-d H:i') }}</td>
                            <td>
                                @if($transaction->status == 'pending' && $transaction->sender_id == auth()->id())
                                    <div class="btn-group">
                                        <form action="{{ route('wallet.transaction.confirm', $transaction->transaction_id) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-success" title="تأكيد">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                        <form action="{{ route('wallet.transaction.cancel', $transaction->transaction_id) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-sm btn-danger" title="إلغاء">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </form>
                                    </div>
                                @else
                                    <a href="#" class="btn btn-sm btn-info" title="التفاصيل">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                @endif
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="8" class="text-center">{{ get_phrase('لا توجد معاملات') }}</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</div>
@endsection