@extends('layouts.instructor')

@push('title', get_phrase('عرض المحادثة'))

@section('content')
<div class="container mt-5">
    <div class="ol-card radius-8px mb-4">
        <div class="ol-card-body my-3 py-12px px-20px">
            <h4 class="title fs-16px"><i class="fi-rr-envelope me-2"></i> عرض المحادثة رقم {{ $thread_id }}</h4>
        </div>
    </div>

    <div class="mb-4">
        @foreach($messages as $message)
            <div class="mb-3 p-3 border rounded @if($message->sender_id == auth()->id()) bg-light @endif">
                <strong>{{ $message->sender->name }}:</strong>
                <p class="mb-0">{{ $message->message }}</p>
            </div>
        @endforeach
    </div>

    <form action="{{ route('send.message') }}" method="POST">
    @csrf
    <input type="hidden" name="thread_id" value="{{ $thread_id }}">
    <input type="hidden" name="receiver_id" value="{{ $messages->first()->sender_id == auth()->id() ? $messages->first()->receiver_id : $messages->first()->sender_id }}">
    <div class="mb-3">
        <textarea name="message" class="form-control" rows="3" placeholder="اكتب رسالتك هنا..." required></textarea>
    </div>
    <button type="submit" class="btn btn-primary">إرسال</button>
</form>
</div>
@endsection

