@extends('layouts.instructor')

@push('title', get_phrase('صفقات'))

@section('content')
<div class="container mt-5">
    <!-- عنوان الصفحة -->
    <div class="ol-card radius-8px mb-4">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-briefcase me-2"></i> الإعلانات
                </h4>
            </div>
        </div>
    </div>

    <!-- تصفية الفئات -->
   <div class="row mb-4">
    <div class="col-12">
        <ul class="list-inline text-center">
            <li class="list-inline-item">
                <a href="{{ route('instructor.deals.index', ['category' => 'all']) }}" class="btn btn-outline-primary">الكل</a>
            </li>
            @foreach (\App\Models\Category::where('parent_id', 0)->orderBy('title')->get() as $category)
                <li class="list-inline-item">
                    <a href="{{ route('instructor.deals.index', ['category' => $category->title]) }}" class="btn btn-outline-primary">{{ $category->title }}</a>
                </li>
                @foreach ($category->childs as $sub_category)
                    <li class="list-inline-item">
                        <a href="{{ route('instructor.deals.index', ['category' => $sub_category->title]) }}" class="btn btn-outline-secondary">-- {{ $sub_category->title }}</a>
                    </li>
                @endforeach
            @endforeach
        </ul>
    </div>
</div>

    <!-- بطاقات الصفقات -->
    <div class="row g-4">
        @forelse ($orders as $order)
            @if ($order->status == 'موافق')
                <div class="col-md-4">
                    <div class="card shadow-sm border-0 rounded-4 h-100">
                        <div class="badge bg-primary position-absolute top-0 end-0 m-2 category-badge">
                            {{ $order->category }}
                        </div>
                        <div class="card-body d-flex flex-column">
                            <h5 class="card-title text-primary fw-bold">{{ $order->title }}</h5>

                            <!-- وصف مختصر وموسع -->
                            <p class="card-text mb-1">
                                <strong>الوصف:</strong>
                                <div class="description-container">
                                    <span class="short-desc description-text">{{ \Illuminate\Support\Str::limit($order->description, 60) }}</span>
                                    <span class="full-desc description-text d-none">{{ $order->description }}</span>
                                    @if (strlen($order->description) > 60)
                                        <button class="toggle-description btn btn-link p-0">عرض المزيد</button>
                                    @endif
                                </div>
                            </p>

                            <!-- السعر باللون الأخضر -->
                            <p class="card-text mb-3 price-text">
                                <strong>السعر:</strong> {{ $order->price }} ريال
                            </p>

                            <!-- زر إرسال رسالة -->
                            <a href="{{ route('instructor.conversations.open', ['receiver_id' => $order->user_id]) }}" class="btn btn-outline-info mt-auto">
                                <i class="fi-rr-envelope"></i> إرسال رسالة
                            </a>
                        </div>
                    </div>
                </div>
            @endif
        @empty
            <div class="col-12">
                <p class="text-muted text-center">لا توجد صفقات حالياً.</p>
            </div>
        @endforelse
    </div>
</div>
@endsection

@push('css')
<style>
    .toggle-description {
        font-size: 0.85rem;
        color: #0d6efd;
        background: none;
        border: none;
        cursor: pointer;
    }
    .description-text {
        color: #ACC572; /* رمادي غامق وواضح */
        font-weight: 500;
    }
    .price-text {
        color: #28a745; /* أخضر */
        font-weight: bold;
    }
    .category-badge {
        font-size: 1rem;
        font-weight: bold;
        color: #ffffff;
        background-color: #007bff;
        padding: 8px 16px;
        border-radius: 12px;
    }
    .category-filter {
        font-size: 1rem;
        margin: 0 8px;
        cursor: pointer;
    }
</style>
@endpush

@push('js')
<script>
document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.toggle-description').forEach(button => {
        button.addEventListener('click', function () {
            const container = this.closest('.description-container');
            const shortDesc = container.querySelector('.short-desc');
            const fullDesc = container.querySelector('.full-desc');

            if (fullDesc.classList.contains('d-none')) {
                shortDesc.classList.add('d-none');
                fullDesc.classList.remove('d-none');
                this.textContent = 'عرض أقل';
            } else {
                shortDesc.classList.remove('d-none');
                fullDesc.classList.add('d-none');
                this.textContent = 'عرض المزيد';
            }
        });
    });
});
</script>
@endpush
