@extends('layouts.instructor')
@push('title', get_phrase('الرسائل'))
@section('content')
    <div class="container mt-5">
        <!-- عنوان الصفحة -->
        <div class="ol-card radius-8px mb-4">
            <div class="ol-card-body my-3 py-12px px-20px">
                <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                    <h4 class="title fs-16px">
                        <i class="fi-rr-briefcase me-2"></i> المحادثات
                    </h4>
                </div>
            </div>
        </div>

        <!-- قائمة المحادثات -->
        <div class="row g-4">
            @forelse ($conversations as $conversation)
                <div class="col-md-4">
                    <div class="card shadow-sm border-0 rounded-4 h-100">
                        <div class="card-body d-flex flex-column">
                            <!-- اسم الطرف الآخر في المحادثة -->
                            <h5 class="card-title text-primary fw-bold">
                                محادثة مع 
                                {{ $conversation->sender_id == auth()->id() ? $conversation->receiver->name : $conversation->sender->name }}
                            </h5>

                            <!-- تفاصيل المحادثة -->
                            <p class="card-text mb-3">
                                <strong>الموضوع:</strong> رقم {{ $conversation->thread_id }}
                            </p>

                            <!-- زر عرض المحادثة -->
                            <a href="{{ route('conversations.show', ['thread_id' => $conversation->thread_id]) }}" class="btn btn-outline-info mt-auto">
                                <i class="fi-rr-envelope"></i> عرض المحادثة
                            </a>
                        </div>
                    </div>
                </div>
            @empty
                <div class="col-12">
                    <p class="text-muted text-center">لا توجد محادثات حالياً.</p>
                </div>
            @endforelse
        </div>
    </div>
@endsection


