@extends('layouts.instructor')
@push('title', get_phrase('المحادثات'))

@section('content')
<div class="container mt-5">
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-comment-dots me-2"></i> {{-- أيقونة محادثات --}}
                    {{ get_phrase('المحادثات') }}
                </h4>
            </div>
        </div>
    </div>


            <!-- Conversations List -->
            @if ($conversations->isEmpty())
                <div class="card border-0 shadow-sm">
                    <div class="card-body text-center py-5">
                        <div class="mb-4">
                            <i class="fas fa-comments fa-3x text-muted"></i>
                        </div>
                        <h5 class="text-muted mb-3">ليس لديك أي محادثات حتى الآن</h5>
                        <p class="text-muted mb-4">ابدأ محادثة جديدة للتواصل مع المستخدمين</p>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#newConversationModal">
                            <i class="fas fa-plus me-2"></i>بدء محادثة جديدة
                        </button>
                    </div>
                </div>
            @else
                <div class="card border-0 shadow-sm">
                    <div class="card-body p-0">
                        <div class="list-group list-group-flush">
                            @foreach ($conversations as $conversation)
                                <a href="{{ route('instructor.conversations.show', $conversation->thread_id) }}" 
                                   class="list-group-item list-group-item-action border-0 py-3 px-4 conversation-item">
                                    <div class="d-flex align-items-center">
                                        <!-- User Avatar -->
                                        <div class="flex-shrink-0 me-3 position-relative">
                                            @if($conversation->other_user && $conversation->other_user->photo)
                                                <img src="{{ asset($conversation->other_user->photo) }}" 
                                                     alt="{{ $conversation->other_user->name }}" 
                                                     class="rounded-circle" 
                                                     width="50" height="50"
                                                     style="object-fit: cover;">
                                            @else
                                                <div class="rounded-circle bg-primary d-flex align-items-center justify-content-center text-white fw-bold" 
                                                     style="width: 50px; height: 50px; font-size: 18px;">
                                                    {{ $conversation->other_user ? strtoupper(substr($conversation->other_user->name, 0, 1)) : '؟' }}
                                                </div>
                                            @endif
                                            
                                            <!-- Unread indicator -->
                                            @if($conversation->has_unread)
                                                <span class="position-absolute top-0 start-100 translate-middle p-1 bg-danger border border-light rounded-circle">
                                                    <span class="visually-hidden">رسائل جديدة</span>
                                                </span>
                                            @endif
                                        </div>

                                        <!-- Conversation Details -->
                                        <div class="flex-grow-1 min-width-0">
                                            <div class="d-flex justify-content-between align-items-start mb-1">
                                                <h6 class="mb-0 fw-semibold {{ $conversation->has_unread ? 'text-dark' : 'text-gray-700' }}">
                                                    {{ $conversation->other_user ? $conversation->other_user->name : 'مستخدم غير معروف' }}
                                                </h6>
                                                @if($conversation->last_message)
                                                    <small class="text-muted">
                                                        {{ $conversation->last_message->created_at->diffForHumans() }}
                                                    </small>
                                                @endif
                                            </div>
                                            
                                            @if($conversation->last_message)
                                                <p class="mb-0 text-truncate {{ $conversation->has_unread ? 'fw-semibold text-dark' : 'text-muted' }}" 
                                                   style="max-width: 300px;">
                                                    @if($conversation->last_message->sender_id == auth()->id())
                                                        <span class="text-primary me-1">أنت:</span>
                                                    @endif
                                                    {{ Str::limit($conversation->last_message->message, 60) }}
                                                </p>
                                            @else
                                                <p class="mb-0 text-muted fst-italic">لا توجد رسائل حتى الآن</p>
                                            @endif
                                        </div>

                                        <!-- Arrow Icon -->
                                        <div class="flex-shrink-0 ms-2">
                                            <i class="fas fa-chevron-left text-muted"></i>
                                        </div>
                                    </div>
                                </a>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- New Conversation Modal -->
<div class="modal fade" id="newConversationModal" tabindex="-1" aria-labelledby="newConversationModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="newConversationModalLabel">بدء محادثة جديدة</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('instructor.conversations.start') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="receiver_id" class="form-label">اختر مستخدمًا للمحادثة:</label>
                        <select name="receiver_id" id="receiver_id" class="form-select" required>
                            <option value="">-- اختر مستخدم --</option>
                            @php
                                $users = App\Models\User::where("id", "!=", auth()->id())
                                    ->orderBy('name')
                                    ->get();
                            @endphp
                            @foreach ($users as $userItem)
                                <option value="{{ $userItem->id }}">
                                    {{ $userItem->name }} ({{ $userItem->email }})
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-paper-plane me-2"></i>بدء المحادثة
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push("styles")
<style>
    .conversation-item {
        transition: all 0.2s ease-in-out;
        border-left: 3px solid transparent !important;
    }
    
    .conversation-item:hover {
        background-color: #f8f9fa !important;
        border-left-color: #0d6efd !important;
        transform: translateX(2px);
    }
    
    .text-gray-700 {
        color: #374151 !important;
    }
    
    .text-gray-800 {
        color: #1f2937 !important;
    }
    
    .min-width-0 {
        min-width: 0;
    }
    
    .card {
        border-radius: 12px;
    }
    
    .btn {
        border-radius: 8px;
    }
    
    .modal-content {
        border-radius: 12px;
        border: none;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
    }
    
    .form-select {
        border-radius: 8px;
        border: 1px solid #e5e7eb;
    }
    
    .form-select:focus {
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
    }
</style>
@endpush

@push("scripts")
<script>
    // Auto-refresh conversations every 30 seconds
    setInterval(function() {
        // Only refresh if we're still on the conversations page
        if (window.location.pathname.includes('/conversations') && !window.location.pathname.includes('/conversations/')) {
            window.location.reload();
        }
    }, 30000);

    // Update unread count in navigation (if you have a badge)
    function updateUnreadCount() {
        fetch('/api/conversations/unread-count', {
            method: 'GET',
            headers: {
                'Accept': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.unread_count !== undefined) {
                const badge = document.getElementById('unread-messages-badge');
                if (badge) {
                    badge.textContent = data.unread_count;
                    badge.style.display = data.unread_count > 0 ? 'inline-block' : 'none';
                }
            }
        })
        .catch(error => console.error('Error fetching unread count:', error));
    }

    // Update unread count on page load and every 10 seconds
    document.addEventListener('DOMContentLoaded', updateUnreadCount);
    setInterval(updateUnreadCount, 10000);
</script>
@endpush

