@extends('layouts.admin')

@section('content')
<div class="container-fluid">
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">تفاصيل طلب السحب #{{ $request->request_id }}</h6>
            <a href="{{ route('admin.wallet.withdrawal-requests') }}" class="btn btn-sm btn-secondary">
                <i class="fas fa-arrow-left"></i> رجوع
            </a>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <th width="30%">رقم الطلب</th>
                                    <td>{{ $request->request_id }}</td>
                                </tr>
                                <tr>
                                    <th>المستخدم</th>
                                    <td>
                                        {{ $request->user->name }}
                                        <small class="text-muted d-block">({{ $request->user->wallet_id }})</small>
                                    </td>
                                </tr>
                                <tr>
                                    <th>الرصيد الحالي</th>
                                    <td>
                                        {{ number_format($request->user->wallet_balance, 2) }} ر.س
                                    </td>
                                </tr>
                                <tr>
                                    <th>المبلغ المطلوب</th>
                                    <td class="font-weight-bold">
                                        {{ number_format($request->amount, 2) }} ر.س
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <th width="30%">طريقة السحب</th>
                                    <td>
                                        @if($request->withdrawal_method == 'bank_transfer')
                                            حوالة بنكية
                                        @else
                                            محفظة إلكترونية
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>الحالة</th>
                                    <td>
    @if($request->status == 'pending')
        <span style="color: orange;">قيد الانتظار</span>
    @elseif($request->status == 'approved')
        <span style="color: green;">تمت الموافقة</span>
    @elseif($request->status == 'rejected')
        <span style="color: red;">مرفوض</span>
    @else
        <span style="color: gray;">غير معروف</span>
    @endif
</td>
                                </tr>
                                <tr>
                                    <th>تاريخ الطلب</th>
                                    <td>{{ $request->created_at->format('Y-m-d H:i:s') }}</td>
                                </tr>
                                <tr>
                                    <th>تاريخ المعالجة</th>
                                    <td>
                                        @if($request->processed_at)
                                            {{ $request->processed_at->format('Y-m-d H:i:s') }}
                                        @else
                                            لم تتم المعالجة بعد
                                        @endif
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="row mt-4">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h6 class="m-0 font-weight-bold text-primary">تفاصيل السحب</h6>
                        </div>
                        <div class="card-body">
    {{ $request->withdrawal_details['details'] ?? 'غير متوفر' }}
</div>
                    </div>
                </div>
            </div>

            @if($request->status == 'pending')
            <div class="mt-4">
                <form action="{{ route('admin.wallet.withdrawal-requests.approve', $request->id) }}" method="POST" class="d-inline">
                    @csrf
                    <div class="form-group">
                        <label for="admin_notes">ملاحظات إدارية</label>
                        <textarea name="admin_notes" id="admin_notes" class="form-control" rows="3"></textarea>
                    </div>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-check"></i> الموافقة على الطلب
                    </button>
                </form>

                <form action="{{ route('admin.wallet.withdrawal-requests.reject', $request->id) }}" method="POST" class="d-inline">
                    @csrf
                    <div class="form-group">
                        <label for="admin_notes_reject">سبب الرفض</label>
                        <textarea name="admin_notes" id="admin_notes_reject" class="form-control" rows="3" required></textarea>
                    </div>
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-times"></i> رفض الطلب
                    </button>
                </form>
            </div>
            @else
            <div class="mt-4">
                <div class="alert alert-info">
                    <h6 class="font-weight-bold">ملاحظات الإدارة:</h6>
                    <p>{{ $request->admin_notes ?? 'لا توجد ملاحظات' }}</p>
                    <small class="text-muted">تمت المعالجة بواسطة: {{ $request->admin->name ?? 'غير معروف' }}</small>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection