@extends('layouts.admin')

@section('content')
<div class="container-fluid">
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">تفاصيل المعاملة #{{ $transaction->transaction_id }}</h6>
            <a href="{{ route('admin.wallet.transactions') }}" class="btn btn-sm btn-secondary">
                <i class="fas fa-arrow-left"></i> رجوع
            </a>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <th width="30%">رقم المعاملة</th>
                                    <td>{{ $transaction->transaction_id }}</td>
                                </tr>
                                <tr>
                                    <th>المرسل</th>
                                    <td>
                                        {{ $transaction->sender->name }}
                                        <small class="text-muted d-block">({{ $transaction->sender->wallet_id }})</small>
                                    </td>
                                </tr>
                                <tr>
                                    <th>المستلم</th>
                                    <td>
                                        {{ $transaction->receiver->name }}
                                        <small class="text-muted d-block">({{ $transaction->receiver->wallet_id }})</small>
                                    </td>
                                </tr>
                                <tr>
                                    <th>المبلغ</th>
                                    <td class="font-weight-bold">
                                        {{ number_format($transaction->amount, 2) }} ر.س
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <th width="30%">الحالة</th>
                                    <td>
    @if($transaction->status == 'completed')
        <span style="color: green;">مكتمل</span>
    @elseif($transaction->status == 'pending')
        <span style="color: orange;">معلق</span>
    @elseif($transaction->status == 'cancelled')
        <span style="color: red;">ملغى</span>
    @else
        <span style="color: gray;">غير معروف</span>
    @endif
</td>
                                </tr>
                                <tr>
                                    <th>تاريخ الإنشاء</th>
                                    <td>{{ $transaction->created_at->format('Y-m-d H:i:s') }}</td>
                                </tr>
                                <tr>
                                    <th>آخر تحديث</th>
                                    <td>{{ $transaction->updated_at->format('Y-m-d H:i:s') }}</td>
                                </tr>
                                <tr>
                                    <th>ملاحظات</th>
                                    <td>{{ $transaction->notes ?? 'لا توجد ملاحظات' }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            @if($transaction->status == 'pending' && auth()->user()->can('admin.wallet.transactions.update'))
            <div class="mt-4">
                <form action="{{ route('admin.wallet.transactions.update', $transaction->id) }}" method="POST" class="d-inline">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="status" value="completed">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-check"></i> تأكيد المعاملة
                    </button>
                </form>

                <form action="{{ route('admin.wallet.transactions.update', $transaction->id) }}" method="POST" class="d-inline">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="status" value="cancelled">
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-times"></i> إلغاء المعاملة
                    </button>
                </form>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection