@extends('layouts.admin')
@push('title', get_phrase('إدارة رصيد المستخدمين'))

@section('content')
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px d-flex align-items-center">
                    <i class="fi-rr-wallet me-2"></i>
                    {{ get_phrase('إدارة رصيد المستخدمين') }}
                </h4>

                <a href="{{ route('admin.wallet.transactions') }}" class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px">
                    <i class="fas fa-arrow-left fa-sm me-1"></i>
                    <span>{{ get_phrase('رجوع') }}</span>
                </a>
            </div>
        </div>
    </div>

    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">

            <form action="{{ route('admin.wallet.add-balance') }}" method="POST">
                @csrf
                <div class="row">
                    <!-- اختيار المستخدم -->
                    <div class="col-md-6 form-group">
                        <label for="user_id" class="mb-2">{{ get_phrase('اختر المستخدم') }}</label>
                        <select class="form-control select2" id="user_id" name="user_id" required>
                            <option value="">{{ get_phrase('-- اختر مستخدم --') }}</option>
                            @foreach(\App\Models\User::all() as $user)
                                <option value="{{ $user->id }}">
                                    {{ $user->name }} ({{ $user->wallet_id }}) - رصيد: {{ number_format($user->wallet_balance, 2) }} ر.س
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- نوع العملية -->
                    <div class="col-md-6 form-group">
                        <label for="transaction_type" class="mb-2">{{ get_phrase('نوع العملية') }}</label>
                        <select class="form-control" id="transaction_type" name="transaction_type" required>
                            <option value="deposit">{{ get_phrase('إيداع') }}</option>
                            <option value="withdraw">{{ get_phrase('سحب') }}</option>
                        </select>
                    </div>

                    <!-- المبلغ -->
                    <div class="col-md-6 form-group">
                        <label for="amount" class="mb-2">{{ get_phrase('المبلغ') }}</label>
                        <input type="number" step="0.01" min="0.01" class="form-control" id="amount" name="amount" required>
                    </div>

                    <!-- ملاحظات -->
                    <div class="col-md-6 form-group">
                        <label for="notes" class="mb-2">{{ get_phrase('ملاحظات (اختياري)') }}</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                    </div>

                    <!-- زر التطبيق -->
                    <div class="col-12 mt-4">
                        <button type="submit" class="btn ol-btn-primary d-flex align-items-center cg-10px">
                            <i class="fas fa-check-circle me-2"></i>
                            {{ get_phrase('تطبيق العملية') }}
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.select2').select2({
            placeholder: '-- اختر مستخدم --',
            allowClear: true
        });
    });
</script>
@endpush