 @extends('layouts.admin')
@push('title', get_phrase('الصفقات'))
@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title"><span class="icon fi fi-rr-megaphone"></span> إدارة الصفقات</h3>
                    <span class="badge bg-primary">{{ $orders->count() }} صفقات</span>
                </div>
                <div class="card-body">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>المستخدم</th>
                                <th>العنوان</th>
                                <th>الفئة</th>
                                <th>السعر</th>
                                <th>الحالة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($orders as $order)
                            <tr>
                                <td>{{ $order->id }}</td>
                                <td>{{ $order->user->name }}</td>
                                <td>{{ $order->title }}</td>
                                <td>{{ $order->category }}</td>
                                <td>{{ $order->price }}$</td>
                                <td>
                                    <span class="badge 
                                        {{ $order->status == 'قيد المراجعة' ? 'bg-warning' : '' }}
                                        {{ $order->status == 'موافق' ? 'bg-success' : '' }}
                                        {{ $order->status == 'مرفوض' ? 'bg-danger' : '' }}
                                    ">
                                        {{ $order->status }}
                                    </span>
                                </td>
                                <td>
                                    <button class="btn btn-info btn-sm" data-bs-toggle="modal" data-bs-target="#orderModal{{ $order->id }}">عرض</button>
                                    <form action="{{ route('admin.orders.destroy', $order->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من الحذف؟')">حذف</button>
                                    </form>
                                </td>
                            </tr>
                            
                            <!-- Modal لعرض التفاصيل وتغيير الحالة -->
                            <div class="modal fade" id="orderModal{{ $order->id }}" tabindex="-1" aria-labelledby="orderModalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="orderModalLabel">تفاصيل الصفقة</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                                        </div>
                                        <div class="modal-body">
                                            <p><strong>المستخدم:</strong> {{ $order->user->name }}</p>
                                            <p><strong>العنوان:</strong> {{ $order->title }}</p>
                                            <p><strong>الوصف:</strong> {{ $order->description }}</p>
                                         
                                            <p><strong>الفئة:</strong> {{ $order->category }}</p>
                                            <p><strong>السعر:</strong> {{ $order->price }}$</p>
                                            
                                            <form action="{{ route('admin.orders.updateStatus', $order->id) }}" method="POST">
                                                @csrf
                                                @method('PUT')
                                                <div class="mb-3">
                                                    <label class="form-label">تغيير الحالة</label>
                                                    <select name="status" class="form-control" onchange="this.form.submit()">
                                                        <option value="قيد المراجعة" {{ $order->status == 'قيد المراجعة' ? 'selected' : '' }}>قيد المراجعة</option>
                                                        <option value="موافق" {{ $order->status == 'موافق' ? 'selected' : '' }}>موافق</option>
                                                        <option value="مرفوض" {{ $order->status == 'مرفوض' ? 'selected' : '' }}>مرفوض</option>
                                                    </select>
                                                </div>
                                            </form>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection


