@extends('layouts.admin')
@section('content')
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    {{ get_phrase('Job Listing') }}
                </h4>
<a href="{{ route('admin.jobs.create') }}" class="btn btn-primary">Add Job</a>
       
               
            </div>
        </div>
    </div>
<div class="container-fluid">
    <div class="card">
       
        <div class="card-body">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Title</th>
                        <th>Company</th>
                        <th>Location</th>
                        <th>Salary</th>
                        <th>Job Type</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($jobs as $job)
                    <tr>
                        <td>{{ $job->title }}</td>
                        <td>{{ $job->company }}</td>
                        <td>{{ $job->location }}</td>
                        <td>{{ $job->salary }}</td>
                        <td>{{ $job->job_type }}</td>
                        <td>
                            <a href="{{ route('admin.jobs.edit', $job->id) }}" class="btn btn-sm btn-warning">Edit</a>
                            <a href="{{ route('admin.jobs.applications', $job->id) }}" class="btn btn-sm btn-info">المتقدمين</a>
                            <form method="POST" action="{{ route('admin.jobs.destroy', $job->id) }}" style="display:inline-block">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            {{ $jobs->links() }}
        </div>
    </div>
</div>
@endsection