@extends('layouts.admin')
@section('content')
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    {{ get_phrase('Esit Job') }}
                </h4>

               
            </div>
        </div>
    </div>
<div class="container-fluid">
    <div class="card">
     
        <div class="card-body">
            <form action="{{ route('admin.jobs.update', $job->id) }}" method="POST">
                @csrf
                <div class="mb-3">
                    <label for="title" class="form-label">Job Title</label>
                    <input type="text" class="form-control" id="title" name="title" value="{{ $job->title }}" required>
                </div>
                <div class="mb-3">
                    <label for="company" class="form-label">Company Name</label>
                    <input type="text" class="form-control" id="company" name="company" value="{{ $job->company }}" required>
                </div>
                <div class="mb-3">
                    <label for="location" class="form-label">Location</label>
                    <input type="text" class="form-control" id="location" name="location" value="{{ $job->location }}" required>
                </div>
                <div class="mb-3">
                    <label for="description" class="form-label">Job Description</label>
                    <textarea class="form-control" id="description" name="description" rows="4" required>{{ $job->description }}</textarea>
                </div>
               <div class="mb-3">
    <label for="salary" class="form-label">Salary</label>
    <input type="number" class="form-control" id="salary" name="salary" value="{{ $job->salary }}" required>
</div>
<div class="mb-3">
    <label for="job_type" class="form-label">Job Type</label>
    <select class="form-control" id="job_type" name="job_type" value="{{ $job->job_type}}" required>
        <option value="Full Time">Full Time</option>
        <option value="Part Time">Part Time</option>
        <option value="Remote">Remote</option>
    </select>
</div>

                <button type="submit" class="btn btn-primary">Update</button>
            </form>
        </div>
    </div>
</div>
@endsection