@extends('layouts.admin')

@section('content')

<div class="ol-card radius-8px">
    <div class="ol-card-body my-3 py-12px px-20px">
        <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
            <h4 class="title fs-16px">
                <i class="fi-rr-users me-2"></i>
                المتقدمين على: {{ $job->title }}
            </h4>
            <a href="{{ route('admin.jobs.index') }}" class="btn btn-secondary">العودة للوظائف</a>
        </div>
    </div>

    <div class="ol-card-body">
        @if($applications->count() > 0)
        <div class="table-responsive">
            <table class="table table-striped align-middle">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>الاسم</th>
                        <th>البريد الإلكتروني</th>
                        <th>السيرة الذاتية</th>
                        <th>تاريخ التقديم</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($applications as $application)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $application->user->name }}</td>
                            <td>{{ $application->user->email }}</td>
                            <td>
                                @if($application->cv_file)
                                <a href="{{ preg_replace('/\/public/', '', asset('storage/app/public/' . $application->cv_file), 1) }}" target="_blank" class="btn btn-sm btn-outline-primary">
    تحميل
</a>

                                @else
                                    لا يوجد
                                @endif
                            </td>
                            <td>{{ $application->created_at->translatedFormat('d M Y - h:i A') }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @else
        <p class="text-muted my-3">لا يوجد متقدمين على هذه الوظيفة بعد.</p>
        @endif
    </div>
</div>

@endsection
