<!-- resources/views/admin/disputes/show.blade.php -->
@extends('layouts.admin')

@section('content')
<div class="container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>تفاصيل النزاع #{{ $dispute->id }}</h1>
        
        @if($dispute->status != 'resolved')
        <form action="{{ route('admin.disputes.resolve', $dispute) }}" method="POST">
            @csrf
            <button type="submit" class="btn btn-success">
                تم الحل
            </button>
        </form>
        @endif
    </div>
    
    <div class="card mb-4">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <p><strong>المحادثة:</strong> #{{ $dispute->conversation_id }}</p>
                    <p><strong>المبلغ:</strong> {{ $dispute->reporter->name }}</p>
                </div>
                <div class="col-md-6">
                    <p><strong>الحالة:</strong> 
                        <span class="badge bg-{{ $dispute->status == 'resolved' ? 'success' : ($dispute->status == 'in_progress' ? 'warning' : 'danger') }}">
                            {{ $statuses[$dispute->status] }}
                        </span>
                    </p>
                    <p><strong>تاريخ الإبلاغ:</strong> {{ $dispute->created_at->format('Y-m-d H:i') }}</p>
                    @if($dispute->resolved_at)
                    <p><strong>تاريخ الحل:</strong> {{ $dispute->resolved_at->format('Y-m-d H:i') }}</p>
                    @endif
                </div>
            </div>
            
            <div class="mt-3">
                <h5>سبب الإبلاغ:</h5>
                <p>{{ $dispute->reason }}</p>
            </div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h4>المحادثة</h4>
        </div>
        <div class="card-body">
            @foreach($messages as $message)
            <div class="mb-3 {{ $message->is_admin ? 'text-end' : '' }}">
                <div class="d-flex {{ $message->is_admin ? 'justify-content-end' : '' }}">
                    <div class="card {{ $message->is_admin ? 'bg-primary text-white' : '' }}" style="max-width: 70%">
                        <div class="card-body">
                            <p class="card-text">{{ $message->body }}</p>
                            <small class="text-muted">
                                {{ $message->user->name }} - {{ $message->created_at->diffForHumans() }}
                            </small>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        
        @if($dispute->status != 'resolved')
        <div class="card-footer">
            <form action="{{ route('admin.disputes.message', $dispute) }}" method="POST">
                @csrf
                <div class="input-group">
                    <input type="text" name="message" class="form-control" placeholder="اكتب رسالة...">
                    <button class="btn btn-primary" type="submit">إرسال</button>
                </div>
            </form>
        </div>
        @endif
    </div>
</div>
@endsection