<!-- resources/views/admin/disputes/index.blade.php -->
@extends('layouts.admin')

@section('content')
<div class="container">
    <h1>إدارة النزاعات</h1>
    
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between">
                <h3>قائمة النزاعات</h3>
                <div>
                    <select class="form-select" onchange="window.location.href='?status='+this.value">
                        <option value="">جميع الحالات</option>
                        @foreach($statuses as $key => $status)
                            <option value="{{ $key }}" {{ request('status') == $key ? 'selected' : '' }}>
                                {{ $status }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
        
        <div class="card-body">
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>المحادثة</th>
                        <th>المبلغ</th>
                        <th>السبب</th>
                        <th>الحالة</th>
                        <th>التاريخ</th>
                        <th>إجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($disputes as $dispute)
                    <tr>
                        <td>{{ $dispute->id }}</td>
                        <td>المحادثة #{{ $dispute->conversation_id }}</td>
                        <td>{{ $dispute->reporter->name }}</td>
                        <td>{{ Str::limit($dispute->reason, 30) }}</td>
                        <td>
                            <span class="badge bg-{{ $dispute->status == 'resolved' ? 'success' : ($dispute->status == 'in_progress' ? 'warning' : 'danger') }}">
                                {{ $statuses[$dispute->status] }}
                            </span>
                        </td>
                        <td>{{ $dispute->created_at->diffForHumans() }}</td>
                        <td>
                            <a href="{{ route('admin.disputes.show', $dispute) }}" class="btn btn-sm btn-primary">
                                عرض
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            
            {{ $disputes->links() }}
        </div>
    </div>
</div>
@endsection