@extends('layouts.admin')

@push('title', get_phrase('انتهاكات لقطات الشاشة'))

@section('content')
<div class="violations-management-container">
    <!-- Header Section -->
    <div class="page-header">
        <div class="header-content">
            <div class="header-text">
                <h1 class="page-title">
                    <i class="fas fa-exclamation-triangle"></i>
                    انتهاكات لقطات الشاشة
                </h1>
                <p class="page-subtitle">مراقبة ومتابعة انتهاكات المستخدمين لسياسات النظام</p>
            </div>
            <div class="header-actions">
                <a href="{{ route('admin.ban_management.index') }}" class="btn btn-primary">
                    <i class="fas fa-user-slash"></i>
                    إدارة الحظر
                </a>
                <a href="{{ route('admin.ban_management.create') }}" class="btn btn-danger">
                    <i class="fas fa-plus"></i>
                    حظر مستخدم جديد
                </a>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card warning">
            <div class="stat-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div class="stat-content">
                <h3>{{ $violations->total() }}</h3>
                <p>إجمالي الانتهاكات</p>
            </div>
        </div>
        
        <div class="stat-card danger">
            <div class="stat-icon">
                <i class="fas fa-camera"></i>
            </div>
            <div class="stat-content">
                <h3>لقطات الشاشة</h3>
                <p>انتهاكات التصوير</p>
            </div>
        </div>
        
        <div class="stat-card info">
            <div class="stat-icon">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stat-content">
                <h3>مراقبة مستمرة</h3>
                <p>تتبع في الوقت الفعلي</p>
            </div>
        </div>
        
        <div class="stat-card total">
            <div class="stat-icon">
                <i class="fas fa-shield-alt"></i>
            </div>
            <div class="stat-content">
                <h3>حماية المحتوى</h3>
                <p>منع الانتهاكات</p>
            </div>
        </div>
    </div>

    <!-- Main Table Container -->
    <div class="table-container">
        <div class="table-header">
            <h3>
                <i class="fas fa-list"></i>
                سجل الانتهاكات
            </h3>
            <div class="table-actions">
                <div class="search-box">
                    <i class="fas fa-search"></i>
                    <form action="{{ route("admin.ban_management.violations") }}" method="GET" class="search-form">
                        <input type="text" name="search" class="search-input" placeholder="البحث عن مستخدم..." value="{{ request("search") }}">
                        <button type="submit" class="search-btn">
                            <i class="fas fa-search"></i>
                        </button>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="table-wrapper">
            <table class="violations-table">
                <thead>
                    <tr>
                        <th>
                            <i class="fas fa-user"></i>
                            المستخدم
                        </th>
                        <th>
                            <i class="fas fa-envelope"></i>
                            البريد الإلكتروني
                        </th>
                        <th>
                            <i class="fas fa-exclamation-circle"></i>
                            نوع الانتهاك
                        </th>
                        <th>
                            <i class="fas fa-clock"></i>
                            وقت الانتهاك
                        </th>
                        <th>
                            <i class="fas fa-info-circle"></i>
                            بيانات إضافية
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($violations as $violation)
                        <tr class="violation-row">
                            <td>
                                <div class="user-info">
                                    @if ($violation->user)
                                        <div class="user-avatar">
                                            @if($violation->user->photo)
                                                <img src="{{ asset($violation->user->photo) }}" alt="user-img" class="user-image">
                                            @else
                                                {{ substr($violation->user->name, 0, 1) }}
                                            @endif
                                        </div>
                                        <div class="user-details">
                                            <span class="user-name">{{ $violation->user->name }}</span>
                                            <span class="user-id">ID: {{ $violation->user->id }}</span>
                                        </div>
                                    @else
                                        <div class="user-info">
                                            <div class="user-avatar deleted">
                                                <i class="fas fa-user-slash"></i>
                                            </div>
                                            <div class="user-details">
                                                <span class="user-name deleted">مستخدم محذوف</span>
                                                <span class="user-id">غير متاح</span>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </td>
                            <td>
                                <span class="email">
                                    {{ $violation->user ? $violation->user->email : "N/A" }}
                                </span>
                            </td>
                            <td>
                                <span class="violation-type">
                                    <i class="fas fa-exclamation-triangle"></i>
                                    {{ $violation->violation_type }}
                                </span>
                            </td>
                            <td>
                                <div class="timestamp">
                                    <span class="date">{{ $violation->violation_timestamp->format("d/m/Y") }}</span>
                                    <span class="time">{{ $violation->violation_timestamp->format("H:i:s") }}</span>
                                </div>
                            </td>
                            <td>
                                <div class="metadata">
                                    @if ($violation->metadata)
                                        @foreach ($violation->metadata as $key => $value)
                                            <div class="metadata-item">
                                                <strong>{{ $key }}:</strong> 
                                                <span>{{ is_array($value) ? json_encode($value) : $value }}</span>
                                            </div>
                                        @endforeach
                                    @else
                                        <span class="no-metadata">لا توجد بيانات إضافية</span>
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="no-data">
                                <div class="no-data-content">
                                    <i class="fas fa-inbox"></i>
                                    <h4>لا توجد انتهاكات</h4>
                                    <p>لم يتم تسجيل أي انتهاكات حتى الآن</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        @if($violations->hasPages())
        <div class="pagination-wrapper">
            {{ $violations->links() }}
        </div>
        @endif
    </div>
</div>

<style>
/* Main Container Styles */
.violations-management-container {
    padding: 2rem;
    background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
    min-height: 100vh;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

/* Page Header */
.page-header {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    border: 1px solid rgba(255,255,255,0.2);
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1rem;
}

.page-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: #2d3748;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 1rem;
}

.page-title i {
    color: #ed8936;
    font-size: 2rem;
}

.page-subtitle {
    color: #718096;
    font-size: 1.1rem;
    margin: 0.5rem 0 0 0;
}

.header-actions {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

/* Buttons */
.btn {
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    border: none;
    font-weight: 600;
    font-size: 0.95rem;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    text-decoration: none;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
}

.btn-danger {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.btn-danger:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(245, 101, 101, 0.4);
}

/* Statistics Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: white;
    border-radius: 16px;
    padding: 1.5rem;
    display: flex;
    align-items: center;
    gap: 1rem;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
    border-left: 4px solid;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.15);
}

.stat-card.warning {
    border-left-color: #ed8936;
}

.stat-card.danger {
    border-left-color: #f56565;
}

.stat-card.info {
    border-left-color: #4299e1;
}

.stat-card.total {
    border-left-color: #48bb78;
}

.stat-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
}

.stat-card.warning .stat-icon {
    background: linear-gradient(135deg, #ed8936, #dd6b20);
    color: white;
}

.stat-card.danger .stat-icon {
    background: linear-gradient(135deg, #f56565, #e53e3e);
    color: white;
}

.stat-card.info .stat-icon {
    background: linear-gradient(135deg, #4299e1, #3182ce);
    color: white;
}

.stat-card.total .stat-icon {
    background: linear-gradient(135deg, #48bb78, #38a169);
    color: white;
}

.stat-content h3 {
    font-size: 2rem;
    font-weight: 700;
    color: #2d3748;
    margin: 0;
}

.stat-content p {
    color: #718096;
    margin: 0;
    font-size: 0.9rem;
}

/* Table Container */
.table-container {
    background: white;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.table-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 2rem;
    border-bottom: 1px solid #e2e8f0;
}

.table-header h3 {
    font-size: 1.8rem;
    font-weight: 600;
    color: #2d3748;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.table-header h3 i {
    color: #ed8936;
}

.search-box {
    position: relative;
    width: 350px;
}

.search-form {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.search-input {
    flex: 1;
    padding: 0.75rem 1rem 0.75rem 2.5rem;
    border: 2px solid #e2e8f0;
    border-radius: 12px;
    font-size: 0.9rem;
    transition: all 0.3s ease;
}

.search-input:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.search-box i {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #a0aec0;
    z-index: 1;
}

.search-btn {
    padding: 0.75rem 1rem;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    border-radius: 12px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.search-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
}

/* Table Styles */
.table-wrapper {
    overflow-x: auto;
    padding: 2rem;
}

.violations-table {
    width: 100%;
    border-collapse: collapse;
    border-spacing: 0;
}

.violations-table th {
    background: #f7fafc;
    padding: 1.5rem 1rem;
    text-align: right;
    font-weight: 600;
    color: #4a5568;
    border-bottom: 2px solid #e2e8f0;
    font-size: 0.95rem;
}

.violations-table th i {
    margin-left: 0.5rem;
    color: #667eea;
}

.violations-table td {
    padding: 1.5rem 1rem;
    border-bottom: 1px solid #e2e8f0;
    vertical-align: middle;
}

.violation-row {
    transition: all 0.3s ease;
}

.violation-row:hover {
    background: #f7fafc;
    transform: translateX(5px);
}

/* User Info Styles */
.user-info {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.user-avatar {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 1.2rem;
    overflow: hidden;
}

.user-avatar.deleted {
    background: linear-gradient(135deg, #a0aec0 0%, #718096 100%);
}

.user-image {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.user-details {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.user-name {
    font-weight: 600;
    color: #2d3748;
    font-size: 1rem;
}

.user-name.deleted {
    color: #a0aec0;
}

.user-id {
    font-size: 0.8rem;
    color: #718096;
}

.email {
    color: #4a5568;
    font-weight: 500;
}

.violation-type {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.5rem 1rem;
    background: #fed7d7;
    color: #742a2a;
    border-radius: 20px;
    font-size: 0.9rem;
    font-weight: 600;
}

.violation-type i {
    color: #f56565;
}

.timestamp {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.date {
    font-weight: 600;
    color: #2d3748;
}

.time {
    font-size: 0.85rem;
    color: #718096;
}

.metadata {
    max-width: 300px;
}

.metadata-item {
    margin-bottom: 0.5rem;
    font-size: 0.9rem;
}

.metadata-item strong {
    color: #4a5568;
}

.metadata-item span {
    color: #718096;
}

.no-metadata {
    color: #a0aec0;
    font-style: italic;
}

/* No Data Styles */
.no-data {
    text-align: center;
    padding: 4rem 2rem;
}

.no-data-content {
    color: #a0aec0;
}

.no-data-content i {
    font-size: 4rem;
    margin-bottom: 1rem;
    color: #e2e8f0;
}

.no-data-content h4 {
    font-size: 1.5rem;
    margin: 0 0 0.5rem 0;
    color: #718096;
}

.no-data-content p {
    font-size: 1rem;
    margin: 0;
}

/* Pagination */
.pagination-wrapper {
    padding: 2rem;
    border-top: 1px solid #e2e8f0;
    display: flex;
    justify-content: center;
}

/* Responsive Design */
@media (max-width: 768px) {
    .violations-management-container {
        padding: 1rem;
    }
    
    .header-content {
        flex-direction: column;
        align-items: stretch;
    }
    
    .header-actions {
        justify-content: center;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .table-header {
        flex-direction: column;
        gap: 1rem;
        align-items: stretch;
    }
    
    .search-box {
        width: 100%;
    }
    
    .violations-table {
        font-size: 0.85rem;
    }
    
    .violations-table th,
    .violations-table td {
        padding: 1rem 0.5rem;
    }
    
    .user-info {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
    }
    
    .user-avatar {
        width: 40px;
        height: 40px;
        font-size: 1rem;
    }
    
    .page-title {
        font-size: 2rem;
    }
}

/* Animation */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table-container {
    animation: fadeInUp 0.6s ease;
}

.stat-card {
    animation: fadeInUp 0.6s ease;
}

.stat-card:nth-child(1) { animation-delay: 0.1s; }
.stat-card:nth-child(2) { animation-delay: 0.2s; }
.stat-card:nth-child(3) { animation-delay: 0.3s; }
.stat-card:nth-child(4) { animation-delay: 0.4s; }

.violation-row {
    animation: fadeInUp 0.4s ease;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Enhanced search functionality
    const searchInput = document.querySelector('.search-input');
    const searchForm = document.querySelector('.search-form');
    
    // Auto-submit search after typing stops
    let searchTimeout;
    searchInput.addEventListener('input', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(() => {
            if (this.value.length >= 2 || this.value.length === 0) {
                searchForm.submit();
            }
        }, 500);
    });
    
    // Table row interactions
    const tableRows = document.querySelectorAll('.violation-row');
    
    tableRows.forEach(row => {
        row.addEventListener('mouseenter', function() {
            this.style.backgroundColor = '#f7fafc';
        });
        
        row.addEventListener('mouseleave', function() {
            this.style.backgroundColor = '';
        });
    });
    
    // Metadata expansion for long content
    const metadataItems = document.querySelectorAll('.metadata-item span');
    
    metadataItems.forEach(item => {
        if (item.textContent.length > 50) {
            const fullText = item.textContent;
            const shortText = fullText.substring(0, 50) + '...';
            
            item.textContent = shortText;
            item.style.cursor = 'pointer';
            item.title = 'انقر لعرض النص كاملاً';
            
            let isExpanded = false;
            item.addEventListener('click', function() {
                if (isExpanded) {
                    this.textContent = shortText;
                    this.title = 'انقر لعرض النص كاملاً';
                } else {
                    this.textContent = fullText;
                    this.title = 'انقر لإخفاء النص';
                }
                isExpanded = !isExpanded;
            });
        }
    });
    
    // Statistics animation on scroll
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };
    
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.transform = 'translateY(0)';
                entry.target.style.opacity = '1';
            }
        });
    }, observerOptions);
    
    document.querySelectorAll('.stat-card').forEach(card => {
        card.style.transform = 'translateY(20px)';
        card.style.opacity = '0';
        card.style.transition = 'all 0.6s ease';
        observer.observe(card);
    });
});
</script>
@endsection

