@extends('layouts.admin')

@push('title', get_phrase('إدارة الحظر'))

@section('content')
<div class="ban-management-container">
    <!-- Header Section -->
    <div class="page-header">
        <div class="header-content">
            <div class="header-text">
                <h1 class="page-title">
                    <i class="fas fa-user-shield"></i>
                    إدارة الحظر
                </h1>
                <p class="page-subtitle">إدارة ومراقبة المستخدمين المحظورين في النظام</p>
            </div>
            <div class="header-actions">
                <a href="{{ route('admin.ban_management.create') }}" class="btn btn-danger">
                    <i class="fas fa-plus-circle"></i>
                    حظر مستخدم جديد
                </a>
                <a href="{{ route('admin.ban_management.violations') }}" class="btn btn-info">
                    <i class="fas fa-alert-circle"></i>
                    عرض الانتهاكات
                </a>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card active">
            <div class="stat-icon">
                <i class="fas fa-user-check"></i>
            </div>
            <div class="stat-content">
                <h3>{{ $bans->where('is_active', true)->count() }}</h3>
                <p>حظر نشط</p>
            </div>
        </div>
        
        <div class="stat-card expired">
            <div class="stat-icon">
                <i class="fas fa-user-times"></i>
            </div>
            <div class="stat-content">
                <h3>{{ $bans->where('is_active', false)->count() }}</h3>
                <p>حظر منتهي</p>
            </div>
        </div>
        
        <div class="stat-card warning">
            <div class="stat-icon">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stat-content">
                <h3>{{ $bans->where('banned_until', '!=', null)->where('banned_until', '>', now())->count() }}</h3>
                <p>حظر مؤقت</p>
            </div>
        </div>
        
        <div class="stat-card total">
            <div class="stat-icon">
                <i class="fas fa-users"></i>
            </div>
            <div class="stat-content">
                <h3>{{ $bans->total() }}</h3>
                <p>إجمالي الحظر</p>
            </div>
        </div>
    </div>

    <!-- Main Table Container -->
    <div class="table-container">
        <div class="table-header">
            <h3>
                <i class="fas fa-list"></i>
                قائمة المستخدمين المحظورين
            </h3>
            <div class="table-actions">
                <div class="search-box">
                    <i class="fas fa-search"></i>
                    <form action="{{ route("admin.ban_management.index") }}" method="GET" class="search-form">
                        <input type="text" name="search" class="search-input" placeholder="البحث عن مستخدم..." value="{{ request("search") }}">
                        <button type="submit" class="search-btn">
                            <i class="fas fa-search"></i>
                        </button>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="table-wrapper">
            <table class="bans-table">
                <thead>
                    <tr>
                        <th>
                            <i class="fas fa-user"></i>
                            المستخدم
                        </th>
                        <th>
                            <i class="fas fa-envelope"></i>
                            البريد الإلكتروني
                        </th>
                        <th>
                            <i class="fas fa-exclamation-circle"></i>
                            سبب الحظر
                        </th>
                        <th>
                            <i class="fas fa-calendar-times"></i>
                            تاريخ انتهاء الحظر
                        </th>
                        <th>
                            <i class="fas fa-toggle-on"></i>
                            الحالة
                        </th>
                        <th>
                            <i class="fas fa-user-cog"></i>
                            بواسطة المشرف
                        </th>
                        <th>
                            <i class="fas fa-calendar-plus"></i>
                            تاريخ الحظر
                        </th>
                        <th>
                            <i class="fas fa-cogs"></i>
                            الإجراءات
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($bans as $ban)
                        <tr class="ban-row">
                            <td>
                                <div class="user-info">
                                    @if ($ban->user)
                                        <div class="user-avatar">
                                            @if($ban->user->photo)
                                                <img src="{{ asset($ban->user->photo) }}" alt="user-img" class="user-image">
                                            @else
                                                {{ substr($ban->user->name, 0, 1) }}
                                            @endif
                                        </div>
                                        <div class="user-details">
                                            <span class="user-name">{{ $ban->user->name }}</span>
                                            <span class="user-id">ID: {{ $ban->user->id }}</span>
                                        </div>
                                    @else
                                        <div class="user-info">
                                            <div class="user-avatar deleted">
                                                <i class="fas fa-user-slash"></i>
                                            </div>
                                            <div class="user-details">
                                                <span class="user-name deleted">مستخدم محذوف</span>
                                                <span class="user-id">غير متاح</span>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </td>
                            <td>
                                <span class="email">
                                    {{ $ban->user ? $ban->user->email : "N/A" }}
                                </span>
                            </td>
                            <td>
                                <span class="ban-reason">
                                    {{ $ban->reason }}
                                </span>
                            </td>
                            <td>
                                <div class="ban-expiry">
                                    @if ($ban->banned_until)
                                        <span class="date">{{ $ban->banned_until->format("d/m/Y") }}</span>
                                        <span class="time">{{ $ban->banned_until->format("H:i") }}</span>
                                        @if ($ban->banned_until->isPast() && $ban->is_active)
                                            <span class="status-badge warning">انتهى (يحتاج لإلغاء التفعيل)</span>
                                        @elseif ($ban->banned_until->isFuture() && $ban->is_active)
                                            <span class="status-badge active">نشط</span>
                                        @endif
                                    @else
                                        <div class="permanent-ban">
                                            <i class="fas fa-infinity"></i>
                                            <span>دائم</span>
                                            @if ($ban->is_active)
                                                <span class="status-badge danger">نشط</span>
                                            @endif
                                        </div>
                                    @endif
                                </div>
                            </td>
                            <td>
                                @if ($ban->is_active)
                                    <span class="status-badge active">
                                        <i class="fas fa-check-circle"></i>
                                        نشط
                                    </span>
                                @else
                                    <span class="status-badge inactive">
                                        <i class="fas fa-times-circle"></i>
                                        غير نشط
                                    </span>
                                @endif
                            </td>
                            <td>
                                <div class="admin-info">
                                    @if($ban->admin)
                                        <span class="admin-name">{{ $ban->admin->name }}</span>
                                    @else
                                        <span class="admin-name unknown">غير محدد</span>
                                    @endif
                                </div>
                            </td>
                            <td>
                                <div class="created-date">
                                    <span class="date">{{ $ban->created_at->format("d/m/Y") }}</span>
                                    <span class="time">{{ $ban->created_at->format("H:i:s") }}</span>
                                </div>
                            </td>
                            <td>
                                <div class="action-buttons">
                                    @if ($ban->is_active)
                                        <form action="{{ route("admin.ban_management.unban", $ban->id) }}" method="POST" class="unban-form">
                                            @csrf
                                            @method("PUT")
                                            <button type="submit" class="btn-action unban" title="إلغاء الحظر" onclick="return confirm('هل أنت متأكد من إلغاء حظر هذا المستخدم؟');">
                                                <i class="fas fa-user-check"></i>
                                            </button>
                                        </form>
                                    @else
                                        <button class="btn-action disabled" disabled title="تم إلغاء الحظر">
                                            <i class="fas fa-check"></i>
                                        </button>
                                        {{-- زر إعادة الحظر --}}
                                        @if ($ban->user) {{-- تأكد من وجود المستخدم قبل محاولة إعادة الحظر --}}
                                            <form action="{{ route('admin.ban_management.reban', $ban->user->id) }}" method="POST" class="reban-form">
                                                @csrf
                                                @method('PUT') {{-- استخدام PUT لطلب التحديث --}}
                                                <button type="submit" class="btn-action reban" title="إعادة الحظر" onclick="return confirm('هل أنت متأكد من إعادة حظر هذا المستخدم؟');">
                                                    <i class="fas fa-ban"></i>
                                                </button>
                                            </form>
                                        @endif
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="no-data">
                                <div class="no-data-content">
                                    <i class="fas fa-inbox"></i>
                                    <h4>لا توجد حالات حظر</h4>
                                    <p>لم يتم حظر أي مستخدم حتى الآن</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        @if($bans->hasPages())
        <div class="pagination-wrapper">
            {{ $bans->links() }}
        </div>
        @endif
    </div>
</div>

<style>
/* Main Container Styles */
.ban-management-container {
    padding: 2rem;
    background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
    min-height: 100vh;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

/* Page Header */
.page-header {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    border: 1px solid rgba(255,255,255,0.2);
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1rem;
}

.page-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: #2d3748;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 1rem;
}

.page-title i {
    color: #667eea;
    font-size: 2rem;
}

.page-subtitle {
    color: #718096;
    font-size: 1.1rem;
    margin: 0.5rem 0 0 0;
}

.header-actions {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

/* Buttons */
.btn {
    padding: 0.75rem 1.5rem;
    border-radius: 12px;
    border: none;
    font-weight: 600;
    font-size: 0.95rem;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    text-decoration: none;
}

.btn-danger {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.btn-danger:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(245, 101, 101, 0.4);
}

.btn-info {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.btn-info:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(66, 153, 225, 0.4);
}

/* Statistics Grid */
.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: white;
    border-radius: 16px;
    padding: 1.5rem;
    display: flex;
    align-items: center;
    gap: 1rem;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
    border-left: 4px solid;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.15);
}

.stat-card.active {
    border-left-color: #48bb78;
}

.stat-card.expired {
    border-left-color: #f56565;
}

.stat-card.warning {
    border-left-color: #ed8936;
}

.stat-card.total {
    border-left-color: #4299e1;
}

.stat-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
}

.stat-card.active .stat-icon {
    background: linear-gradient(135deg, #48bb78, #38a169);
    color: white;
}

.stat-card.expired .stat-icon {
    background: linear-gradient(135deg, #f56565, #e53e3e);
    color: white;
}

.stat-card.warning .stat-icon {
    background: linear-gradient(135deg, #ed8936, #dd6b20);
    color: white;
}

.stat-card.total .stat-icon {
    background: linear-gradient(135deg, #4299e1, #3182ce);
    color: white;
}

.stat-content h3 {
    font-size: 2rem;
    font-weight: 700;
    color: #2d3748;
    margin: 0;
}

.stat-content p {
    color: #718096;
    margin: 0;
    font-size: 0.9rem;
}

/* Table Container */
.table-container {
    background: white;
    border-radius: 20px;
    overflow: hidden;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.table-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 2rem;
    border-bottom: 1px solid #e2e8f0;
}

.table-header h3 {
    font-size: 1.8rem;
    font-weight: 600;
    color: #2d3748;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.table-header h3 i {
    color: #667eea;
}

.search-box {
    position: relative;
    width: 350px;
}

.search-form {
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.search-input {
    flex: 1;
    padding: 0.75rem 1rem 0.75rem 2.5rem;
    border: 2px solid #e2e8f0;
    border-radius: 12px;
    font-size: 0.9rem;
    transition: all 0.3s ease;
}

.search-input:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.search-box i {
    position: absolute;
    left: 1rem;
    top: 50%;
    transform: translateY(-50%);
    color: #a0aec0;
    z-index: 1;
}

.search-btn {
    padding: 0.75rem 1rem;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    border: none;
    border-radius: 12px;
    cursor: pointer;
    transition: all 0.3s ease;
}

.search-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
}

/* Table Styles */
.table-wrapper {
    overflow-x: auto;
    padding: 2rem;
}

.bans-table {
    width: 100%;
    border-collapse: collapse;
    border-spacing: 0;
}

.bans-table th {
    background: #f7fafc;
    padding: 1.5rem 1rem;
    text-align: right;
    font-weight: 600;
    color: #4a5568;
    border-bottom: 2px solid #e2e8f0;
    font-size: 0.95rem;
}

.bans-table th i {
    margin-left: 0.5rem;
    color: #667eea;
}

.bans-table td {
    padding: 1.5rem 1rem;
    border-bottom: 1px solid #e2e8f0;
    vertical-align: middle;
}

.ban-row {
    transition: all 0.3s ease;
}

.ban-row:hover {
    background: #f7fafc;
    transform: translateX(5px);
}

/* User Info Styles */
.user-info {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.user-avatar {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
    font-size: 1.2rem;
    overflow: hidden;
}

.user-avatar.deleted {
    background: linear-gradient(135deg, #a0aec0 0%, #718096 100%);
}

.user-image {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.user-details {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.user-name {
    font-weight: 600;
    color: #2d3748;
    font-size: 1rem;
}

.user-name.deleted {
    color: #a0aec0;
}

.user-id {
    font-size: 0.8rem;
    color: #718096;
}

.email {
    color: #4a5568;
    font-weight: 500;
}

.ban-reason {
    color: #2d3748;
    font-weight: 500;
    max-width: 200px;
    word-wrap: break-word;
}

.ban-expiry {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.permanent-ban {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: #f56565;
    font-weight: 600;
}

.date {
    font-weight: 600;
    color: #2d3748;
}

.time {
    font-size: 0.85rem;
    color: #718096;
}

.status-badge {
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 600;
    display: inline-flex;
    align-items: center;
    gap: 0.25rem;
    margin-top: 0.25rem;
}

.status-badge.active {
    background: #c6f6d5;
    color: #22543d;
}

.status-badge.inactive {
    background: #e2e8f0;
    color: #4a5568;
}

.status-badge.warning {
    background: #fed7aa;
    color: #9c4221;
}

.status-badge.danger {
    background: #fed7d7;
    color: #742a2a;
}

.admin-info .admin-name {
    color: #4a5568;
    font-weight: 500;
}

.admin-info .admin-name.unknown {
    color: #a0aec0;
    font-style: italic;
}

.created-date {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

/* Action Buttons */
.action-buttons {
    display: flex;
    gap: 0.5rem;
    justify-content: center;
}

.btn-action {
    width: 40px;
    height: 40px;
    border: none;
    border-radius: 10px;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
    font-size: 1rem;
}

.btn-action.unban {
    background: linear-gradient(135deg, #48bb78, #38a169);
    color: white;
}

.btn-action.unban:hover {
    transform: scale(1.1);
    box-shadow: 0 8px 25px rgba(72, 187, 120, 0.4);
}

.btn-action.disabled {
    background: #e2e8f0;
    color: #a0aec0;
    cursor: not-allowed;
}

.unban-form {
    display: inline-block;
}

/* No Data Styles */
.no-data {
    text-align: center;
    padding: 4rem 2rem;
}

.no-data-content {
    color: #a0aec0;
}

.no-data-content i {
    font-size: 4rem;
    margin-bottom: 1rem;
    color: #e2e8f0;
}

.no-data-content h4 {
    font-size: 1.5rem;
    margin: 0 0 0.5rem 0;
    color: #718096;
}

.no-data-content p {
    font-size: 1rem;
    margin: 0;
}

/* Pagination */
.pagination-wrapper {
    padding: 2rem;
    border-top: 1px solid #e2e8f0;
    display: flex;
    justify-content: center;
}

/* Responsive Design */
@media (max-width: 768px) {
    .ban-management-container {
        padding: 1rem;
    }
    
    .header-content {
        flex-direction: column;
        align-items: stretch;
    }
    
    .header-actions {
        justify-content: center;
    }
    
    .stats-grid {
        grid-template-columns: 1fr;
    }
    
    .table-header {
        flex-direction: column;
        gap: 1rem;
        align-items: stretch;
    }
    
    .search-box {
        width: 100%;
    }
    
    .bans-table {
        font-size: 0.85rem;
    }
    
    .bans-table th,
    .bans-table td {
        padding: 1rem 0.5rem;
    }
    
    .user-info {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
    }
    
    .user-avatar {
        width: 40px;
        height: 40px;
        font-size: 1rem;
    }
    
    .page-title {
        font-size: 2rem;
    }
}

/* Animation */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.table-container {
    animation: fadeInUp 0.6s ease;
}

.stat-card {
    animation: fadeInUp 0.6s ease;
}

.stat-card:nth-child(1) { animation-delay: 0.1s; }
.stat-card:nth-child(2) { animation-delay: 0.2s; }
.stat-card:nth-child(3) { animation-delay: 0.3s; }
.stat-card:nth-child(4) { animation-delay: 0.4s; }

.ban-row {
    animation: fadeInUp 0.4s ease;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Enhanced search functionality
    const searchInput = document.querySelector('.search-input');
    const searchForm = document.querySelector('.search-form');
    
    // Auto-submit search after typing stops
    let searchTimeout;
    searchInput.addEventListener('input', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(() => {
            if (this.value.length >= 2 || this.value.length === 0) {
                searchForm.submit();
            }
        }, 500);
    });
    
    // Table row interactions
    const tableRows = document.querySelectorAll('.ban-row');
    
    tableRows.forEach(row => {
        row.addEventListener('mouseenter', function() {
            this.style.backgroundColor = '#f7fafc';
        });
        
        row.addEventListener('mouseleave', function() {
            this.style.backgroundColor = '';
        });
    });
    
    // Enhanced unban confirmation
    const unbanForms = document.querySelectorAll('.unban-form');
    
    unbanForms.forEach(form => {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const userName = this.closest('tr').querySelector('.user-name').textContent;
            
            // Create custom confirmation dialog
            const confirmDialog = document.createElement('div');
            confirmDialog.className = 'confirm-dialog';
            confirmDialog.innerHTML = `
                <div class="confirm-content">
                    <div class="confirm-header">
                        <i class="fas fa-exclamation-triangle"></i>
                        <h3>تأكيد إلغاء الحظر</h3>
                    </div>
                    <div class="confirm-body">
                        <p>هل أنت متأكد من إلغاء حظر المستخدم:</p>
                        <strong>${userName}</strong>
                    </div>
                    <div class="confirm-actions">
                        <button class="btn-confirm" onclick="confirmUnban(this)">نعم، إلغاء الحظر</button>
                        <button class="btn-cancel" onclick="cancelUnban(this)">إلغاء</button>
                    </div>
                </div>
            `;
            
            document.body.appendChild(confirmDialog);
            confirmDialog.style.display = 'flex';
            
            // Store form reference
            confirmDialog.dataset.formId = Array.from(unbanForms).indexOf(this);
        });
    });
    
    // Global functions for confirmation dialog
    window.confirmUnban = function(button) {
        const dialog = button.closest('.confirm-dialog');
        const formIndex = parseInt(dialog.dataset.formId);
        const form = unbanForms[formIndex];
        
        // Submit the form
        form.submit();
        
        // Remove dialog
        dialog.remove();
    };
    
    window.cancelUnban = function(button) {
        const dialog = button.closest('.confirm-dialog');
        dialog.remove();
    };
    
    // Statistics animation on scroll
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };
    
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.transform = 'translateY(0)';
                entry.target.style.opacity = '1';
            }
        });
    }, observerOptions);
    
    document.querySelectorAll('.stat-card').forEach(card => {
        card.style.transform = 'translateY(20px)';
        card.style.opacity = '0';
        card.style.transition = 'all 0.6s ease';
        observer.observe(card);
    });
    
    // Status badge hover effects
    const statusBadges = document.querySelectorAll('.status-badge');
    
    statusBadges.forEach(badge => {
        badge.addEventListener('mouseenter', function() {
            this.style.transform = 'scale(1.05)';
        });
        
        badge.addEventListener('mouseleave', function() {
            this.style.transform = 'scale(1)';
        });
    });
});
</script>

<style>
/* Confirmation Dialog Styles */
.confirm-dialog {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 1000;
    backdrop-filter: blur(5px);
}

.confirm-content {
    background: white;
    border-radius: 20px;
    padding: 2rem;
    max-width: 400px;
    width: 90%;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    animation: modalSlideIn 0.3s ease;
}

.confirm-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.confirm-header i {
    color: #ed8936;
    font-size: 2rem;
}

.confirm-header h3 {
    margin: 0;
    color: #2d3748;
    font-size: 1.5rem;
}

.confirm-body {
    margin-bottom: 2rem;
    text-align: center;
}

.confirm-body p {
    color: #4a5568;
    margin: 0 0 0.5rem 0;
}

.confirm-body strong {
    color: #2d3748;
    font-size: 1.1rem;
}

.confirm-actions {
    display: flex;
    gap: 1rem;
    justify-content: center;
}

.btn-confirm {
    padding: 0.75rem 1.5rem;
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
    border: none;
    border-radius: 12px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-confirm:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(245, 101, 101, 0.4);
}

.btn-cancel {
    padding: 0.75rem 1.5rem;
    background: linear-gradient(135deg, #a0aec0 0%, #718096 100%);
    color: white;
    border: none;
    border-radius: 12px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-cancel:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(160, 174, 192, 0.4);
}

@keyframes modalSlideIn {
    from {
        opacity: 0;
        transform: translateY(-50px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
</style>
@endsection

