<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
{
    Schema::create('orders', function (Blueprint $table) {
        $table->id();
        $table->unsignedBigInteger('user_id'); // المستخدم الذي أرسل الطلب
        $table->unsignedBigInteger('ad_id'); // الإعلان المرتبط بالطلب
        $table->string('status')->default('قيد المراجعة'); // حالة الطلب
        $table->timestamps();

        // مفاتيح خارجية
        $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        $table->foreign('ad_id')->references('id')->on('ads')->onDelete('cascade');
    });
}

public function down()
{
    Schema::dropIfExists('orders');
}
};
